/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IImageProvider;
import gama.core.outputs.layers.AbstractLayer;
import gama.core.outputs.layers.ILayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.MeshLayerData;
import gama.core.runtime.IScope;
import gama.core.util.matrix.IField;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import java.util.Collections;

public class MeshLayer
extends AbstractLayer {
    public MeshLayer(ILayerStatement iLayerStatement) {
        super(iLayerStatement);
    }

    @Override
    protected ILayerData createData() {
        return new MeshLayerData(this.definition);
    }

    @Override
    public MeshLayerData getData() {
        return (MeshLayerData)super.getData();
    }

    @Override
    public void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) {
        MeshLayerData meshLayerData = this.getData();
        IField iField = meshLayerData.getElevationMatrix(iGraphicsScope);
        IImageProvider iImageProvider = meshLayerData.textureFile();
        MeshDrawingAttributes meshDrawingAttributes = new MeshDrawingAttributes("", false);
        meshDrawingAttributes.setGrayscaled(meshLayerData.isGrayScaled());
        meshDrawingAttributes.setEmpty(meshLayerData.isWireframe());
        meshDrawingAttributes.setBorder(meshLayerData.drawLines() ? meshLayerData.getLineColor() : null);
        if (iImageProvider != null) {
            meshDrawingAttributes.setTextures(Collections.singletonList(iImageProvider));
        }
        meshDrawingAttributes.setLocation(meshLayerData.getPosition());
        meshDrawingAttributes.setTriangulated(meshLayerData.isTriangulated());
        meshDrawingAttributes.setWithText(meshLayerData.isShowText());
        meshDrawingAttributes.setXYDimension(meshLayerData.getDimension());
        meshDrawingAttributes.setSize(Scaling3D.of(meshLayerData.getSize()));
        meshDrawingAttributes.setScale(meshLayerData.getScale());
        meshDrawingAttributes.setColors(meshLayerData.getColor());
        meshDrawingAttributes.setSmooth(meshLayerData.getSmooth());
        meshDrawingAttributes.setNoData(meshLayerData.getNoDataValue());
        meshDrawingAttributes.setAbove(meshLayerData.getAbove());
        iGraphics.drawField(iField, meshDrawingAttributes);
    }

    @Override
    public String getType() {
        return "Field layer";
    }
}

