/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.concurrent;

import gama.core.kernel.simulation.SimulationAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SimulationLocal<T> {
    protected T initialValue(IScope iScope) {
        return null;
    }

    private SimulationAgent getRootOf(IScope iScope) {
        if (iScope == null) {
            return null;
        }
        return iScope.getSimulation();
    }

    public static <S> SimulationLocal<S> withInitial(GAMA.InScope<S> inScope) {
        return new SuppliedSimulationLocal<S>(inScope);
    }

    public T get(IScope iScope) {
        SimulationAgent simulationAgent = this.getRootOf(iScope);
        if (simulationAgent == null) {
            return null;
        }
        Map<SimulationLocal<T>, T> map = this.getMap(simulationAgent);
        if (map != null && map.containsKey(this)) {
            return map.get(this);
        }
        return this.setInitialValue(iScope);
    }

    private Map<SimulationLocal<T>, T> getMap(SimulationAgent simulationAgent) {
        return simulationAgent.getSimulationLocalMap();
    }

    private T setInitialValue(IScope iScope) {
        T t = this.initialValue(iScope);
        SimulationAgent simulationAgent = this.getRootOf(iScope);
        if (simulationAgent == null) {
            return null;
        }
        Map<SimulationLocal<T>, T> map = this.getMap(simulationAgent);
        if (map != null) {
            map.put(this, t);
        } else {
            this.createMap(simulationAgent, t);
        }
        return t;
    }

    public void set(IScope iScope, T t) {
        SimulationAgent simulationAgent = this.getRootOf(iScope);
        if (simulationAgent == null) {
            return;
        }
        Map<SimulationLocal<T>, T> map = this.getMap(simulationAgent);
        if (map != null) {
            map.put(this, t);
        } else {
            this.createMap(simulationAgent, t);
        }
    }

    private void createMap(SimulationAgent simulationAgent, T t) {
        HashMap<SimulationLocal, T> hashMap = new HashMap<SimulationLocal, T>();
        hashMap.put(this, t);
        simulationAgent.setSimulationLocalMap(hashMap);
    }

    public boolean isPresent(IScope iScope) {
        SimulationAgent simulationAgent = this.getRootOf(iScope);
        if (simulationAgent == null) {
            return false;
        }
        Map<SimulationLocal<T>, T> map = this.getMap(simulationAgent);
        return map != null && map.containsKey(this);
    }

    public void remove(IScope iScope) {
        SimulationAgent simulationAgent = this.getRootOf(iScope);
        if (simulationAgent == null) {
            return;
        }
        Map<SimulationLocal<T>, T> map = this.getMap(simulationAgent);
        if (map != null) {
            map.remove(this);
        }
    }

    static final class SuppliedSimulationLocal<T>
    extends SimulationLocal<T> {
        private final GAMA.InScope<? extends T> supplier;

        SuppliedSimulationLocal(GAMA.InScope<? extends T> inScope) {
            this.supplier = Objects.requireNonNull(inScope);
        }

        @Override
        protected T initialValue(IScope iScope) {
            return this.supplier.run(iScope);
        }
    }
}

