/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import com.google.common.collect.ImmutableSet;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.util.GamaList;
import gama.core.util.GamaListArrayWrapper;
import gama.core.util.GamaListCollectionWrapper;
import gama.core.util.GamaListWrapper;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.dev.FLAGS;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class GamaListFactory {
    private static final int DEFAULT_SIZE = 4;
    public static final IList EMPTY_LIST = GamaListFactory.wrap(Types.NO_TYPE, Collections.EMPTY_LIST);
    static final Set<Collector.Characteristics> CH = ImmutableSet.of((Object)((Object)Collector.Characteristics.IDENTITY_FINISH));
    public static final Collector<Object, IList<Object>, IList<Object>> TO_GAMA_LIST = GamaListFactory.toGamaList();

    public static <T> Collector<T, IList<T>, IList<T>> toGamaList() {
        return new Collector<T, IList<T>, IList<T>>(){

            @Override
            public Supplier<IList<T>> supplier() {
                return GamaListFactory::create;
            }

            @Override
            public BiConsumer<IList<T>, T> accumulator() {
                return List::add;
            }

            @Override
            public BinaryOperator<IList<T>> combiner() {
                return (iList, iList2) -> {
                    iList.addAll(iList2);
                    return iList;
                };
            }

            @Override
            public Function<IList<T>, IList<T>> finisher() {
                return iList -> iList;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return CH;
            }
        };
    }

    public static <T> IList<T> create(IType iType, Stream<T> stream) {
        return stream.collect(TO_GAMA_LIST);
    }

    public static <T> IList<T> createWithoutCasting(IType iType, T ... TArray) {
        IList<T> iList = GamaListFactory.create(iType, TArray.length);
        Collections.addAll(iList, TArray);
        return iList;
    }

    public static IList<Integer> createWithoutCasting(IType iType, int[] nArray) {
        IList<Integer> iList = GamaListFactory.create(iType, nArray.length);
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            iList.add(n3);
            ++n2;
        }
        return iList;
    }

    public static IList<Double> createWithoutCasting(IType iType, double[] dArray) {
        IList<Double> iList = GamaListFactory.create(iType, dArray.length);
        double[] dArray2 = dArray;
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray2[n2];
            iList.add(d);
            ++n2;
        }
        return iList;
    }

    public static <T> IList<T> createWithoutCasting(IType iType, Iterable<T> iterable) {
        IList<T> iList = GamaListFactory.create(iType);
        for (T t : iterable) {
            iList.add(t);
        }
        return iList;
    }

    private static void castAndAdd(IScope iScope, IList iList, Object object) {
        iList.addValue(iScope, object);
    }

    public static IList create(IScope iScope, IType iType, IContainer iContainer) {
        if (iContainer == null) {
            return GamaListFactory.create(iType);
        }
        if (FLAGS.CAST_CONTAINER_CONTENTS && GamaType.requiresCasting(iType, iContainer.getGamlType().getContentType())) {
            IList iList = GamaListFactory.create(iType);
            for (Object ValueType : iContainer.iterable(iScope)) {
                GamaListFactory.castAndAdd(iScope, iList, ValueType);
            }
            return iList;
        }
        return GamaListFactory.createWithoutCasting(iType, iContainer.iterable(iScope));
    }

    public static <T> IList<T> create(IScope iScope, IType iType, IList<T> iList) {
        return GamaListFactory.create(iScope, iType, iList);
    }

    public static <T> IList<T> create(IScope iScope, IType iType, Iterable<T> iterable) {
        if (!FLAGS.CAST_CONTAINER_CONTENTS) {
            return GamaListFactory.createWithoutCasting(iType, iterable);
        }
        IList<T> iList = GamaListFactory.create(iType);
        for (T t : iterable) {
            GamaListFactory.castAndAdd(iScope, iList, t);
        }
        return iList;
    }

    public static <T> IList<T> create(IScope iScope, IType iType, Iterator<T> iterator) {
        IList<T> iList = GamaListFactory.create(iType);
        if (iterator != null) {
            while (iterator.hasNext()) {
                T t = iterator.next();
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, t);
                    continue;
                }
                iList.add(t);
            }
        }
        return iList;
    }

    public static <T> IList<T> create(IScope iScope, IType iType, Enumeration<T> enumeration) {
        IList<T> iList = GamaListFactory.create(iType);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                T t = enumeration.nextElement();
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, t);
                    continue;
                }
                iList.add(t);
            }
        }
        return iList;
    }

    @SafeVarargs
    public static <T> IList<T> create(IScope iScope, IType iType, T ... TArray) {
        if (!FLAGS.CAST_CONTAINER_CONTENTS) {
            return GamaListFactory.createWithoutCasting(iType, TArray);
        }
        IList<T> iList = GamaListFactory.create(iType, TArray == null ? 0 : TArray.length);
        if (TArray != null) {
            T[] TArray2 = TArray;
            int n = TArray.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray2[n2];
                GamaListFactory.castAndAdd(iScope, iList, t);
                ++n2;
            }
        }
        return iList;
    }

    public static <T> IList<T> create(IScope iScope, IType iType, char[] cArray) {
        IList<T> iList = GamaListFactory.create(iType, cArray == null ? 0 : cArray.length);
        if (cArray != null) {
            char[] cArray2 = cArray;
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray2[n2];
                String string = String.valueOf(c);
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, string);
                } else {
                    iList.add(string);
                }
                ++n2;
            }
        }
        return iList;
    }

    public static IList create(IScope iScope, IType iType, byte[] byArray) {
        IList iList = GamaListFactory.create(iType, byArray == null ? 0 : byArray.length);
        if (byArray != null) {
            byte[] byArray2 = byArray;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray2[n2];
                Integer n3 = by;
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, n3);
                } else {
                    iList.add(n3);
                }
                ++n2;
            }
        }
        return iList;
    }

    public static IList create(IScope iScope, IType iType, int[] nArray) {
        IList iList = GamaListFactory.create(iType, nArray == null ? 0 : nArray.length);
        if (nArray != null) {
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray2[n2];
                Integer n4 = n3;
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, n4);
                } else {
                    iList.add(n4);
                }
                ++n2;
            }
        }
        return iList;
    }

    public static IList create(IScope iScope, IType iType, long[] lArray) {
        IList iList = GamaListFactory.create(iType, lArray == null ? 0 : lArray.length);
        if (lArray != null) {
            long[] lArray2 = lArray;
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long l = lArray2[n2];
                Integer n3 = Long.valueOf(l).intValue();
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, n3);
                } else {
                    iList.add(n3);
                }
                ++n2;
            }
        }
        return iList;
    }

    public static IList create(IScope iScope, IType iType, float[] fArray) {
        IList iList = GamaListFactory.create(iType, fArray == null ? 0 : fArray.length);
        if (fArray != null) {
            float[] fArray2 = fArray;
            int n = fArray.length;
            int n2 = 0;
            while (n2 < n) {
                float f = fArray2[n2];
                Double d = f;
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, d);
                } else {
                    iList.add(d);
                }
                ++n2;
            }
        }
        return iList;
    }

    public static IList create(IScope iScope, IType iType, double[] dArray) {
        IList iList = GamaListFactory.create(iType, dArray == null ? 0 : dArray.length);
        if (dArray != null) {
            double[] dArray2 = dArray;
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray2[n2];
                Double d2 = d;
                if (FLAGS.CAST_CONTAINER_CONTENTS) {
                    GamaListFactory.castAndAdd(iScope, iList, d2);
                } else {
                    iList.add(d2);
                }
                ++n2;
            }
        }
        return iList;
    }

    public static IList create(IScope iScope, IExpression iExpression, Integer n, boolean bl) {
        if (iExpression == null) {
            return GamaListFactory.create(Types.NO_TYPE, (int)n);
        }
        Object[] objectArray = new Object[n.intValue()];
        IType<?> iType = iExpression.getGamlType();
        if (iExpression.isConst()) {
            Object object = iExpression.value(iScope);
            GamaExecutorService.executeThreaded(() -> IntStream.range(0, objectArray.length).parallel().forEach(n -> {
                objectArray[n] = object;
            }));
        } else if (bl) {
            GamaExecutorService.executeThreaded(() -> IntStream.range(0, objectArray.length).forEach(n -> {
                objectArray[n] = iExpression.value(iScope);
            }));
        } else {
            int n2 = 0;
            while (n2 < objectArray.length) {
                objectArray[n2] = iExpression.value(iScope);
                ++n2;
            }
        }
        return GamaListFactory.create(iScope, iType, objectArray);
    }

    public static <T> IList<T> create(IType iType, int n) {
        return new GamaList(n, iType);
    }

    public static <T> IList<T> create(IType iType) {
        return GamaListFactory.create(iType, 4);
    }

    public static <T> IList<T> create(Class<T> clazz) {
        return GamaListFactory.create(Types.get(clazz));
    }

    public static <T> IList<T> create() {
        return GamaListFactory.create(Types.NO_TYPE);
    }

    public static <E> IList<E> wrap(IType iType, List<E> list) {
        return new GamaListWrapper<E>(list, iType);
    }

    public static <E> IList<E> wrap(IType iType, E ... EArray) {
        return new GamaListArrayWrapper<E>(EArray, iType);
    }

    public static <E> IList<E> wrap(IType iType, Collection<E> collection) {
        if (collection instanceof List) {
            return GamaListFactory.wrap(iType, (List)collection);
        }
        return new GamaListCollectionWrapper<E>(collection, iType);
    }

    public static boolean equals(IList iList, IList iList2) {
        Iterator iterator = iList.iterator();
        Iterator iterator2 = iList2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    public static List create(IContainerType iContainerType, int n) {
        return GamaListFactory.create(iContainerType.getGamlType(), n);
    }

    public static class GamaListSupplier
    implements Supplier<IList> {
        final IType t;

        public GamaListSupplier(IType iType) {
            this.t = iType;
        }

        @Override
        public IList get() {
            return GamaListFactory.create(this.t);
        }
    }
}

