/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph.layout;

import gama.core.common.interfaces.IValue;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.IGraph;
import gama.gaml.operators.Containers;
import gama.gaml.operators.Graphs;
import gama.gaml.operators.Maths;
import gama.gaml.operators.Random;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class LayoutGrid {
    private final IGraph<IShape, IShape> graph;
    private final double coeffSq;
    private final IShape envelopeGeometry;

    public LayoutGrid(IGraph<IShape, IShape> iGraph, IShape iShape, double d) {
        this.graph = iGraph;
        this.envelopeGeometry = iShape;
        this.coeffSq = d;
    }

    public void applyLayout(IScope iScope) {
        IShape iShape22;
        IList<IShape> iList = null;
        IMap iMap = GamaMapFactory.create();
        while ((iList = SpatialTransformations.toSquares(iScope, this.envelopeGeometry, Maths.round((double)this.graph.getVertices().size() * this.coeffSq), false)).size() < this.graph.getVertices().size()) {
        }
        Object object = null;
        int n = -1;
        IdentityHashMap<IShape, Integer> identityHashMap = new IdentityHashMap<IShape, Integer>();
        int n2 = this.graph.getVertices().size();
        for (IShape iShape22 : this.graph.getVertices()) {
            int n3 = this.graph.degreeOf(iShape22);
            iMap.put(iShape22, iShape22.getLocation().copy(iScope));
            identityHashMap.put(iShape22, n3);
            if (n3 <= n) continue;
            n = n3;
            object = iShape22;
        }
        iShape22 = SpatialQueries.overlapping(iScope, iList, this.envelopeGeometry.getLocation()).firstValue(iScope);
        iList.remove(iShape22);
        iMap.put(object, iShape22.getLocation());
        ArrayList arrayList = new ArrayList();
        ArrayList<IShape> arrayList2 = new ArrayList<IShape>();
        arrayList2.addAll(this.graph.getVertices());
        arrayList2.remove(object);
        ArrayList<IShape> arrayList3 = new ArrayList<IShape>();
        arrayList3.add((IShape)object);
        while (arrayList3.size() < n2) {
            Object object2;
            IValue iValue = Graphs.predecessorsOf(iScope, this.graph, object);
            iValue.addAll(Graphs.successorsOf(iScope, this.graph, object));
            iValue = Random.opShuffle(iScope, (IContainer)iValue);
            Iterator iterator = iValue.iterator();
            while (iterator.hasNext()) {
                object2 = (IShape)iterator.next();
                if (!arrayList2.contains(object2)) continue;
                iShape22 = SpatialQueries.closest_to(iScope, iList, (IShape)iMap.get(object));
                iList.remove(iShape22);
                iMap.put(object2, iShape22.getLocation());
                arrayList.add(object2);
                arrayList2.remove(object2);
            }
            if (arrayList2.isEmpty()) break;
            n = -1;
            Collections.shuffle(arrayList, iScope.getRandom().getGenerator());
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                object2 = (IShape)iterator2.next();
                int n3 = (Integer)identityHashMap.get(object2);
                if (n3 < n) continue;
                n = n3;
                object = object2;
            }
            arrayList.remove(object);
            arrayList3.add((IShape)object);
            if (!arrayList.isEmpty()) continue;
            object2 = null;
            n = -1;
            Collections.shuffle(arrayList2, iScope.getRandom().getGenerator());
            for (IShape iShape : arrayList2) {
                int n4 = (Integer)identityHashMap.get(iShape);
                if (n4 <= n) continue;
                n = n4;
                object2 = iShape;
            }
            arrayList2.remove(object2);
            arrayList.add(object2);
            LinkedHashSet linkedHashSet = new LinkedHashSet(Graphs.predecessorsOf(iScope, this.graph, object2));
            linkedHashSet.addAll(Graphs.successorsOf(iScope, this.graph, object2));
            linkedHashSet.removeAll(arrayList3);
            linkedHashSet.removeAll(arrayList);
            if (!linkedHashSet.isEmpty()) {
                IList iList2 = GamaListFactory.create(Types.POINT);
                for (IShape iShape : linkedHashSet) {
                    iList2.add((GamaPoint)iMap.get(iShape));
                }
                GamaPoint gamaPoint = (GamaPoint)Containers.opMean(iScope, iList2);
                iShape22 = iList.size() > 0 ? SpatialQueries.closest_to(iScope, iList, gamaPoint.getLocation()) : (IShape)iMap.get(object2);
            } else {
                iShape22 = iList.size() > 0 ? iList.anyValue(iScope) : (IShape)iMap.get(object2);
            }
            iList.remove(iShape22);
            iMap.put(object2, iShape22.getLocation());
        }
        for (IValue iValue : iMap.keySet()) {
            iValue.setLocation((GamaPoint)iMap.get(iValue));
        }
    }
}

