/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.tree;

import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.tree.GamaNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class GamaTree<T> {
    private GamaNode<T> root;

    public static <T> GamaTree<T> withRoot(GamaNode<T> gamaNode) {
        GamaTree<T> gamaTree = new GamaTree<T>();
        gamaTree.setRoot(gamaNode);
        return gamaTree;
    }

    public static <T> GamaTree<T> withRoot(T t) {
        GamaTree<T> gamaTree = new GamaTree<T>();
        gamaTree.setRoot(t);
        return gamaTree;
    }

    public GamaNode<T> getRoot() {
        return this.root;
    }

    public void setRoot(GamaNode<T> gamaNode) {
        this.root = gamaNode;
    }

    public GamaNode<T> setRoot(T t) {
        return this.setRoot(t, GamaNode.DEFAULT_WEIGHT);
    }

    public GamaNode<T> setRoot(T t, Integer n) {
        GamaNode<T> gamaNode = new GamaNode<T>(t, n);
        this.setRoot(gamaNode);
        return gamaNode;
    }

    public void visit(Order order, Consumer<GamaNode<T>> consumer) {
        if (this.root == null) {
            return;
        }
        if (order == Order.PRE_ORDER) {
            this.visitPreOrder(this.root, consumer);
        } else if (order == Order.POST_ORDER) {
            this.visitPostOrder(this.root, consumer);
        }
    }

    public void visitPreOrder(GamaNode<T> gamaNode, Consumer<GamaNode<T>> consumer) {
        consumer.accept(gamaNode);
        for (GamaNode<T> gamaNode2 : gamaNode.getChildren()) {
            this.visitPreOrder(gamaNode2, consumer);
        }
    }

    public void visitPostOrder(GamaNode<T> gamaNode, Consumer<GamaNode<T>> consumer) {
        for (GamaNode<T> gamaNode2 : gamaNode.getChildren()) {
            this.visitPostOrder(gamaNode2, consumer);
        }
        consumer.accept(gamaNode);
    }

    public List<GamaNode<T>> list(Order order) {
        if (this.root == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GamaNode<T>> arrayList = new ArrayList<GamaNode<T>>();
        this.visit(order, arrayList::add);
        return arrayList;
    }

    public Map<GamaNode<T>, Integer> mapByDepth(Order order) {
        if (this.root == null) {
            return Collections.EMPTY_MAP;
        }
        IMap iMap = GamaMapFactory.create();
        if (order == Order.PRE_ORDER) {
            this.mapPreOrderWithDepth(this.root, iMap, 0);
        } else if (order == Order.POST_ORDER) {
            this.mapPostOrderWithDepth(this.root, iMap, 0);
        }
        return iMap;
    }

    private void mapPreOrderWithDepth(GamaNode<T> gamaNode, Map<GamaNode<T>, Integer> map, int n) {
        map.put(gamaNode, n);
        for (GamaNode<T> gamaNode2 : gamaNode.getChildren()) {
            this.mapPreOrderWithDepth(gamaNode2, map, n + 1);
        }
    }

    private void mapPostOrderWithDepth(GamaNode<T> gamaNode, Map<GamaNode<T>, Integer> map, int n) {
        for (GamaNode<T> gamaNode2 : gamaNode.getChildren()) {
            this.mapPostOrderWithDepth(gamaNode2, map, n + 1);
        }
        map.put(gamaNode, n);
    }

    public String toString() {
        return this.root.toString();
    }

    public void dispose() {
        if (this.root != null) {
            this.root.dispose();
            this.root = null;
        }
    }

    public static enum Order {
        PRE_ORDER,
        POST_ORDER;

    }
}

