/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.finite_state_machine;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import java.util.Arrays;
import java.util.List;

@GamlAnnotations.inside(kinds={11, 3})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a condition to be fulfilled to have a transition to another given state")}), @GamlAnnotations.facet(name="to", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the next state")})}, omissible="when")
@validator(value=TransitionValidator.class)
@serializer(value=TransitionSerializer.class)
@GamlAnnotations.doc(value="In an FSM architecture, `transition` specifies the next state of the life cycle. The transition occurs when the condition is fulfilled. The embedded statements are executed when the transition is triggered.", usages={@GamlAnnotations.usage(value="In the following example, the transition is executed when after 2 steps:", examples={@GamlAnnotations.example(value="state s_init initial: true {", isExecutable=false), @GamlAnnotations.example(value="\twrite state;", isExecutable=false), @GamlAnnotations.example(value="\ttransition to: s1 when: (cycle > 2) {", isExecutable=false), @GamlAnnotations.example(value="\t\twrite \"transition s_init -> s1\";", isExecutable=false), @GamlAnnotations.example(value="\t}", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"enter", "state", "exit"})
public class FsmTransitionStatement
extends AbstractStatementSequence {
    static final List<String> states = Arrays.asList("state", "user_panel");
    final IExpression when;
    public static final String TRANSITION = "transition";
    protected static final String TO = "to";

    public FsmTransitionStatement(IDescription iDescription) {
        super(iDescription);
        String string = this.getLiteral(TO);
        this.setName(string);
        this.when = this.getFacet("when") != null ? this.getFacet("when") : IExpressionFactory.TRUE_EXPR;
    }

    public boolean evaluatesTrueOn(IScope iScope) throws GamaRuntimeException {
        return Cast.asBool(iScope, this.when.value(iScope));
    }

    public static class TransitionSerializer
    extends SymbolSerializer<SymbolDescription> {
        static String[] MY_FACETS = new String[]{"to", "when"};

        @Override
        protected void serializeFacets(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            String[] stringArray = MY_FACETS;
            int n = MY_FACETS.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = this.serializeFacetValue(symbolDescription, string, bl);
                if (string2 != null) {
                    stringBuilder.append(this.serializeFacetKey(symbolDescription, string, bl)).append(string2).append(" ");
                }
                ++n2;
            }
        }
    }

    public static class TransitionValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            IDescription iDescription2 = iDescription.getEnclosingDescription();
            String string = iDescription2.getKeyword();
            if (!states.contains(string)) {
                iDescription.error("Transitions cannot be declared inside  " + string, "gaml.wrong.parent.issue");
                return;
            }
            IExpression iExpression = iDescription2.getFacetExpr("final");
            if (IExpressionFactory.TRUE_EXPR.equals(iExpression)) {
                iDescription.error("Transitions are not accepted in final states", "gaml.wrong.parent.issue");
                return;
            }
            String string2 = iDescription.getLitteral(FsmTransitionStatement.TO);
            SpeciesDescription speciesDescription = iDescription.getSpeciesContext();
            if (!speciesDescription.hasBehavior(string2)) {
                iDescription.error("Behavior " + string2 + " does not exist in " + speciesDescription.getName(), "gaml.unknown.behavior.issue", FsmTransitionStatement.TO, string2, speciesDescription.getName());
            }
        }
    }
}

