/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.weighted_tasks;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.architecture.weighted_tasks.WeightedTasksArchitecture;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import java.util.Arrays;
import java.util.List;

@GamlAnnotations.inside(symbols={"weighted_tasks", "sorted_tasks", "probabilistic_tasks"}, kinds={0, 13, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="weight", type={2}, optional=false, doc={@GamlAnnotations.doc(value="the priority level of the task")}), @GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the task")})}, omissible="name")
@validator(value=TaskValidator.class)
@GamlAnnotations.doc(value="As reflex, a task is a sequence of statements that can be executed, at each time step, by the agent. If an agent owns several tasks, the scheduler chooses a task to execute based on its current priority weight value.")
public class WeightedTaskStatement
extends AbstractStatementSequence {
    static final List<String> ALLOWED_ARCHITECTURES = Arrays.asList("sorted_tasks", "weighted_tasks", "probabilistic_tasks");
    protected static final String WEIGHT = "weight";
    protected static final String TASK = "task";
    protected IExpression weight;

    public WeightedTaskStatement(IDescription iDescription) {
        super(iDescription);
        this.setName(iDescription.getName());
        this.weight = this.getFacet(WEIGHT);
    }

    public Double computeWeight(IScope iScope) throws GamaRuntimeException {
        return Cast.asFloat(iScope, this.weight.value(iScope));
    }

    public static class TaskValidator
    extends IDescriptionValidator.ValidNameValidator {
        @Override
        public void validate(IDescription iDescription) {
            if (!IDescriptionValidator.Assert.nameIsValid(iDescription)) {
                return;
            }
            SpeciesDescription speciesDescription = iDescription.getSpeciesContext();
            SkillDescription skillDescription = speciesDescription.getControl();
            if (!WeightedTasksArchitecture.class.isAssignableFrom(skillDescription.getJavaBase())) {
                iDescription.error("A " + iDescription.getKeyword() + " can only be defined in a task-controlled species  (one of" + String.valueOf(ALLOWED_ARCHITECTURES) + ")", "gaml.wrong.context.issue");
            }
        }
    }
}

