/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.GamlProperties;
import gama.annotations.precompiler.ISymbolKind;
import gama.core.util.GamaMapFactory;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.ISymbolConstructor;
import gama.gaml.compilation.IValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.AbstractProto;
import gama.gaml.descriptions.FacetProto;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.factories.SymbolFactory;
import gama.gaml.interfaces.IGamlDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SymbolProto
extends AbstractProto {
    static IValidator NULL_VALIDATOR = (iDescription, eObject, iExpressionArray) -> true;
    private final ISymbolConstructor constructor;
    private IValidator validator;
    private SymbolSerializer serializer;
    private final SymbolFactory factory;
    private final int kind;
    private final boolean hasSequence;
    private final boolean hasArgs;
    private final boolean hasScope;
    private final boolean isRemoteContext;
    private final boolean isUniqueInContext;
    private final ImmutableSet<String> contextKeywords;
    private final boolean[] contextKinds = new boolean[17];
    private final Map<String, FacetProto> possibleFacets;
    private final ImmutableList<String> mandatoryFacets;
    private final String omissibleFacet;
    private final boolean isPrimitive;
    private final boolean isBreakable;
    private final boolean isContinuable;
    private final boolean isVar;
    static final List<Integer> ids = Arrays.asList(-200, -201, -204, -203);
    public static final Set<String> BREAKABLE_STATEMENTS = new HashSet<String>();
    public static final Set<String> CONTINUABLE_STATEMENTS = new HashSet<String>();

    public SymbolProto(Class clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, FacetProto[] facetProtoArray, String string, String[] stringArray, int[] nArray, boolean bl6, boolean bl7, boolean bl8, ISymbolConstructor iSymbolConstructor, String string2, String string3) {
        super(string2, clazz, string3);
        int n2;
        this.factory = DescriptionFactory.getFactory(n);
        this.constructor = iSymbolConstructor;
        this.isBreakable = bl;
        this.isContinuable = bl2;
        if (bl2) {
            CONTINUABLE_STATEMENTS.add(string2);
        }
        if (bl) {
            BREAKABLE_STATEMENTS.add(string2);
        }
        this.isRemoteContext = bl6;
        this.hasSequence = bl3;
        this.isPrimitive = "primitive".equals(string2);
        this.hasArgs = bl4;
        this.omissibleFacet = string;
        this.isUniqueInContext = bl7;
        this.kind = n;
        this.isVar = ISymbolKind.Variable.KINDS.contains(n);
        boolean bl9 = this.hasScope = !bl5;
        if (facetProtoArray != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.possibleFacets = GamaMapFactory.createUnordered();
            FacetProto[] facetProtoArray2 = facetProtoArray;
            int n3 = facetProtoArray.length;
            n2 = 0;
            while (n2 < n3) {
                FacetProto facetProto = facetProtoArray2[n2];
                this.possibleFacets.put(facetProto.name, facetProto);
                facetProto.setOwner(this.getTitle());
                facetProto.setClass(clazz);
                if (!facetProto.optional) {
                    builder.add((Object)facetProto.name);
                }
                ++n2;
            }
            this.mandatoryFacets = builder.build();
        } else {
            this.possibleFacets = null;
            this.mandatoryFacets = null;
        }
        this.contextKeywords = ImmutableSet.copyOf((Object[])stringArray);
        Arrays.fill(this.contextKinds, false);
        int[] nArray2 = nArray;
        n2 = nArray.length;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray2[n4];
            this.contextKinds[n5] = true;
            ++n4;
        }
    }

    public SymbolFactory getFactory() {
        return this.factory;
    }

    public boolean isRemoteContext() {
        return this.isRemoteContext;
    }

    public boolean isLabel(String string) {
        FacetProto facetProto = this.getPossibleFacets().get(string);
        if (facetProto == null) {
            return false;
        }
        return facetProto.isLabel();
    }

    public boolean isId(String string) {
        FacetProto facetProto = this.getPossibleFacets().get(string);
        if (facetProto == null) {
            return false;
        }
        return facetProto.isId();
    }

    public boolean hasSequence() {
        return this.hasSequence;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean hasArgs() {
        return this.hasArgs;
    }

    public boolean hasScope() {
        return this.hasScope;
    }

    public Map<String, FacetProto> getPossibleFacets() {
        return this.possibleFacets == null ? Collections.emptyMap() : this.possibleFacets;
    }

    public boolean isTopLevel() {
        return this.kind == 3;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    public ISymbolConstructor getConstructor() {
        return this.constructor;
    }

    public String getOmissible() {
        return this.omissibleFacet;
    }

    @Override
    public String getTitle() {
        return this.isVar ? (String)ISymbolKind.Variable.KINDS_AS_STRING.get(this.kind) + " declaration" : "Statement " + this.getName();
    }

    @Override
    public GamlAnnotations.doc getDocAnnotation() {
        if (this.support == null) {
            return null;
        }
        GamlAnnotations.doc doc2 = super.getDocAnnotation();
        if (doc2 == null) {
            GamlAnnotations.doc[] docArray;
            if (this.support.isAnnotationPresent(GamlAnnotations.action.class)) {
                GamlAnnotations.doc[] docArray2 = this.support.getAnnotation(GamlAnnotations.action.class).doc();
                if (docArray2.length > 0) {
                    doc2 = docArray2[0];
                }
            } else if (this.support.isAnnotationPresent(GamlAnnotations.symbol.class) && (docArray = this.support.getAnnotation(GamlAnnotations.symbol.class).doc()).length > 0) {
                doc2 = docArray[0];
            }
        }
        return doc2;
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        if (this.documentation == null) {
            this.documentation = new IGamlDescription.RegularDoc(super.getDocumentation().toString());
            ArrayList<FacetProto> arrayList = new ArrayList<FacetProto>(this.getPossibleFacets().values());
            Collections.sort(arrayList);
            for (FacetProto facetProto : arrayList) {
                if (facetProto.internal) continue;
                this.documentation.set("Possible facets: ", facetProto.name, facetProto.getDocumentation());
            }
        }
        return this.documentation;
    }

    public boolean isBreakable() {
        return this.isBreakable;
    }

    public boolean isContinuable() {
        return this.isContinuable;
    }

    IValidator getValidator() {
        if (this.validator == null) {
            validator validator2 = this.support.getAnnotation(validator.class);
            try {
                this.validator = validator2 != null ? validator2.value().getConstructor(new Class[0]).newInstance(new Object[0]) : NULL_VALIDATOR;
            }
            catch (Exception exception) {}
        }
        return this.validator;
    }

    public SymbolSerializer getSerializer() {
        if (this.serializer == null) {
            serializer serializer2 = this.support.getAnnotation(serializer.class);
            try {
                if (serializer2 != null) {
                    this.serializer = serializer2.value().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {}
        }
        return this.serializer;
    }

    public void setSerializer(SymbolSerializer symbolSerializer) {
        this.serializer = symbolSerializer;
    }

    public ISymbol create(SymbolDescription symbolDescription) {
        return this.constructor.create(symbolDescription);
    }

    public boolean canBeDefinedIn(IDescription iDescription) {
        return this.contextKinds[iDescription.getKind()] || this.contextKeywords.contains((Object)iDescription.getKeyword());
    }

    public boolean shouldBeDefinedIn(String string) {
        return this.contextKeywords.contains((Object)string);
    }

    public boolean isUniqueInContext() {
        return this.isUniqueInContext;
    }

    public FacetProto getFacet(String string) {
        return this.possibleFacets == null ? null : this.possibleFacets.get(string);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (FacetProto facetProto : this.possibleFacets.values()) {
            String string = facetProto.serializeToGaml(bl);
            if (string.isEmpty()) continue;
            stringBuilder.append(string).append(" ");
        }
        return this.getName() + " " + stringBuilder.toString();
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        gamlProperties.put("statements", this.name);
    }

    public ImmutableList<String> getMandatoryFacets() {
        return this.mandatoryFacets;
    }
}

