/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.tree.GamaNode;
import gama.gaml.operators.Cast;

public class Displays {
    public static final String HORIZONTAL = "horizontal";
    public static final String VERTICAL = "vertical";
    public static final String STACK = "stack";

    @GamlAnnotations.operator(value={"horizontal"}, expected_content_type={2}, can_be_const=false)
    @GamlAnnotations.doc(value="Creates a horizontal layout node (a sash). Sashes can contain any number (> 1) of other elements: stacks, horizontal or vertical sashes, or display indices. Each element is represented by a pair in the map, where the key is the element and the value its weight within the sash")
    public static GamaNode<String> horizontal(IScope iScope, IMap<Object, Integer> iMap) {
        return Displays.buildSashFromMap(iScope, HORIZONTAL, iMap);
    }

    @GamlAnnotations.operator(value={"vertical"}, expected_content_type={2}, can_be_const=false)
    @GamlAnnotations.doc(value="Creates a vertical layout node (a sash). Sashes can contain any number (> 1) of other elements: stacks, horizontal or vertical sashes, or display indices. Each element is represented by a pair in the map, where the key is the element and the value its weight within the sash")
    public static GamaNode<String> vertical(IScope iScope, IMap<Object, Integer> iMap) {
        return Displays.buildSashFromMap(iScope, VERTICAL, iMap);
    }

    @GamlAnnotations.operator(value={"stack"}, can_be_const=false)
    @GamlAnnotations.doc(value="Creates a stack layout node. Stacks can only contain one or several indices of displays (without weight)")
    public static GamaNode<String> stack(IScope iScope, IList<Integer> iList) {
        if (iList == null) {
            throw GamaRuntimeException.error("Nodes of a stack cannot be nil", iScope);
        }
        if (iList.isEmpty()) {
            throw GamaRuntimeException.error("At least one display must be defined in the stack", iScope);
        }
        GamaNode<String> gamaNode = new GamaNode<String>(STACK);
        iList.forEach(n -> {
            GamaNode<String> gamaNode2 = gamaNode.addChild(String.valueOf(n));
        });
        return gamaNode;
    }

    @GamlAnnotations.operator(value={"stack"}, can_be_const=false)
    @GamlAnnotations.doc(value="Creates a stack layout node. Accepts the same argument as `horizontal` or `vertical` (a map of display indices and weights) but the weights are not taken into account")
    public static GamaNode<String> stack(IScope iScope, IMap<Object, Integer> iMap) {
        if (iMap == null) {
            throw GamaRuntimeException.error("Nodes of a stack cannot be nil", iScope);
        }
        if (iMap.isEmpty()) {
            throw GamaRuntimeException.error("At least one display must be defined in the stack", iScope);
        }
        GamaNode<String> gamaNode = new GamaNode<String>(STACK);
        iMap.forEach((object, n) -> {
            GamaNode<String> gamaNode2 = gamaNode.addChild(String.valueOf(object));
        });
        return gamaNode;
    }

    private static GamaNode<String> buildSashFromMap(IScope iScope, String string, IMap<Object, Integer> iMap) {
        if (iMap == null) {
            throw GamaRuntimeException.error("Nodes of a " + string + " layout cannot be nil", iScope);
        }
        if (iMap.size() < 2) {
            throw GamaRuntimeException.error("At least two elements must be defined in this " + string + " layout", iScope);
        }
        GamaNode<String> gamaNode = new GamaNode<String>(string);
        iMap.forEach((object, n) -> {
            if (object instanceof GamaNode) {
                GamaNode gamaNode2 = (GamaNode)object;
                gamaNode2.setWeight(Cast.asInt(iScope, n));
                gamaNode2.attachTo(gamaNode);
            } else {
                Integer n2 = Cast.asInt(iScope, object);
                gamaNode.addChild(String.valueOf(n2), Cast.asInt(iScope, n));
            }
        });
        return gamaNode;
    }
}

