/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaDate;
import gama.gaml.operators.Dates;
import gama.gaml.types.GamaKmlExport;

public class KmlOp {
    @GamlAnnotations.operator(value={"add_geometry"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="Define the kml export manager with new geometry", see={"add_3Dmodel", "add_icon", "add_label"}, masterDoc=true)
    public static GamaKmlExport addShape(IScope iScope, GamaKmlExport gamaKmlExport, IShape iShape, double d, GamaColor gamaColor, GamaColor gamaColor2, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        if (gamaKmlExport == null || iShape == null) {
            return gamaKmlExport;
        }
        String string = iShape.stringValue(iScope) + ":" + gamaDate.toString();
        gamaKmlExport.defStyle(string, d, gamaColor, gamaColor2);
        gamaKmlExport.addGeometry(iScope, iShape.toString(), gamaDate, gamaDate2, iShape, string, iShape.getDepth() == null ? 0.0 : iShape.getDepth());
        return gamaKmlExport;
    }

    @GamlAnnotations.operator(value={"add_geometry"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="the kml export manager with new geometry: take the following argument: (kml, geometry,linewidth, linecolor,fillcolor, end date)", see={"add_3Dmodel", "add_icon", "add_label"})
    public static GamaKmlExport addShape(IScope iScope, GamaKmlExport gamaKmlExport, IShape iShape, double d, GamaColor gamaColor, GamaColor gamaColor2, GamaDate gamaDate) throws GamaRuntimeException {
        GamaDate gamaDate2 = iScope.getClock().getCurrentDate();
        return KmlOp.addShape(iScope, gamaKmlExport, iShape, d, gamaColor, gamaColor2, gamaDate2, gamaDate);
    }

    @GamlAnnotations.operator(value={"add_geometry"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="the kml export manager with new geometry: take the following argument: (kml, geometry,linewidth, linecolor,fillcolor)", see={"add_3Dmodel", "add_icon", "add_label"})
    public static GamaKmlExport addShape(IScope iScope, GamaKmlExport gamaKmlExport, IShape iShape, double d, GamaColor gamaColor, GamaColor gamaColor2) throws GamaRuntimeException {
        GamaDate gamaDate = iScope.getClock().getCurrentDate();
        GamaDate gamaDate2 = Dates.plusDuration(iScope, gamaDate, iScope.getClock().getStepInSeconds());
        return KmlOp.addShape(iScope, gamaKmlExport, iShape, d, gamaColor, gamaColor2, gamaDate, gamaDate2);
    }

    @GamlAnnotations.operator(value={"add_geometry"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="the kml export manager with new geometry: take the following argument: (kml, geometry, linecolor,fillcolor)", see={"add_3Dmodel", "add_icon", "add_label"})
    public static GamaKmlExport addShape(IScope iScope, GamaKmlExport gamaKmlExport, IShape iShape, GamaColor gamaColor, GamaColor gamaColor2) throws GamaRuntimeException {
        return KmlOp.addShape(iScope, gamaKmlExport, iShape, 1.0, gamaColor, gamaColor2);
    }

    @GamlAnnotations.operator(value={"add_geometry"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="the kml export manager with new geometry: take the following argument: (kml, geometry,linewidth, color)", see={"add_3Dmodel", "add_icon", "add_label"})
    public static GamaKmlExport addShape(IScope iScope, GamaKmlExport gamaKmlExport, IShape iShape, double d, GamaColor gamaColor) throws GamaRuntimeException {
        return KmlOp.addShape(iScope, gamaKmlExport, iShape, d, gamaColor, gamaColor);
    }

    @GamlAnnotations.operator(value={"add_3Dmodel"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="the kml export manager with new 3D model: specify the 3D model (collada) to add to the kml", see={"add_geometry", "add_icon", "add_label"}, masterDoc=true)
    public static GamaKmlExport add3DModel(IScope iScope, GamaKmlExport gamaKmlExport, GamaPoint gamaPoint, double d, double d2, String string, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        if (gamaKmlExport == null || gamaPoint == null || string == null || string.isEmpty()) {
            return gamaKmlExport;
        }
        gamaKmlExport.add3DModel(iScope, gamaPoint, d2, d, gamaDate, gamaDate2, string);
        return gamaKmlExport;
    }

    @GamlAnnotations.operator(value={"add_3Dmodel"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="Kml export with a 3D model", see={"add_geometry", "add_icon", "add_label"})
    public static GamaKmlExport add3DModel(IScope iScope, GamaKmlExport gamaKmlExport, GamaPoint gamaPoint, double d, double d2, String string) throws GamaRuntimeException {
        GamaDate gamaDate = iScope.getClock().getCurrentDate();
        GamaDate gamaDate2 = Dates.plusDuration(iScope, gamaDate, iScope.getClock().getStepInSeconds());
        return KmlOp.add3DModel(iScope, gamaKmlExport, gamaPoint, d, d2, string, gamaDate, gamaDate2);
    }

    @GamlAnnotations.operator(value={"add_icon"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="Define the kml export manager with new icons", see={"add_geometry", "add_icon"}, masterDoc=true)
    public static GamaKmlExport addIcon(IScope iScope, GamaKmlExport gamaKmlExport, GamaPoint gamaPoint, double d, double d2, String string, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        if (gamaKmlExport == null || gamaPoint == null || string == null || string.isEmpty()) {
            return gamaKmlExport;
        }
        String string2 = gamaPoint.stringValue(iScope) + ":" + gamaDate.toString();
        gamaKmlExport.defIconStyle(string2, FileUtils.constructAbsoluteFilePath(iScope, string, true), d, d2);
        gamaKmlExport.addLabel(iScope, gamaPoint, gamaDate, gamaDate2, "", "", string2);
        return gamaKmlExport;
    }

    @GamlAnnotations.operator(value={"add_icon"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="the kml export manager with new icons: take the following argument: (kml, location (point),orientation (float), scale (float), file_path (string))", see={"add_geometry", "add_icon"})
    public static GamaKmlExport addIcon(IScope iScope, GamaKmlExport gamaKmlExport, GamaPoint gamaPoint, double d, double d2, String string) throws GamaRuntimeException {
        GamaDate gamaDate = iScope.getClock().getCurrentDate();
        GamaDate gamaDate2 = Dates.plusDuration(iScope, gamaDate, iScope.getClock().getStepInSeconds());
        return KmlOp.addIcon(iScope, gamaKmlExport, gamaPoint, d, d2, string, gamaDate, gamaDate2);
    }
}

