/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="color", type={6}, doc={@GamlAnnotations.doc(value="An optional color to highlight the agent. Note that this color will become the default color for further higlight operations")}, optional=true), @GamlAnnotations.facet(name="value", type={11}, optional=false, doc={@GamlAnnotations.doc(value="The agent to hightlight")})}, omissible="value")
@GamlAnnotations.doc(value="Allows to highlight the agent passed in parameter in all available displays, optionaly setting a color. Passing 'nil' for the agent will remove the current highlight", usages={@GamlAnnotations.usage(value="Highlighting an agent", examples={@GamlAnnotations.example(value="highlight my_species(0) color: #blue;")})})
public class HighlightStatement
extends AbstractStatement {
    final IExpression value = this.getFacet("value");
    final IExpression color = this.getFacet("color");

    @Override
    public String getTrace(IScope iScope) {
        return "";
    }

    public HighlightStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        if (iAgent != null && !iAgent.dead()) {
            GamaColor gamaColor;
            IAgent iAgent2 = Cast.asAgent(iScope, this.value.value(iScope));
            if (this.color != null && (gamaColor = Cast.asColor(iScope, this.color.value(iScope))) != null) {
                GamaPreferences.Displays.CORE_HIGHLIGHT.set(gamaColor);
            }
            GAMA.getGui().setHighlightedAgent(iAgent2);
        }
        return this.value.value(iScope);
    }
}

