/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IStatement;

public class RemoteSequence
extends AbstractStatementSequence {
    final ThreadLocal<IAgent> myself = new ThreadLocal();

    public RemoteSequence(IDescription iDescription) {
        super(iDescription);
    }

    public IAgent getMyself() {
        return this.myself.get();
    }

    @Override
    public void setMyself(IAgent iAgent) {
        this.myself.set(iAgent);
    }

    @Override
    public void leaveScope(IScope iScope) {
        this.myself.set(null);
        super.leaveScope(iScope);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        iScope.addVarWithValue("myself", this.myself.get());
        Object object = null;
        IStatement[] iStatementArray = this.commands;
        int n = this.commands.length;
        int n2 = 0;
        while (n2 < n) {
            IStatement iStatement = iStatementArray[n2];
            ExecutionResult executionResult = iScope.execute(iStatement);
            if (!executionResult.passed()) {
                return object;
            }
            FlowStatus flowStatus = iScope.getAndClearContinueStatus();
            if (iScope.interrupted() || flowStatus == FlowStatus.BREAK) {
                return object;
            }
            if (flowStatus != FlowStatus.CONTINUE) {
                object = executionResult.getValue();
            }
            ++n2;
        }
        return object;
    }
}

