/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.morris;

import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.operators.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;

public final class Morris {
    public static final int DEFAULT_LEVELS = 4;
    protected List<Map<String, Object>> simulationSamples;
    protected List<String> parametersNames;
    private final int nblevels;
    private Map<String, List<Double>> outputs;
    protected Map<String, Map<String, Double>> mu;
    protected Map<String, Map<String, Double>> mu_star;
    protected Map<String, Map<String, Double>> sigma;

    private Morris(int n) {
        this.nblevels = n;
        this.mu = new HashMap<String, Map<String, Double>>();
        this.mu_star = new HashMap<String, Map<String, Double>>();
        this.sigma = new HashMap<String, Map<String, Double>>();
    }

    public Morris(List<Map<String, Object>> list, int n) {
        this(n);
        this.simulationSamples = new ArrayList<Map<String, Object>>(list);
        this.parametersNames = ((Map)this.simulationSamples.stream().findAny().get()).keySet().stream().toList();
    }

    public Morris(File file, int n, int n2, IScope iScope) {
        this(n2);
        this.simulationSamples = new ArrayList<Map<String, Object>>();
        this.parametersNames = new ArrayList<String>();
        this.outputs = new LinkedHashMap<String, List<Double>>();
        try {
            FileReader fileReader = null;
            fileReader = new FileReader(file, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            List<String> list = this.readMorrisCsvHeader(bufferedReader, n);
            this.readMorrisCsvContent(bufferedReader, n, list);
        }
        catch (FileNotFoundException fileNotFoundException) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.error(fileNotFoundException.getMessage(), iScope), true);
        }
        catch (IOException iOException) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.error(iOException.getMessage(), iScope), true);
        }
    }

    private void readMorrisCsvContent(BufferedReader bufferedReader, int n, List<String> list) throws NumberFormatException, IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split(",");
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = list.get(n2);
                if (n2 < n) {
                    linkedHashMap.put(string2, stringArray[n2]);
                } else {
                    this.outputs.get(string2).add(Double.parseDouble(stringArray[n2].toString()));
                }
                ++n2;
            }
            this.simulationSamples.add(linkedHashMap);
        }
    }

    private List<String> readMorrisCsvHeader(BufferedReader bufferedReader, int n) throws IOException {
        String string = bufferedReader.readLine();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            String[] stringArray = string.split(",");
            int n2 = 0;
            while (n2 < stringArray.length) {
                arrayList.add(stringArray[n2]);
                if (n2 < n) {
                    this.parametersNames.add(stringArray[n2]);
                } else {
                    this.outputs.put(stringArray[n2], new ArrayList());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public void setOutputs(Map<String, List<Double>> map, IScope iScope) {
        if (this.simulationSamples == null || this.simulationSamples.isEmpty()) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.error("[MORRIS] Cannot setup outputs before the morris sample", iScope), true);
        }
        this.outputs = map;
    }

    public List<Map<String, Map<String, Double>>> evaluate() {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        this.simulationSamples.forEach(map -> {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            IntStream.range(0, this.parametersNames.size()).forEach(n -> {
                Object v = map.get(this.parametersNames.get(n));
                if (Objects.equals(v.toString(), "false")) {
                    linkedHashMap.put(this.parametersNames.get(n), 0.0);
                } else if (Objects.equals(v.toString(), "true")) {
                    linkedHashMap.put(this.parametersNames.get(n), 1.0);
                } else {
                    linkedHashMap.put(this.parametersNames.get(n), Double.parseDouble(v.toString()));
                }
            });
            arrayList.add(linkedHashMap);
        });
        double d = (double)this.nblevels / (2.0 * ((double)this.nblevels - 1.0));
        int n2 = ((Map)arrayList.get(0)).size();
        int n3 = (int)Math.round((double)this.simulationSamples.size() / ((double)n2 + 1.0));
        int n4 = (int)Math.round((double)this.simulationSamples.size() / (double)n3);
        for (Map.Entry<String, List<Double>> entry : this.outputs.entrySet()) {
            List<Map<String, Double>> list = this.compute_elementary_effects(arrayList, entry.getValue(), n4, d, this.parametersNames, this.simulationSamples);
            Map<String, List<Double>> map2 = this.transformListMapToMapList(list, this.parametersNames);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            IntStream.range(0, this.parametersNames.size()).forEach(n -> {
                double d = 0.0;
                List list = (List)map2.get(this.parametersNames.get(n));
                for (Double d2 : list) {
                    d += d2.doubleValue();
                }
                linkedHashMap.put(this.parametersNames.get(n), d / (double)list.size());
            });
            this.mu.put(entry.getKey(), linkedHashMap);
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            IntStream.range(0, this.parametersNames.size()).forEach(n -> {
                double d = 0.0;
                List list = (List)map2.get(this.parametersNames.get(n));
                for (Double d2 : list) {
                    d += Math.abs(d2);
                }
                linkedHashMap2.put(this.parametersNames.get(n), d / (double)list.size());
            });
            this.mu_star.put(entry.getKey(), linkedHashMap2);
            LinkedHashMap linkedHashMap3 = new LinkedHashMap();
            IntStream.range(0, this.parametersNames.size()).forEach(n -> {
                double d = 0.0;
                List list = (List)map2.get(this.parametersNames.get(n));
                for (Double d2 : list) {
                    d += Math.pow(d2 - (Double)linkedHashMap.get(this.parametersNames.get(n)), 2.0);
                }
                d = Math.sqrt(d / (double)(list.size() - 1));
                linkedHashMap3.put(this.parametersNames.get(n), d);
            });
            this.sigma.put(entry.getKey(), linkedHashMap3);
        }
        return List.of(this.mu, this.mu_star, this.sigma);
    }

    public String buildReportString(String string) {
        if ("txt".equalsIgnoreCase(string)) {
            return this.buildTextReportString();
        }
        return this.buildOtherReportString();
    }

    private String buildOtherReportString() {
        StringBuilder stringBuilder = new StringBuilder();
        char c = ',';
        stringBuilder.append("output").append(c);
        stringBuilder.append("parameter").append(c);
        stringBuilder.append("\u00b5").append(c);
        stringBuilder.append("\u00b5").append("*").append(c);
        stringBuilder.append("\u03c3").append(Strings.LN);
        for (String string : this.outputs.keySet()) {
            for (String string2 : this.parametersNames) {
                stringBuilder.append(string).append(c);
                stringBuilder.append(string2).append(c);
                stringBuilder.append(this.mu.get(string).get(string2)).append(c);
                stringBuilder.append(this.mu_star.get(string).get(string2)).append(c);
                stringBuilder.append(this.sigma.get(string).get(string2)).append(Strings.LN);
            }
        }
        return stringBuilder.toString();
    }

    private String buildTextReportString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MORRIS ANALYSIS :").append(Strings.LN);
        for (Map.Entry<String, List<Double>> entry : this.outputs.entrySet()) {
            Map<String, Double> map3;
            stringBuilder.append(Strings.LN);
            stringBuilder.append("Result for output :" + String.valueOf(entry)).append(Strings.LN);
            Map<String, Double> map2 = this.mu.get(entry.getKey());
            stringBuilder.append("\u00b5 :").append(Strings.LN);
            for (String string : map2.keySet()) {
                stringBuilder.append("\t").append(string).append(" : ").append(map2.get(string)).append(Strings.LN);
            }
            Map<String, Double> object2 = this.mu_star.get(entry.getKey());
            stringBuilder.append("\u00b5 * :").append(Strings.LN);
            for (Map<String, Double> map3 : object2.keySet()) {
                stringBuilder.append("\t").append((String)((Object)map3)).append(" : ").append(object2.get(map3)).append(Strings.LN);
            }
            map3 = this.sigma.get(entry.getKey());
            stringBuilder.append("\u03c3 :").append(Strings.LN);
            for (String string : map3.keySet()) {
                stringBuilder.append("\t").append(string).append(" : ").append(map3.get(string)).append(Strings.LN);
            }
        }
        return stringBuilder.toString();
    }

    private Map<String, List<Double>> transformListMapToMapList(List<Map<String, Double>> list, List<String> list2) {
        HashMap<String, List<Double>> hashMap = new HashMap<String, List<Double>>();
        int n = 0;
        while (n < list2.size()) {
            ArrayList arrayList = new ArrayList();
            int n2 = n;
            list.forEach(map -> arrayList.add((Double)map.get(list2.get(n2))));
            hashMap.put(list2.get(n), arrayList);
            ++n;
        }
        return hashMap;
    }

    private List<Map<String, Double>> calc_results_difference(List<Map<String, Double>> list, List<Map<String, Double>> list2, List<String> list3) {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        int n2 = 0;
        while (n2 < list2.size()) {
            Map<String, Double> map = list2.get(n2);
            Map<String, Double> map2 = list.get(n2);
            HashMap hashMap = new HashMap();
            IntStream.range(0, list3.size()).forEach(n -> {
                double d = (Double)map2.get(list3.get(n)) - (Double)map.get(list3.get(n));
                hashMap.put((String)list3.get(n), d);
            });
            arrayList.add(hashMap);
            ++n2;
        }
        return arrayList;
    }

    private List<Map<String, Double>> reorganize_output_matrix(List<List<Double>> list, List<List<Map<String, Boolean>>> list2, List<List<Map<String, Boolean>>> list4, boolean bl, List<String> list5) {
        ArrayList<List<Map<String, Boolean>>> arrayList = new ArrayList<List<Map<String, Boolean>>>(list2);
        ArrayList<List<Map<String, Boolean>>> arrayList2 = new ArrayList<List<Map<String, Boolean>>>(list4);
        if (bl) {
            IntStream.range(0, list4.size()).forEach(n2 -> {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                IntStream.range(0, list5.size()).forEach(n -> {
                    Boolean bl = linkedHashMap.put((String)list5.get(n), false);
                });
                ((List)arrayList.get(n2)).add(0, linkedHashMap);
                ((List)arrayList2.get(n2)).add(((List)arrayList2.get(n2)).size(), linkedHashMap);
            });
        } else {
            IntStream.range(0, list4.size()).forEach(n2 -> {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                IntStream.range(0, list5.size()).forEach(n -> {
                    Boolean bl = linkedHashMap.put((String)list5.get(n), false);
                });
                ((List)arrayList.get(n2)).add(((List)arrayList2.get(n2)).size(), linkedHashMap);
                ((List)arrayList2.get(n2)).add(0, linkedHashMap);
            });
        }
        ArrayList arrayList3 = new ArrayList();
        IntStream.range(0, arrayList2.size()).forEach(n -> {
            ArrayList arrayList = new ArrayList();
            List list5 = (List)arrayList.get(n);
            List list6 = (List)arrayList2.get(n);
            IntStream.range(0, list5.size()).forEach(n2 -> {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                Map map = (Map)list5.get(n2);
                Map map2 = (Map)list6.get(n2);
                IntStream.range(0, list5.size()).forEach(n -> {
                    if (((Boolean)map.get(list5.get(n))).booleanValue() || ((Boolean)map2.get(list5.get(n))).booleanValue()) {
                        linkedHashMap.put((String)list5.get(n), true);
                    } else {
                        linkedHashMap.put((String)list5.get(n), false);
                    }
                });
                arrayList.add(linkedHashMap);
            });
            arrayList3.add(arrayList);
        });
        ArrayList arrayList4 = new ArrayList();
        IntStream.range(0, list.size()).forEach(n2 -> {
            ArrayList arrayList = new ArrayList();
            List list5 = (List)list.get(n2);
            int n3 = 0;
            while (n3 < list5.size()) {
                Map map = (Map)((List)arrayList3.get(n2)).get(n3);
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                double d = (Double)list5.get(n3);
                IntStream.range(0, list5.size()).forEach(n -> {
                    boolean bl = (Boolean)map.get(list5.get(n));
                    if (bl) {
                        linkedHashMap.put((String)list5.get(n), d);
                    } else {
                        linkedHashMap.put((String)list5.get(n), 0.0);
                    }
                });
                arrayList.add(linkedHashMap);
                ++n3;
            }
            arrayList4.add(arrayList);
        });
        ArrayList<Map<String, Double>> arrayList5 = new ArrayList<Map<String, Double>>();
        arrayList4.forEach(list3 -> {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            IntStream.range(0, ((Map)list3.get(0)).size()).forEach(n -> {
                double d = 0.0;
                for (Map map2 : list3) {
                    d += ((Double)map2.get(list5.get(n))).doubleValue();
                }
                linkedHashMap.put((String)list5.get(n), d);
            });
            arrayList5.add(linkedHashMap);
        });
        return arrayList5;
    }

    private List<Map<String, Double>> compute_elementary_effects(List<Map<String, Double>> list, List<Double> list2, int n3, double d, List<String> list3, List<Map<String, Object>> list4) {
        Cloneable cloneable;
        int n4 = list4.size() / n3;
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>(list2);
        IntStream.range(0, n4).forEach(n2 -> {
            ArrayList arrayList = new ArrayList();
            IntStream.range(0, n3).forEach(n3 -> arrayList.add((Double)arrayList2.get(n3 + n2 * n3)));
            arrayList.add(arrayList);
        });
        ArrayList arrayList3 = new ArrayList();
        int n5 = 1;
        while (n5 < list.size()) {
            cloneable = new HashMap();
            if (n5 == 0) {
                IntStream.range(0, list3.size()).forEach(n -> cloneable.put((String)list3.get(n), 0.0));
            } else {
                int n6 = n5;
                IntStream.range(0, list3.size()).forEach(n2 -> {
                    double d = (Double)((Map)list.get(n6)).get(list3.get(n2)) - (Double)((Map)list.get(n6 - 1)).get(list3.get(n2));
                    cloneable.put((String)list3.get(n2), d);
                });
            }
            arrayList3.add(cloneable);
            ++n5;
        }
        cloneable = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        arrayList3.forEach(map -> {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            IntStream.range(0, list3.size()).forEach(n -> {
                linkedHashMap.put((String)list3.get(n), (Double)map.get(list3.get(n)) > 0.0);
                linkedHashMap2.put((String)list3.get(n), (Double)map.get(list3.get(n)) < 0.0);
            });
            cloneable.add(linkedHashMap);
            arrayList4.add(linkedHashMap2);
        });
        ArrayList<List<Map<String, Boolean>>> arrayList5 = new ArrayList<List<Map<String, Boolean>>>();
        ArrayList<List<Map<String, Boolean>>> arrayList6 = new ArrayList<List<Map<String, Boolean>>>();
        ArrayList<List<Map<String, Boolean>>> arrayList7 = new ArrayList<List<Map<String, Boolean>>>();
        ArrayList<List<Map<String, Boolean>>> arrayList8 = new ArrayList<List<Map<String, Boolean>>>();
        ArrayList arrayList9 = new ArrayList(cloneable);
        ArrayList arrayList10 = new ArrayList(arrayList4);
        IntStream.range(0, n4).forEach(n2 -> {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            IntStream.range(0, n3 - 1).forEach(n3 -> {
                arrayList.add((Map)arrayList9.get(n3 + n2 * n3));
                arrayList2.add((Map)arrayList10.get(n3 + n2 * n3));
                arrayList3.add((Map)arrayList9.get(n3 + n2 * n3));
                arrayList4.add((Map)arrayList10.get(n3 + n2 * n3));
            });
            arrayList5.add(arrayList);
            arrayList6.add(arrayList2);
            arrayList7.add(arrayList3);
            arrayList8.add(arrayList4);
        });
        List<Map<String, Double>> list5 = this.reorganize_output_matrix(arrayList, arrayList5, arrayList6, true, list3);
        List<Map<String, Double>> list6 = this.reorganize_output_matrix(arrayList, arrayList7, arrayList8, false, list3);
        List<Map<String, Double>> list7 = this.calc_results_difference(list5, list6, list3);
        list7.forEach(map -> IntStream.range(0, list3.size()).forEach(n -> {
            double d2 = (Double)map.get(list3.get(n)) / d;
            map.replace((String)list3.get(n), d2);
        }));
        return list7;
    }
}

