/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.types.GamaFontType;
import java.awt.Color;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The color with wich the text will be displayed")}), @GamlAnnotations.facet(name="background", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The color of the background of the text")}), @GamlAnnotations.facet(name="font", type={19, 4}, optional=true, doc={@GamlAnnotations.doc(value="The font used to draw the text, which can be built with the operator \"font\". ex : font:font(\"Helvetica\", 20 , #bold).")}), @GamlAnnotations.facet(name="category", type={-200}, optional=true, doc={@GamlAnnotations.doc(value="A category label, used to group parameters in the interface")}), @GamlAnnotations.facet(name="format", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether or not to interpret the text as formatted using XML / hyperlinks.")}), @GamlAnnotations.facet(name="message", type={0}, optional=false, doc={@GamlAnnotations.doc(value="The text to display.\nIf `format` is false or not specified, the font, color, and background are controlled by the respective facets.\nIf `format` is true, the text will instead be interpreted as a text with a few XML tags and hyperlinks that will be automatically detected. When configured to use formatting XML, it requires any ampersand (&) characters in the text to be replaced by the entity &amp;. The following tags can be used:\r\n\r\np - for defining paragraphs. The following attributes are allowed:\r\n\tvspace - if set to 'false', no vertical space will be added (default is 'true')\r\nli - for defining list items. The following attributes are allowed:\r\n\tvspace - the same as with the p tag\r\n\tindent - the number of pixels to indent the text in the list item\r\n\tbindent - the number of pixels to indent the bullet itself\r\nText in paragraphs and list items will be wrapped according to the width of the control. The following tags can appear as children of either p or li elements:\r\n\r\na - to render a hyperlink. Element accepts attribute 'href'. The element also accepts 'nowrap' attribute (default is false). When set to 'true', the hyperlink will not be wrapped. Hyperlinks automatically created when 'http://' is encountered in text are not wrapped.\r\nbr - forced line break (no attributes).\r\n\r\n")})}, omissible="message")
@GamlAnnotations.doc(value="The statement makes an experiment display text in the parameters view.")
public class TextStatement
extends AbstractStatement
implements IExperimentDisplayable {
    final IExpression message;
    final IExpression color;
    final IExpression category;
    final IExpression font;
    final IExpression background;
    final IExpression format = this.getFacet("format");

    public TextStatement(IDescription iDescription) {
        super(iDescription);
        this.message = this.getFacet("message");
        this.color = this.getFacet("color");
        this.category = this.getFacet("category");
        this.font = this.getFacet("font");
        this.background = this.getFacet("background");
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        return null;
    }

    public String getText(IScope iScope) {
        return Cast.asString(iScope, this.message.value(iScope));
    }

    public boolean isXML(IScope iScope) {
        if (this.format == null) {
            return false;
        }
        return Cast.asBool(iScope, this.format.value(iScope));
    }

    public GamaFont getFont(IScope iScope) {
        if (this.font == null) {
            return null;
        }
        return GamaFontType.staticCast(iScope, this.font.value(iScope), false);
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        GamaColor gamaColor = null;
        if (this.color != null) {
            gamaColor = Cast.asColor(iScope, this.color.value(iScope));
        }
        return gamaColor;
    }

    public Color getBackground(IScope iScope) {
        GamaColor gamaColor = null;
        if (this.background != null) {
            gamaColor = Cast.asColor(iScope, this.background.value(iScope));
        }
        return gamaColor;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return "";
    }

    @Override
    public void setUnitLabel(String string) {
    }

    @Override
    public boolean isDefinedInExperiment() {
        return true;
    }

    @Override
    public String getCategory() {
        if (this.category == null) {
            return IExperimentDisplayable.super.getCategory();
        }
        return this.category.literalValue();
    }
}

