/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IGraphics;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.ILayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.units.PixelUnitExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.AttributeHolder;
import gama.gaml.types.Types;
import java.awt.Point;
import org.locationtech.jts.geom.Envelope;

public class LayerData
extends AttributeHolder
implements ILayerData {
    protected final Point positionInPixels = new Point();
    protected final Point sizeInPixels = new Point();
    boolean positionIsInPixels;
    boolean sizeIsInPixels;
    Envelope visibleRegion;
    final AttributeHolder.Attribute<Double> rotation;
    AttributeHolder.Attribute<GamaPoint> size;
    AttributeHolder.Attribute<GamaPoint> position;
    final AttributeHolder.Attribute<Boolean> refresh;
    final AttributeHolder.Attribute<Boolean> fading;
    final AttributeHolder.Attribute<Integer> trace;
    AttributeHolder.Attribute<Boolean> selectable;
    AttributeHolder.Attribute<Double> transparency;
    AttributeHolder.Attribute<Boolean> visible;
    volatile boolean structuralChangeByUser;

    public LayerData(ILayerStatement iLayerStatement) throws GamaRuntimeException {
        super(iLayerStatement);
        IExpression iExpression2 = iLayerStatement.getFacet("size");
        this.sizeIsInPixels = iExpression2 != null && iExpression2.findAny(iExpression -> iExpression instanceof PixelUnitExpression);
        this.size = this.create("size", iExpression2, Types.POINT, new GamaPoint(1.0, 1.0, 1.0));
        IExpression iExpression3 = iLayerStatement.getFacet("position");
        this.positionIsInPixels = iExpression3 != null && iExpression3.findAny(iExpression -> iExpression instanceof PixelUnitExpression);
        this.position = this.create("position", iExpression3, Types.POINT, new GamaPoint());
        this.refresh = this.create("refresh", iLayerStatement.getRefreshFacet(), Types.BOOL, Boolean.valueOf(true));
        this.fading = this.create("fading", Types.BOOL, false);
        this.visible = this.create("visible", Types.BOOL, true);
        this.trace = this.create("trace", (IScope iScope, IExpression iExpression) -> iExpression.getGamlType() == Types.BOOL && Cast.asBool(iScope, iExpression.value(iScope)) != false ? Integer.MAX_VALUE : Cast.asInt(iScope, iExpression.value(iScope)), Types.INT, Integer.valueOf(0));
        this.selectable = this.create("selectable", Types.BOOL, true);
        this.transparency = this.create("transparency", (IScope iScope, IExpression iExpression) -> Math.min(Math.max(Cast.asFloat(iScope, iExpression.value(iScope)), 0.0), 1.0), Types.FLOAT, Double.valueOf(0.0));
        this.rotation = this.create("rotate", Types.FLOAT, 0.0);
    }

    @Override
    public boolean compute(IScope iScope, IGraphics iGraphics) throws GamaRuntimeException {
        boolean bl = this.isVisible();
        this.refresh(iScope);
        this.computePixelsDimensions(iGraphics);
        return iScope.getClock().getCycle() > 0 && this.isVisible() != bl;
    }

    @Override
    public void setTransparency(double d) {
        this.transparency = this.create("transparency", Math.min(Math.max(d, 0.0), 1.0));
        this.structuralChangeByUser = true;
    }

    @Override
    public void setSize(GamaPoint gamaPoint) {
        this.setSize(gamaPoint.getX(), gamaPoint.getY(), gamaPoint.getZ());
    }

    @Override
    public void setSize(double d, double d2, double d3) {
        this.size = this.create("size", new GamaPoint(d, d2, d3));
        this.sizeIsInPixels = false;
    }

    @Override
    public void setPosition(GamaPoint gamaPoint) {
        this.setPosition(gamaPoint.getX(), gamaPoint.getY(), gamaPoint.getZ());
    }

    @Override
    public void setPosition(double d, double d2, double d3) {
        this.position = this.create("position", new GamaPoint(d, d2, d3));
        this.positionIsInPixels = false;
    }

    @Override
    public final Double getTransparency(IScope iScope) {
        return Cast.asFloat(iScope, this.transparency.value(iScope));
    }

    @Override
    public GamaPoint getPosition() {
        return this.position.get();
    }

    @Override
    public GamaPoint getSize() {
        return this.size.get();
    }

    @Override
    public Boolean getRefresh() {
        return this.refresh.get();
    }

    @Override
    public void setSelectable(Boolean bl) {
        this.selectable = this.create("selectable", bl);
    }

    @Override
    public Integer getTrace() {
        return this.trace.get();
    }

    @Override
    public Double getRotation() {
        return this.rotation.get();
    }

    @Override
    public Boolean getFading() {
        return this.fading.get();
    }

    @Override
    public Boolean isSelectable() {
        return this.selectable.get();
    }

    @Override
    public boolean isRelativePosition() {
        return !this.positionIsInPixels;
    }

    @Override
    public boolean isRelativeSize() {
        return !this.sizeIsInPixels;
    }

    @Override
    public Point getSizeInPixels() {
        return this.sizeInPixels;
    }

    @Override
    public Point getPositionInPixels() {
        return this.positionInPixels;
    }

    @Override
    public void computePixelsDimensions(IGraphics iGraphics) {
        int n = iGraphics.getDisplayWidth();
        int n2 = iGraphics.getDisplayHeight();
        double d = iGraphics.getxRatioBetweenPixelsAndModelUnits();
        double d2 = iGraphics.getyRatioBetweenPixelsAndModelUnits();
        GamaPoint gamaPoint = this.getPosition();
        double d3 = gamaPoint.getX();
        double d4 = !this.isRelativePosition() ? d * d3 : (Math.abs(d3) <= 1.0 ? (double)n * d3 : d * d3);
        double d5 = Math.signum(d3) < 0.0 ? (double)n + d4 : d4;
        double d6 = gamaPoint.getY();
        double d7 = !this.isRelativePosition() ? d2 * d6 : (Math.abs(d6) <= 1.0 ? (double)n2 * d6 : d2 * d6);
        double d8 = Math.signum(d6) < 0.0 ? (double)n2 + d7 : d7;
        gamaPoint = this.getSize();
        double d9 = gamaPoint.getX();
        double d10 = !this.isRelativeSize() ? d * d9 : (Math.abs(d9) <= 1.0 ? (double)n * d9 : d * d9);
        double d11 = gamaPoint.getY();
        double d12 = !this.isRelativeSize() ? d2 * d11 : (Math.abs(d11) <= 1.0 ? (double)n2 * d11 : d2 * d11);
        this.getSizeInPixels().setLocation(d10, d12);
        this.getPositionInPixels().setLocation(d5, d8);
    }

    @Override
    public void setVisibleRegion(Envelope envelope) {
        this.visibleRegion = envelope;
    }

    @Override
    public Envelope getVisibleRegion() {
        return this.visibleRegion;
    }

    @Override
    public Boolean isVisible() {
        return this.visible.get();
    }

    @Override
    public void setVisible(Boolean bl) {
        if (this.isVisible() != bl) {
            this.visible = this.create("visible", Types.BOOL, bl);
            this.structuralChangeByUser = true;
        }
    }

    @Override
    public boolean hasStructurallyChanged() {
        boolean bl = this.transparency.changed() || this.trace.changed() || this.refresh.changed() || this.visible.changed() || this.structuralChangeByUser;
        this.structuralChangeByUser = false;
        return bl;
    }
}

