/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.properties;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.gaml.interfaces.INamed;
import java.util.List;

public interface ICameraDefinition
extends INamed {
    @GamlAnnotations.constant(value="from_above", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera, above the scene")})
    public static final String from_above = "From above";
    @GamlAnnotations.constant(value="from_left", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera, on the left of the scene")})
    public static final String from_left = "From left";
    @GamlAnnotations.constant(value="from_right", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera, on the right of the scene")})
    public static final String from_right = "From right";
    @GamlAnnotations.constant(value="from_up_left", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera, on the left, slightly above the scene")})
    public static final String from_up_left = "From up left";
    @GamlAnnotations.constant(value="from_up_right", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera on the right, slightly above the scene")})
    public static final String from_up_right = "From up right";
    @GamlAnnotations.constant(value="from_front", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera, in front of the scene")})
    public static final String from_front = "From front";
    @GamlAnnotations.constant(value="from_up_front", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera, in front and slightly above the scene")})
    public static final String from_up_front = "From up front";
    @GamlAnnotations.constant(value="isometric", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the position of the camera, on the left of the scene")})
    public static final String isometric = "Isometric";
    public static final String[] PRESETS = List.of("From above", "From left", "From right", "From front", "From up left", "From up right", "From up front", "Isometric").toArray(new String[7]);

    public GamaPoint getLocation();

    public GamaPoint getTarget();

    public Double getLens();

    public Boolean isLocked();

    public void setLocked(Boolean var1);

    public boolean setLocation(GamaPoint var1);

    public boolean setTarget(GamaPoint var1);

    public void setLens(Double var1);

    public boolean setDistance(Double var1);

    public void reset();

    default public void refresh(IScope iScope) {
    }

    public Double getDistance();

    default public GamaPoint computeLocation(String string, GamaPoint gamaPoint, double d, double d2, double d3) {
        return switch (string) {
            case from_above -> new GamaPoint(gamaPoint.x, gamaPoint.y, d3);
            case from_left -> new GamaPoint(gamaPoint.x - d, gamaPoint.y, 0.0);
            case from_up_left -> new GamaPoint(gamaPoint.x - d, gamaPoint.y, d3);
            case from_right -> new GamaPoint(gamaPoint.x + d, gamaPoint.y - d2 / 1000.0, 0.0);
            case from_up_right -> new GamaPoint(gamaPoint.x + d, gamaPoint.y - d2 / 1000.0, d3);
            case from_front -> new GamaPoint(gamaPoint.x, gamaPoint.y - d2, 0.0);
            case from_up_front -> new GamaPoint(gamaPoint.x, gamaPoint.y - d2, d3);
            case isometric -> new GamaPoint(gamaPoint.x + d3, -d3 + gamaPoint.y, d3 / 1.2);
            default -> new GamaPoint(gamaPoint.x, gamaPoint.y, d3);
        };
    }

    public Boolean isDynamic();
}

