/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.reflex;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;

@GamlAnnotations.inside(kinds={0, 13, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates a boolean, the condition to fulfill in order to execute the statements embedded in the reflex.")}), @GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the identifier of the reflex")})}, omissible="name")
@validator(value=IDescriptionValidator.ValidNameValidator.class)
@GamlAnnotations.doc(value="Reflexes are sequences of statements that can be executed by the agent. Reflexes prefixed by the 'reflex' keyword are executed continuously. Reflexes prefixed by 'init' are executed only immediately after the agent has been created. Reflexes prefixed by 'abort' just before the agent is killed. If a facet when: is defined, a reflex is executed only if the boolean expression evaluates to true.", usages={@GamlAnnotations.usage(value="Reflexes are sequences of statements that are executed by the agent at each step, when scheduled and if the when: condition is true.", examples={@GamlAnnotations.example(value="reflex my_reflex when: flip (0.5){ \t\t//Only executed when flip returns true", isExecutable=false), @GamlAnnotations.example(value="    write \"Executing the unconditional reflex\";", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value=" 'init' reflexes are executed only immediately after the agent has been created.", examples={@GamlAnnotations.example(value="init { write \"I am created\"; }", isExecutable=false)}), @GamlAnnotations.usage(value=" 'abort' reflexes are executed just before the agent is killed.", examples={@GamlAnnotations.example(value="abort { write \"Last actions before being removed \"; }", isExecutable=false)})})
public class ReflexStatement
extends AbstractStatementSequence {
    private final IExpression when = this.getFacet("when");

    public ReflexStatement(IDescription iDescription) {
        super(iDescription);
        if (this.hasFacet("name")) {
            this.setName(this.getLiteral("name"));
        }
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        return this.when == null || Cast.asBool(iScope, this.when.value(iScope)) != false ? super.privateExecuteIn(iScope) : null;
    }
}

