/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import gama.core.common.interfaces.ISkill;
import gama.core.common.util.JavaUtils;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExecutionContext;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.core.util.file.GamlFileInfo;
import gama.core.util.file.IGamlResourceInfoProvider;
import gama.gaml.compilation.GamaHelper;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.IGamlEcoreUtils;
import gama.gaml.compilation.IGamlModelBuilder;
import gama.gaml.compilation.IGamlTextValidator;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.constants.IConstantAcceptor;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.expressions.GamlExpressionFactory;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.expressions.units.UnitConstantExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.factories.ModelFactory;
import gama.gaml.types.IType;
import gama.gaml.types.Signature;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;

public class GAML {
    public static final Map<String, IMap<Signature, OperatorProto>> OPERATORS = Collections.synchronizedMap(GamaMapFactory.createUnordered());
    public static final Set<String> ITERATORS = Collections.synchronizedSet(new HashSet());
    public static final Set<String> CONSTANTS = Collections.synchronizedSet(new HashSet());
    public static final Multimap<Class, IDescription> ADDITIONS = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    public static final Multimap<Class, OperatorProto> FIELDS = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    public static final Map<String, UnitConstantExpression> UNITS = Collections.synchronizedMap(new HashMap());
    public static final Multimap<Integer, String> VARTYPE2KEYWORDS = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    public static final SetMultimap<Class, GamaHelper> LISTENERS_BY_CLASS = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    public static final SetMultimap<String, Class> LISTENERS_BY_NAME = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    public static volatile IExpressionFactory expressionFactory = null;
    private static IGamlResourceInfoProvider infoProvider = null;
    private static IGamlEcoreUtils gamlEcoreUtils = null;
    private static IGamlModelBuilder gamlModelBuilder = null;
    private static IGamlTextValidator gamlTextValidator = null;

    public static <T> T notNull(IScope iScope, T t) {
        return GAML.notNull(iScope, t, "Error: nil value detected");
    }

    public static <T> T notNull(IScope iScope, T t, String string) {
        if (t == null) {
            throw GamaRuntimeException.error(string, iScope);
        }
        return t;
    }

    public static <T extends IContainer> T emptyCheck(IScope iScope, T t) {
        if (GAML.notNull(iScope, t).isEmpty(iScope)) {
            throw GamaRuntimeException.error("Error: the container is empty", iScope);
        }
        return t;
    }

    public static ModelFactory getModelFactory() {
        return new ModelFactory();
    }

    public static IExpressionFactory getExpressionFactory() {
        if (expressionFactory == null) {
            expressionFactory = new GamlExpressionFactory();
        }
        return expressionFactory;
    }

    public static Object evaluateExpression(String string, IAgent iAgent) throws GamaRuntimeException {
        if (iAgent == null) {
            return null;
        }
        if (string == null || string.isEmpty()) {
            throw GamaRuntimeException.error("Enter a valid expression", iAgent.getScope());
        }
        IExpression iExpression = GAML.compileExpression(string, iAgent, true);
        if (iExpression == null) {
            return null;
        }
        IScope iScope = iAgent.getScope().copy("in temporary expression evaluator");
        Object object = iScope.evaluate(iExpression, iAgent).getValue();
        GAMA.releaseScope(iScope);
        return object;
    }

    public static IExpression compileExpression(String string, IAgent iAgent, boolean bl) throws GamaRuntimeException {
        if (iAgent == null) {
            throw GamaRuntimeException.error("Agent is nil", GAMA.getRuntimeScope());
        }
        IExecutionContext iExecutionContext = iAgent.getScope().getExecutionContext();
        return GAML.compileExpression(string, iAgent, iExecutionContext, bl);
    }

    public static IExpression compileExpression(String string, IAgent iAgent, IExecutionContext iExecutionContext, boolean bl) throws GamaRuntimeException {
        if (iAgent == null) {
            throw GamaRuntimeException.error("Agent is nil", iExecutionContext.getScope());
        }
        SpeciesDescription speciesDescription = iAgent.getSpecies().getDescription();
        try {
            return GAML.getExpressionFactory().createExpr(string, speciesDescription, iExecutionContext);
        }
        catch (Throwable throwable) {
            if (bl) {
                throw GamaRuntimeException.create(throwable, iExecutionContext.getScope());
            }
            try {
                return GAML.getExpressionFactory().createTemporaryActionForAgent(iAgent, string, iExecutionContext);
            }
            catch (Throwable throwable2) {
                throw GamaRuntimeException.error(throwable.getMessage() + "\n" + throwable2.getMessage(), iExecutionContext.getScope());
            }
        }
    }

    public static ModelDescription getModelContext() {
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan == null) {
            return null;
        }
        return iExperimentPlan.getModel().getDescription();
    }

    public static ExperimentDescription getExperimentContext(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        IScope iScope = iAgent.getScope();
        IExperimentAgent iExperimentAgent = iScope.getExperiment();
        if (iExperimentAgent == null) {
            return null;
        }
        return (ExperimentDescription)iExperimentAgent.getSpecies().getDescription();
    }

    public static void registerInfoProvider(IGamlResourceInfoProvider iGamlResourceInfoProvider) {
        infoProvider = iGamlResourceInfoProvider;
    }

    public static void registerGamlEcoreUtils(IGamlEcoreUtils iGamlEcoreUtils) {
        gamlEcoreUtils = iGamlEcoreUtils;
    }

    public static void registerGamlModelBuilder(IGamlModelBuilder iGamlModelBuilder) {
        gamlModelBuilder = iGamlModelBuilder;
    }

    public static void registerGamlTextValidator(IGamlTextValidator iGamlTextValidator) {
        gamlTextValidator = iGamlTextValidator;
    }

    public static IGamlEcoreUtils getEcoreUtils() {
        return gamlEcoreUtils;
    }

    public static GamlFileInfo getInfo(URI uRI, long l) {
        return infoProvider.getInfo(uRI, l);
    }

    public static GamlFileInfo getInfo(URI uRI) {
        return infoProvider.getInfo(uRI);
    }

    public static ISyntacticElement getContents(URI uRI) {
        return infoProvider.getContents(uRI);
    }

    public static Map<String, OperatorProto> getAllFields(Class clazz) {
        List<Class> list = JavaUtils.collectImplementationClasses(clazz, Collections.EMPTY_SET, FIELDS.keySet());
        IMap iMap = GamaMapFactory.create();
        for (Class clazz2 : list) {
            for (OperatorProto operatorProto : FIELDS.get((Object)clazz2)) {
                iMap.put(operatorProto.getName(), operatorProto);
            }
        }
        return iMap;
    }

    public static Iterable<IDescription> getAllChildrenOf(Class clazz, Iterable<Class<? extends ISkill>> iterable) {
        List<Class> list = JavaUtils.collectImplementationClasses(clazz, iterable, ADDITIONS.keySet());
        Throwable throwable = null;
        Object var4_5 = null;
        try (Collector.AsList<IDescription> asList = Collector.getList();){
            for (Class clazz2 : list) {
                asList.addAll(ADDITIONS.get((Object)clazz2));
            }
            return asList;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Collection<OperatorProto> getAllFields() {
        return FIELDS.values();
    }

    public static Collection<IDescription> getAllVars() {
        HashSet<IDescription> hashSet = new HashSet<IDescription>();
        IDescription.DescriptionVisitor descriptionVisitor = iDescription -> {
            hashSet.add((IDescription)iDescription);
            return true;
        };
        IDescription.DescriptionVisitor descriptionVisitor2 = iDescription -> {
            Iterables.addAll((Collection)hashSet, ((StatementDescription)iDescription).getFormalArgs());
            return true;
        };
        for (TypeDescription typeDescription : Types.getBuiltInSpecies().values()) {
            typeDescription.visitOwnAttributes(descriptionVisitor);
            typeDescription.visitOwnActions(descriptionVisitor2);
        }
        GamaSkillRegistry.INSTANCE.visitSkills(object -> {
            ((TypeDescription)object).visitOwnAttributes(descriptionVisitor);
            ((TypeDescription)object).visitOwnActions(descriptionVisitor2);
            return true;
        });
        return hashSet;
    }

    public static Collection<SymbolProto> getStatementsForSkill(String string) {
        LinkedHashSet<SymbolProto> linkedHashSet = new LinkedHashSet<SymbolProto>();
        for (String string2 : DescriptionFactory.getStatementProtoNames()) {
            SymbolProto symbolProto = DescriptionFactory.getStatementProto(string2);
            if (symbolProto == null || !symbolProto.shouldBeDefinedIn(string)) continue;
            linkedHashSet.add(symbolProto);
        }
        return linkedHashSet;
    }

    public static Collection<IDescription> getAllActions() {
        SetMultimap setMultimap = MultimapBuilder.hashKeys().linkedHashSetValues().build();
        IDescription.DescriptionVisitor descriptionVisitor = iDescription -> {
            setMultimap.put((Object)iDescription.getName(), iDescription);
            return true;
        };
        for (TypeDescription typeDescription : Types.getBuiltInSpecies().values()) {
            typeDescription.visitOwnActions(descriptionVisitor);
        }
        GamaSkillRegistry.INSTANCE.visitSkills(object -> {
            ((SkillDescription)object).visitOwnActions(descriptionVisitor);
            return true;
        });
        return setMultimap.values();
    }

    public static boolean isUnaryOperator(String string) {
        if (!OPERATORS.containsKey(string)) {
            return false;
        }
        Map map = OPERATORS.get(string);
        for (Signature signature : map.keySet()) {
            if (!signature.isUnary()) continue;
            return true;
        }
        return false;
    }

    public static IConstantAcceptor getConstantAcceptor() {
        return (string, object, string2, string3, bl, stringArray) -> {
            if (UNITS.containsKey(string)) {
                return false;
            }
            IType<?> iType = Types.get(object.getClass());
            UnitConstantExpression unitConstantExpression = GAML.getExpressionFactory().createUnit(object, iType, string, string2, string3, bl, stringArray);
            UNITS.put(string, unitConstantExpression);
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string4 = stringArray2[n2];
                    UNITS.put(string4, unitConstantExpression);
                    ++n2;
                }
            }
            return true;
        };
    }

    public static IGamlModelBuilder getModelBuilder() {
        return gamlModelBuilder;
    }

    public static List<String> validate(String string, boolean bl) {
        ArrayList<GamlCompilationError> arrayList = new ArrayList<GamlCompilationError>();
        if (string.startsWith("model")) {
            gamlTextValidator.validateModel(string, arrayList, bl);
        } else if (string.startsWith("species") || string.startsWith("grid")) {
            gamlTextValidator.validateSpecies(string, arrayList, bl);
        } else if (string.lines().count() > 1L) {
            gamlTextValidator.validateStatements(string, arrayList, bl);
        } else {
            gamlTextValidator.validateExpression(string, arrayList, bl);
        }
        return arrayList.stream().map(gamlCompilationError -> gamlCompilationError.message).toList();
    }
}

