/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation.kernel;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gama.core.common.interfaces.ICreateDelegate;
import gama.core.common.interfaces.IDrawDelegate;
import gama.core.common.interfaces.IEventLayerDelegate;
import gama.core.common.interfaces.ISaveDelegate;
import gama.core.outputs.layers.EventLayerStatement;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IGamlAdditions;
import gama.gaml.compilation.kernel.GamaClassLoader;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.constants.IConstantsSupplier;
import gama.gaml.statements.CreateStatement;
import gama.gaml.statements.SaveStatement;
import gama.gaml.statements.draw.DrawStatement;
import gama.gaml.types.Types;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.WrappedException;
import org.osgi.framework.Bundle;

public class GamaBundleLoader {
    public static final String LINE = "\n\n****************************************************************************************************\n\n";
    public static final String ERROR_MESSAGE = "\n\n****************************************************************************************************\n\nThe initialization of GAML artifacts went wrong. If you use the developer version, please clean and recompile all plugins. \nOtherwise report an issue at https://github.com/gama-platform/gama/issues\n\n****************************************************************************************************\n\n";
    public static volatile boolean LOADED;
    public static volatile boolean ERRORED;
    public static final Bundle CORE_PLUGIN;
    public static final Bundle CORE_MODELS;
    public static final String CORE_TESTS = "tests";
    public static String CURRENT_PLUGIN_NAME;
    public static final String ADDITIONS_PACKAGE_BASE = "gaml.additions";
    public static final String ADDITIONS_CLASS_NAME = "GamlAdditions";
    public static final String GRAMMAR_EXTENSION_DEPRECATED = "gaml.grammar.addition";
    public static final String GRAMMAR_EXTENSION = "gaml.extension";
    public static final String CREATE_EXTENSION = "gama.create";
    public static final String SAVE_EXTENSION = "gama.save";
    public static final String DRAW_EXTENSION = "gama.draw";
    public static final String CONSTANTS_EXTENSION = "gama.constants";
    public static final String EVENT_LAYER_EXTENSION = "gama.event_layer";
    public static final String MODELS_EXTENSION = "gama.models";
    public static final String REGULAR_MODELS_LAYOUT = "models";
    public static final String REGULAR_TESTS_LAYOUT = "tests";
    public static final String GENERATED_TESTS_LAYOUT = "gaml/tests";
    public static final String CONTENT_EXTENSION = "org.eclipse.core.contenttype.contentTypes";
    private static final List<Bundle> GAMA_PLUGINS;
    private static final Set<String> GAMA_PLUGINS_NAMES;
    private static final Set<String> GAMA_DISPLAY_PLUGINS_NAMES;
    private static final Set<String> GAMA_CORE_DISPLAY_PLUGINS;
    private static final String GAMA_DIAGRAM_EDITOR_PLUGIN = "gama.ui.diagram";
    private static final Multimap<Bundle, String> MODEL_PLUGINS;
    private static final Multimap<Bundle, String> TEST_PLUGINS;
    public static final Set<String> HANDLED_FILE_EXTENSIONS;

    static {
        DEBUG.ON();
        Toolkit.getDefaultToolkit();
        LOADED = false;
        ERRORED = false;
        CORE_PLUGIN = Platform.getBundle((String)"gama.core");
        CORE_MODELS = Platform.getBundle((String)"gama.library");
        CURRENT_PLUGIN_NAME = CORE_PLUGIN.getSymbolicName();
        GAMA_PLUGINS = new ArrayList<Bundle>();
        GAMA_PLUGINS_NAMES = new LinkedHashSet<String>();
        GAMA_DISPLAY_PLUGINS_NAMES = new LinkedHashSet<String>();
        GAMA_CORE_DISPLAY_PLUGINS = Set.of("gama.ui.display.java2d", "gama.ui.display.opengl");
        MODEL_PLUGINS = ArrayListMultimap.create();
        TEST_PLUGINS = ArrayListMultimap.create();
        HANDLED_FILE_EXTENSIONS = new LinkedHashSet<String>();
    }

    public static void ERROR(String string, Exception exception) {
        DEBUG.ERR((Object)ERROR_MESSAGE);
        ERRORED = true;
        DEBUG.ERR((Object)string, (Throwable)exception);
    }

    public static void preBuildContributions() throws Exception {
        DEBUG.BANNER((String)"GAMA", (String)"version 2025.5.4-SNAPSHOT", (String)"loading on", (String)(SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION + ", processor " + SystemUtils.OS_ARCH + ", JDK " + SystemUtils.JAVA_VM_NAME + " " + SystemUtils.JAVA_VM_VENDOR + " version " + SystemUtils.JAVA_VM_VERSION));
        DEBUG.TIMER((String)"GAML", (String)"Plugins with language additions", (String)"loaded in", () -> {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            try {
                ((StreamEx)((StreamEx)StreamEx.of((Object[])iExtensionRegistry.getExtensionPoint(GRAMMAR_EXTENSION).getExtensions()).append((Stream)StreamEx.of((Object[])iExtensionRegistry.getExtensionPoint(GRAMMAR_EXTENSION_DEPRECATED).getExtensions()))).map(iExtension -> Platform.getBundle((String)iExtension.getContributor().getName())).sorted(Comparator.comparing(Bundle::getSymbolicName))).into(GAMA_PLUGINS);
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                GamaBundleLoader.ERROR("Error in retrieving GAMA plugins. One is invalid. ", (Exception)((Object)invalidRegistryObjectException));
            }
            GAMA_PLUGINS.remove(CORE_PLUGIN);
            if (GAMA.isInHeadLessMode()) {
                GAMA_PLUGINS.removeIf(bundle -> GAMA_CORE_DISPLAY_PLUGINS.contains(bundle.getSymbolicName()));
            }
            try {
                GamaBundleLoader.preBuild(CORE_PLUGIN);
            }
            catch (Exception exception) {
                GamaBundleLoader.ERROR("Error in loading core GAML language definition. ", exception);
                System.exit(0);
                return;
            }
            for (Bundle bundle2 : GAMA_PLUGINS) {
                CURRENT_PLUGIN_NAME = bundle2.getSymbolicName();
                try {
                    GamaBundleLoader.preBuild(bundle2);
                }
                catch (Exception exception) {
                    GamaBundleLoader.ERROR("Error in loading plugin " + CURRENT_PLUGIN_NAME + ". ", exception);
                }
            }
            CURRENT_PLUGIN_NAME = null;
            DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Loading extensions to 'create'", (String)"done in", () -> GamaBundleLoader.loadCreateExt(iExtensionRegistry));
            DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Loading extensions to 'save'", (String)"done in", () -> GamaBundleLoader.loadSaveExt(iExtensionRegistry));
            DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Loading extensions to 'draw'", (String)"done in", () -> GamaBundleLoader.loadDrawExt(iExtensionRegistry));
            DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Loading extensions to 'event'", (String)"done in", () -> GamaBundleLoader.loadEventExt(iExtensionRegistry));
            DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Gathering built-in models", (String)"done in", () -> GamaBundleLoader.loadModels(iExtensionRegistry));
            GamaBundleLoader.loadContentExtensions(iExtensionRegistry);
            LOADED = true;
            GamaMetaModel.INSTANCE.build();
            Types.init();
            DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)"Loading constants", (String)"done in", () -> GamaBundleLoader.loadConstants(iExtensionRegistry));
            GamaMetaModel.getPlatformSpeciesDescription().validate();
        }, (Consumer[])new Consumer[0]);
    }

    private static void loadCreateExt(IExtensionRegistry iExtensionRegistry) throws InvalidRegistryObjectException {
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(CREATE_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            ICreateDelegate iCreateDelegate = null;
            try {
                iCreateDelegate = (ICreateDelegate)iConfigurationElement.createExecutableExtension("class");
                if (iCreateDelegate != null) {
                    CreateStatement.addDelegate(iCreateDelegate);
                }
            }
            catch (Exception exception) {
                GamaBundleLoader.ERROR("Error in loading CreateStatement delegate from " + iConfigurationElement.getDeclaringExtension().getContributor().getName(), exception);
            }
            ++n2;
        }
    }

    private static void loadSaveExt(IExtensionRegistry iExtensionRegistry) throws InvalidRegistryObjectException {
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(SAVE_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            ISaveDelegate iSaveDelegate = null;
            try {
                iSaveDelegate = (ISaveDelegate)iConfigurationElement.createExecutableExtension("class");
                if (iSaveDelegate != null) {
                    SaveStatement.addDelegate(iSaveDelegate);
                }
            }
            catch (Exception exception) {
                GamaBundleLoader.ERROR("Error in loading SaveStatement delegate from " + iConfigurationElement.getDeclaringExtension().getContributor().getName(), exception);
            }
            ++n2;
        }
    }

    private static void loadDrawExt(IExtensionRegistry iExtensionRegistry) throws InvalidRegistryObjectException {
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(DRAW_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            IDrawDelegate iDrawDelegate = null;
            try {
                iDrawDelegate = (IDrawDelegate)iConfigurationElement.createExecutableExtension("class");
                if (iDrawDelegate != null) {
                    DrawStatement.addDelegate(iDrawDelegate);
                }
            }
            catch (Exception exception) {
                GamaBundleLoader.ERROR("Error in loading DrawStatement delegate from " + iConfigurationElement.getDeclaringExtension().getContributor().getName(), exception);
            }
            ++n2;
        }
    }

    private static void loadEventExt(IExtensionRegistry iExtensionRegistry) throws InvalidRegistryObjectException {
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(EVENT_LAYER_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                EventLayerStatement.addDelegate((IEventLayerDelegate)iConfigurationElement.createExecutableExtension("class"));
            }
            catch (Exception exception) {
                GamaBundleLoader.ERROR("Error in loading EventLayerStatement delegate : " + iConfigurationElement.getDeclaringExtension().getContributor().getName(), exception);
            }
            ++n2;
        }
    }

    private static void loadModels(IExtensionRegistry iExtensionRegistry) throws InvalidRegistryObjectException {
        MODEL_PLUGINS.put((Object)CORE_MODELS, (Object)REGULAR_MODELS_LAYOUT);
        GAMA_PLUGINS.add(CORE_PLUGIN);
        GAMA_PLUGINS.forEach(bundle -> {
            if (bundle.getEntry(REGULAR_MODELS_LAYOUT) != null) {
                MODEL_PLUGINS.put(bundle, (Object)REGULAR_MODELS_LAYOUT);
            }
            if (bundle.getEntry("tests") != null) {
                TEST_PLUGINS.put(bundle, (Object)"tests");
            }
            if (bundle.getEntry(GENERATED_TESTS_LAYOUT) != null) {
                TEST_PLUGINS.put(bundle, (Object)GENERATED_TESTS_LAYOUT);
            }
        });
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(MODELS_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            MODEL_PLUGINS.put((Object)Platform.getBundle((String)iConfigurationElement.getContributor().getName()), (Object)iConfigurationElement.getAttribute("name"));
            ++n2;
        }
    }

    private static void loadContentExtensions(IExtensionRegistry iExtensionRegistry) throws InvalidRegistryObjectException {
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(CONTENT_EXTENSION);
        HashSet<IExtension> hashSet = new HashSet<IExtension>();
        hashSet.addAll(Arrays.asList(iExtensionPoint.getExtensions()));
        for (IExtension iExtension : hashSet) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                String string = iConfigurationElement.getAttribute("file-extensions");
                if (string != null) {
                    HANDLED_FILE_EXTENSIONS.addAll(Arrays.asList(string.split(",")));
                }
                ++n2;
            }
        }
    }

    private static void loadConstants(IExtensionRegistry iExtensionRegistry) throws InvalidRegistryObjectException {
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(CONSTANTS_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            IConstantsSupplier iConstantsSupplier = null;
            try {
                iConstantsSupplier = (IConstantsSupplier)iConfigurationElement.createExecutableExtension("class");
                if (iConstantsSupplier != null) {
                    iConstantsSupplier.supplyConstantsTo(GAML.getConstantAcceptor());
                }
            }
            catch (Exception exception) {
                GamaBundleLoader.ERROR("Error in loading constants from " + iConfigurationElement.getDeclaringExtension().getContributor().getName(), exception);
            }
            ++n2;
        }
    }

    public static void preBuild(Bundle bundle) throws Exception {
        DEBUG.TIMER_WITH_EXCEPTIONS((String)"GAMA", (String)("Plugin " + bundle.getSymbolicName()), (String)"loaded in", () -> {
            String string = bundle.getSymbolicName();
            GAMA_PLUGINS_NAMES.add(string);
            string = string.substring(string.lastIndexOf(46) + 1);
            GamaClassLoader.getInstance().addBundle(bundle);
            Class clazz = null;
            String string2 = "gaml.additions." + string + ".GamlAdditions";
            String string3 = ">> Impossible to load additions from " + String.valueOf(bundle) + " because " + string2 + " cannot be ";
            try {
                clazz = bundle.loadClass(string2);
                ((IGamlAdditions)clazz.getConstructor(new Class[0]).newInstance(new Object[0])).initialize();
            }
            catch (ClassNotFoundException classNotFoundException) {
                DEBUG.LOG((Object)(string3 + "found."));
                throw new WrappedException(string3 + "found.", (Exception)classNotFoundException);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                DEBUG.LOG((Object)(string3 + "initialized."));
                throw new WrappedException(string3 + "initialized.", exception);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                DEBUG.LOG((Object)(string3 + "instantiated."));
                throw new WrappedException(string3 + "instantiated.", exception);
            }
            catch (Exception exception) {
                DEBUG.LOG((Object)exception.getMessage());
                throw new WrappedException(string3 + "run.", exception);
            }
        });
    }

    public static Multimap<Bundle, String> getPluginsWithModels() {
        return MODEL_PLUGINS;
    }

    public static Multimap<Bundle, String> getPluginsWithTests() {
        return TEST_PLUGINS;
    }

    public static boolean gamlPluginExists(String string) {
        return GAMA_PLUGINS_NAMES.contains(string);
    }

    public static boolean isDisplayPlugin(String string) {
        return GAMA_DISPLAY_PLUGINS_NAMES.contains(string) || GAMA_CORE_DISPLAY_PLUGINS.contains(string);
    }

    public static void addDisplayPlugin(String string) {
        GAMA_DISPLAY_PLUGINS_NAMES.add(string);
    }

    public static boolean isDiagramEditorLoaded() {
        return Platform.getBundle((String)GAMA_DIAGRAM_EDITOR_PLUGIN) != null;
    }
}

