/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;

public class SpatialProperties {
    @GamlAnnotations.operator(value={"disjoint_from"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(value="A boolean, equal to true if the left-geometry (or agent/point) is disjoints from the right-geometry (or agent/point).", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns true."), @GamlAnnotations.usage(value="if one operand is a point, returns false if the point is included in the geometry.")}, examples={@GamlAnnotations.example(value="polyline([{10,10},{20,20}]) disjoint_from polyline([{15,15},{25,25}])", equals="false"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) disjoint_from polygon([{15,15},{15,25},{25,25},{25,15}])", equals="false"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) disjoint_from {25,25}", equals="true"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) disjoint_from polygon([{35,35},{35,45},{45,45},{45,35}])", equals="true")}, see={"intersects", "crosses", "overlaps", "partially_overlaps", "touches"})
    @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) disjoint_from {15,15} = false")
    public static Boolean disjoint_from(IScope iScope, IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null || iShape.getInnerGeometry() == null || iShape2.getInnerGeometry() == null) {
            return true;
        }
        return !iShape.intersects(iShape2);
    }

    @GamlAnnotations.operator(value={"overlaps"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(value="A boolean, equal to true if the left-geometry (or agent/point) overlaps the right-geometry (or agent/point).", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns false."), @GamlAnnotations.usage(value="if one operand is a point, returns true if the point is included in the geometry")}, examples={@GamlAnnotations.example(value="polyline([{10,10},{20,20}]) overlaps polyline([{15,15},{25,25}])", equals="true"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps polygon([{15,15},{15,25},{25,25},{25,15}])", equals="true"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps polyline([{10,10},{20,20}])", equals="true"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps {15,15}", equals="true")}, see={"disjoint_from", "crosses", "intersects", "partially_overlaps", "touches"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps polygon([{0,0},{0,30},{30,30},{30,0}])"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps polygon([{15,15},{15,25},{25,25},{25,15}])"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps polygon([{10,20},{20,20},{20,30},{10,30}])"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps polygon([{35,35},{35,45},{45,45},{45,35}]) =  false"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) overlaps {25,25} = false")})
    public static Boolean overlaps(IScope iScope, IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        return SpatialProperties.disjoint_from(iScope, iShape, iShape2) == false;
    }

    @GamlAnnotations.operator(value={"partially_overlaps"}, category={"Spatial operators", "Spatial properties operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(value="A boolean, equal to true if the left-geometry (or agent/point) partially overlaps the right-geometry (or agent/point).", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns false.")}, comment="if one geometry operand fully covers the other geometry operand, returns false (contrarily to the overlaps operator).", examples={@GamlAnnotations.example(value="polyline([{10,10},{20,20}]) partially_overlaps polyline([{15,15},{25,25}])", equals="true"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps polygon([{15,15},{15,25},{25,25},{25,15}])", equals="true"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps {25,25}", equals="false"), @GamlAnnotations.example(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps polyline([{10,10},{20,20}])", equals="false")}, see={"disjoint_from", "crosses", "overlaps", "intersects", "touches"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps polygon([{0,0},{0,30},{30,30}, {30,0}]) =  false"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps polygon([{15,15},{15,25},{25,25},{25,15}])"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps polygon([{10,20},{20,20},{20,30},{10,30}]) = false"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps {15,15} = false"), @GamlAnnotations.test(value="polygon([{10,10},{10,20},{20,20},{20,10}]) partially_overlaps polygon([{35,35},{35,45},{45,45},{45,35}]) = false")})
    public static Boolean partially_overlaps(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        return iShape.partiallyOverlaps(iShape2);
    }

    @GamlAnnotations.operator(value={"touches"}, category={"Spatial operators", "Spatial properties operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(deprecated="It is not advised to use this operator as its semantic is not clear and has changed recently in the JTS library (see https://github.com/gama-platform/gama/pull/415). `intersects` should be preferred. ", value="A boolean, equal to true if the left-geometry (or agent/point) touches the right-geometry (or agent/point), i.e. if they have at least one point in common, but their interiors do not intersect.", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns false.")}, comment="returns true when the left-operand only touches the right-operand. When one geometry covers partially (or fully) the other one, it returns false.", see={"disjoint_from", "crosses", "overlaps", "partially_overlaps", "intersects"})
    @Deprecated
    public static Boolean touches(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        return iShape.touches(iShape2);
    }

    @GamlAnnotations.operator(value={"crosses"}, category={"Spatial operators", "Spatial properties operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(value="A boolean, equal to true if the left-geometry (or agent/point) crosses the right-geometry (or agent/point).", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns false."), @GamlAnnotations.usage(value="if one operand is a point, returns false.")}, examples={@GamlAnnotations.example(value="polyline([{10,10},{20,20}]) crosses polyline([{10,20},{20,10}])", equals="true"), @GamlAnnotations.example(value="polyline([{10,10},{20,20}]) crosses {15,15}", equals="true"), @GamlAnnotations.example(value="polyline([{0,0},{25,25}]) crosses polygon([{10,10},{10,20},{20,20},{20,10}])", equals="true")}, see={"disjoint_from", "intersects", "overlaps", "partially_overlaps", "touches"})
    @GamlAnnotations.test(value="polyline([{10,10},{20,20}]) crosses polyline([{10,20},{20,10}])")
    public static Boolean crosses(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        return iShape.crosses(iShape2);
    }

    @GamlAnnotations.operator(value={"intersects"}, category={"Spatial operators", "Spatial properties operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(value="A boolean, equal to true if the left-geometry (or agent/point) intersects the right-geometry (or agent/point).", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns false.")}, examples={@GamlAnnotations.example(value="square(5) intersects {10,10}", equals="false")}, see={"disjoint_from", "crosses", "overlaps", "partially_overlaps", "touches"})
    @GamlAnnotations.test(value="square(5) intersects square(2)")
    public static Boolean intersects(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        return iShape.intersects(iShape2);
    }

    @GamlAnnotations.operator(value={"covers"}, category={"Spatial operators", "Spatial properties operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(value="A boolean, equal to true if the left-geometry (or agent/point) covers the right-geometry (or agent/point).", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns false.")}, examples={@GamlAnnotations.example(value="square(5) covers square(2)", equals="true")}, see={"disjoint_from", "crosses", "overlaps", "partially_overlaps", "touches"})
    @GamlAnnotations.test(value="square(5) covers square(2)")
    public static Boolean covers(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return false;
        }
        return iShape.covers(iShape2);
    }

    @GamlAnnotations.operator(value={"equals"}, category={"Spatial operators", "Spatial properties operators"}, concept={"geometry", "spatial_computation", "spatial_relation"})
    @GamlAnnotations.doc(value="A boolean, equal to true if the left-geometry (or agent/point) equals the right-geometry (or agent/point).", usages={@GamlAnnotations.usage(value="if one of the operand is null, returns false.")}, examples={@GamlAnnotations.example(value="square(5) equals (rectangle(10,5) rotated_by 90)", equals="true")}, see={"disjoint_from", "crosses", "overlaps", "partially_overlaps", "touches", "covers"})
    @GamlAnnotations.test(value="rectangle(5,10) equals rectangle(5,10)")
    public static Boolean equalsGeometry(IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null || iShape.getInnerGeometry() == null || iShape2.getInnerGeometry() == null) {
            return false;
        }
        return iShape.getInnerGeometry().equals(iShape2.getInnerGeometry());
    }
}

