/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import com.google.common.collect.Ordering;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.AbstractTopology;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.filter.Different;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.filter.In;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

public class SpatialQueries {
    @GamlAnnotations.operator(value={"neighbors_of"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location", "neighbors"})
    @GamlAnnotations.doc(value="a list, containing all the agents of the same species than the argument (if it is an agent) located at a distance inferior or equal to 1 to the right-hand operand agent considering the left-hand operand topology.", masterDoc=true, examples={@GamlAnnotations.example(value="topology(self) neighbors_of self", equals="returns all the agents located at a distance lower or equal to 1 to the agent applying the operator considering its topology.", test=false)}, see={"neighbors_at", "closest_to", "overlapping", "agents_overlapping", "agents_inside", "agent_closest_to"})
    public static IList neighbors_of(IScope iScope, ITopology iTopology, IAgent iAgent) {
        return SpatialQueries._neighbors(iScope, In.list(iScope, iAgent.getPopulation()), iAgent, 1.0, iTopology);
    }

    @GamlAnnotations.operator(value={"neighbors_of"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="a list, containing all the agents of the same species than the left argument (if it is an agent) located at a distance inferior or equal to the third argument to the second argument (agent, geometry or point) considering the first operand topology.", examples={@GamlAnnotations.example(value="neighbors_of (topology(self), self,10)", equals="all the agents located at a distance lower or equal to 10 to the agent applying the operator considering its topology.", test=false)})})
    public static IList neighbors_of(IScope iScope, ITopology iTopology, IShape iShape, Double d) {
        return SpatialQueries._neighbors(iScope, iShape instanceof IAgent ? In.list(iScope, ((IAgent)iShape).getPopulation()) : Different.with(), iShape, d, iTopology);
    }

    @GamlAnnotations.operator(value={"neighbors_at"}, content_type=-199, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location", "neighbors"})
    @GamlAnnotations.doc(value="a list, containing all the agents of the same species than the left argument (if it is an agent) located at a distance inferior or equal to the right-hand operand to the left-hand operand (geometry, agent, point).", comment="The topology used to compute the neighborhood  is the one of the left-operand if this one is an agent; otherwise the one of the agent applying the operator.", examples={@GamlAnnotations.example(value="(self neighbors_at (10))", equals="all the agents located at a distance lower or equal to 10 to the agent applying the operator.", test=false)}, see={"neighbors_of", "closest_to", "overlapping", "agents_overlapping", "agents_inside", "agent_closest_to", "at_distance"})
    public static IList neighbors_at(IScope iScope, IShape iShape, Double d) {
        IAgentFilter iAgentFilter;
        ITopology iTopology;
        if (iShape instanceof IAgent) {
            IAgent iAgent = (IAgent)iShape;
            iTopology = iAgent.getTopology();
            iAgentFilter = In.list(iScope, iAgent.getPopulation());
        } else {
            iTopology = iScope.getTopology();
            iAgentFilter = Different.with();
        }
        return SpatialQueries._neighbors(iScope, iAgentFilter, iShape, d, iTopology);
    }

    @GamlAnnotations.operator(value={"at_distance"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents or geometries among the left-operand list that are located at a distance <= the right operand from the caller agent (in its topology)", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] at_distance 20", equals="the agents of the list located at a distance <= 20 from the caller agent (in the same order).", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "agent_closest_to", "agents_inside", "closest_to", "inside", "overlapping"})
    public static IList<? extends IShape> at_distance(IScope iScope, IContainer<?, ? extends IShape> iContainer, Double d) {
        IType<?> iType = iContainer.getGamlType().getContentType();
        if (iType.isAgentType()) {
            return SpatialQueries._neighbors(iScope, In.list(iScope, iContainer), iScope.getAgent(), d);
        }
        if (iType == Types.GEOMETRY) {
            return SpatialQueries.geomAtDistance(iScope, iContainer, d);
        }
        return GamaListFactory.create();
    }

    public static IList<? extends IShape> geomAtDistance(IScope iScope, IContainer<?, ? extends IShape> iContainer, Double d) {
        IAgent iAgent = iScope.getAgent();
        IList iList = GamaListFactory.create(Types.GEOMETRY);
        for (Object e : iContainer.listValue(iScope, Types.GEOMETRY, false)) {
            if (!(e instanceof IShape) || !(iScope.getTopology().distanceBetween(iScope, iAgent, (IShape)e) <= d)) continue;
            iList.add((IShape)e);
        }
        return iList;
    }

    static IList<? extends IShape> relatedEntities(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape, ITopology.SpatialRelation spatialRelation) {
        IType<?> iType = iContainer.getGamlType().getContentType();
        if (iType.isAgentType()) {
            return SpatialQueries._gather(iScope, In.list(iScope, iContainer), iShape, spatialRelation);
        }
        if (Types.GEOMETRY.isAssignableFrom(iType)) {
            return SpatialQueries.geomsRelated(iScope, iContainer, iShape, spatialRelation);
        }
        return GamaListFactory.EMPTY_LIST;
    }

    @GamlAnnotations.operator(value={"inside"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents or geometries among the left-operand list, species or meta-population (addition of species), covered by the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] inside(self)", equals="the agents among ag1, ag2 and ag3 that are covered by the shape of the right-hand argument.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) inside (self)", equals="the agents among species species1 and species2 that are covered by the shape of the right-hand argument.", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "closest_to", "overlapping", "agents_overlapping", "agents_inside", "agent_closest_to"})
    public static IList<? extends IShape> inside(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        return SpatialQueries.relatedEntities(iScope, iContainer, iShape, ITopology.SpatialRelation.INSIDE);
    }

    @GamlAnnotations.operator(value={"covering"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents or geometries among the left-operand list, species or meta-population (addition of species), covering the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] covering(self)", equals="the agents among ag1, ag2 and ag3 that cover the shape of the right-hand argument.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) covering (self)", equals="the agents among species species1 and species2 that covers the shape of the right-hand argument.", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "closest_to", "overlapping", "agents_overlapping", "inside", "agents_inside", "agent_closest_to"})
    public static IList<? extends IShape> covering(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        return SpatialQueries.relatedEntities(iScope, iContainer, iShape, ITopology.SpatialRelation.COVER);
    }

    @GamlAnnotations.operator(value={"crossing"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents or geometries among the left-operand list, species or meta-population (addition of species), crossing the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] crossing(self)", equals="the agents among ag1, ag2 and ag3 that cross the shape of the right-hand argument.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) crossing (self)", equals="the agents among species species1 and species2 that cross the shape of the right-hand argument.", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "closest_to", "overlapping", "agents_overlapping", "inside", "agents_inside", "agent_closest_to"})
    public static IList<? extends IShape> crossing(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        return SpatialQueries.relatedEntities(iScope, iContainer, iShape, ITopology.SpatialRelation.CROSS);
    }

    @GamlAnnotations.operator(value={"touching"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents or geometries among the left-operand list, species or meta-population (addition of species), touching the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] toucing(self)", equals="the agents among ag1, ag2 and ag3 that touch the shape of the right-hand argument.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) touching (self)", equals="the agents among species species1 and species2 that touch the shape of the right-hand argument.", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "closest_to", "overlapping", "agents_overlapping", "inside", "agents_inside", "agent_closest_to"})
    public static IList<? extends IShape> touching(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        return SpatialQueries.relatedEntities(iScope, iContainer, iShape, ITopology.SpatialRelation.TOUCH);
    }

    @GamlAnnotations.operator(value={"partially_overlapping"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents or geometries among the left-operand list, species or meta-population (addition of species), partially_overlapping the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] partially_overlapping(self)", equals="the agents among ag1, ag2 and ag3 that partially_overlap the shape of the right-hand argument.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) partially_overlapping (self)", equals="the agents among species species1 and species2 that partially_overlap the shape of the right-hand argument.", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "closest_to", "overlapping", "agents_overlapping", "inside", "agents_inside", "agent_closest_to"})
    public static IList<? extends IShape> partiallyOverlapping(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        return SpatialQueries.relatedEntities(iScope, iContainer, iShape, ITopology.SpatialRelation.PARTIALLY_OVERLAP);
    }

    @GamlAnnotations.operator(value={"overlapping", "intersecting"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents or geometries among the left-operand list, species or meta-population (addition of species), overlapping the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] overlapping(self)", equals="return the agents among ag1, ag2 and ag3 that overlap the shape of the agent applying the operator.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) overlapping self", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "agent_closest_to", "agents_inside", "closest_to", "inside", "agents_overlapping"})
    public static IList<? extends IShape> overlapping(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        return SpatialQueries.relatedEntities(iScope, iContainer, iShape, ITopology.SpatialRelation.OVERLAP);
    }

    public static IList<? extends IShape> geomsRelated(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape, ITopology.SpatialRelation spatialRelation) {
        IList iList = GamaListFactory.create(Types.GEOMETRY);
        PreparedGeometryFactory preparedGeometryFactory = new PreparedGeometryFactory();
        PreparedGeometry preparedGeometry = preparedGeometryFactory.create(iShape.getInnerGeometry());
        for (Object e : iContainer.listValue(iScope, Types.GEOMETRY, false)) {
            if (!(e instanceof IShape) || !AbstractTopology.accept(preparedGeometry, ((IShape)e).getInnerGeometry(), spatialRelation)) continue;
            iList.add((IShape)e);
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"closest_to"}, type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="An agent or a geometry among the left-operand list of agents, species or meta-population (addition of species), the closest to the operand (casted as a geometry).", comment="the distance is computed in the topology of the calling agent (the agent in which this operator is used), with the distance algorithm specific to the topology.", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] closest_to(self)", equals="return the closest agent among ag1, ag2 and ag3 to the agent applying the operator.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) closest_to self", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "inside", "overlapping", "agents_overlapping", "agents_inside", "agent_closest_to"})
    public static IShape closest_to(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        if (iContainer == null) {
            return null;
        }
        IType<?> iType = iContainer.getGamlType().getContentType();
        if (iType.isAgentType()) {
            return SpatialQueries._closest(iScope, In.list(iScope, iContainer), iShape);
        }
        if (iContainer.getGamlType().getContentType().isTranslatableInto(Types.GEOMETRY)) {
            return SpatialQueries.geomClostestTo(iScope, iContainer, iShape);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"closest_to"}, content_type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="The N agents or geometries among the left-operand list of agents, species or meta-population (addition of species), that are the closest to the operand (casted as a geometry).", comment="the distance is computed in the topology of the calling agent (the agent in which this operator is used), with the distance algorithm specific to the topology.", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] closest_to(self, 2)", equals="return the 2 closest agents among ag1, ag2 and ag3 to the agent applying the operator.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) closest_to (self, 5)", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "inside", "overlapping", "agents_overlapping", "agents_inside", "agent_closest_to"})
    public static IList<IShape> closest_to(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape, int n) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaListFactory.EMPTY_LIST;
        }
        IType<?> iType = iContainer.getGamlType().getContentType();
        if (iType.isAgentType()) {
            return SpatialQueries._closest(iScope, In.list(iScope, iContainer), iShape, n);
        }
        if (iContainer.getGamlType().getContentType().isTranslatableInto(Types.GEOMETRY)) {
            return SpatialQueries.geomClostestTo(iScope, iContainer, iShape, n);
        }
        return GamaListFactory.create(iType);
    }

    @GamlAnnotations.operator(value={"farthest_to"}, type=-299, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="An agent or a geometry among the left-operand list of agents, species or meta-population (addition of species), the farthest to the operand (casted as a geometry).", comment="the distance is computed in the topology of the calling agent (the agent in which this operator is used), with the distance algorithm specific to the topology.", examples={@GamlAnnotations.example(value="[ag1, ag2, ag3] closest_to(self)", equals="return the farthest agent among ag1, ag2 and ag3 to the agent applying the operator.", isExecutable=false), @GamlAnnotations.example(value="(species1 + species2) closest_to self", isExecutable=false)}, see={"neighbors_at", "neighbors_of", "neighbors_at", "inside", "overlapping", "agents_overlapping", "agents_inside", "agent_closest_to", "closest_to", "agent_farthest_to"})
    public static IShape farthest_to(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        IType<?> iType = iContainer.getGamlType().getContentType();
        if (iType.isAgentType()) {
            return SpatialQueries._farthest(iScope, In.list(iScope, iContainer), iShape);
        }
        if (iContainer.getGamlType().getContentType().isTranslatableInto(Types.GEOMETRY)) {
            return SpatialQueries.geomFarthestTo(iScope, iContainer, iShape);
        }
        return null;
    }

    public static IShape geomClostestTo(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        IShape iShape2 = null;
        double d = Double.MAX_VALUE;
        for (Object e : iContainer.listValue(iScope, Types.GEOMETRY, false)) {
            double d2;
            if (!(e instanceof IShape) || !((d2 = iScope.getTopology().distanceBetween(iScope, iShape, (IShape)e).doubleValue()) < d)) continue;
            iShape2 = (IShape)e;
            d = d2;
        }
        return iShape2;
    }

    public static IList<IShape> geomClostestTo(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape, int n) {
        IList<IShape> iList = iContainer.listValue(iScope, Types.GEOMETRY, true);
        iList.removeIf(object -> !(object instanceof IShape));
        IList<IShape> iList2 = iList;
        if (iList2.size() <= n) {
            return iList2;
        }
        iScope.getRandom().shuffleInPlace(iList2);
        Ordering ordering = Ordering.natural().onResultOf(iShape2 -> Double.valueOf(iShape.euclidianDistanceTo((IShape)iShape2)));
        return GamaListFactory.wrap((IType)Types.GEOMETRY, ordering.leastOf(iList2, n));
    }

    public static IShape geomFarthestTo(IScope iScope, IContainer<?, ? extends IShape> iContainer, IShape iShape) {
        IShape iShape2 = null;
        double d = Double.MIN_VALUE;
        for (Object e : iContainer.listValue(iScope, Types.GEOMETRY, false)) {
            double d2;
            if (!(e instanceof IShape) || !((d2 = iScope.getTopology().distanceBetween(iScope, iShape, (IShape)e).doubleValue()) > d)) continue;
            iShape2 = (IShape)e;
            d = d2;
        }
        return iShape2;
    }

    @GamlAnnotations.operator(value={"agent_closest_to"}, type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="An agent, the closest to the operand (casted as a geometry).", comment="the distance is computed in the topology of the calling agent (the agent in which this operator is used), with the distance algorithm specific to the topology.", examples={@GamlAnnotations.example(value="agent_closest_to(self)", equals="the closest agent to the agent applying the operator.", test=false)}, see={"neighbors_at", "neighbors_of", "agents_inside", "agents_overlapping", "closest_to", "inside", "overlapping"})
    public static IAgent agent_closest_to(IScope iScope, Object object) {
        return SpatialQueries._closest(iScope, Different.with(), object);
    }

    @GamlAnnotations.operator(value={"agent_farthest_to"}, type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="An agent, the farthest to the operand (casted as a geometry).", comment="the distance is computed in the topology of the calling agent (the agent in which this operator is used), with the distance algorithm specific to the topology.", examples={@GamlAnnotations.example(value="agent_farthest_to(self)", equals="the farthest agent to the agent applying the operator.", test=false)}, see={"neighbors_at", "neighbors_of", "agents_inside", "agents_overlapping", "closest_to", "inside", "overlapping", "agent_closest_to", "farthest_to"})
    public static IAgent agent_farthest_to(IScope iScope, Object object) {
        return SpatialQueries._farthest(iScope, Different.with(), object);
    }

    @GamlAnnotations.operator(value={"agents_touching"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents touching the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="agents_touching(self)", equals="the agents that touch the shape of the agent applying the operator.", test=false)}, see={"agent_closest_to", "agents_overlapping", "closest_to", "inside", "overlapping"})
    public static IList<IAgent> agents_touching(IScope iScope, Object object) {
        return SpatialQueries._gather(iScope, Different.with(), object, ITopology.SpatialRelation.TOUCH);
    }

    @GamlAnnotations.operator(value={"agents_crossing"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents cross the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="agents_crossing(self)", equals="the agents that crossing the shape of the agent applying the operator.", test=false)}, see={"agent_closest_to", "agents_overlapping", "closest_to", "inside", "overlapping"})
    public static IList<IAgent> agents_crossing(IScope iScope, Object object) {
        return SpatialQueries._gather(iScope, Different.with(), object, ITopology.SpatialRelation.CROSS);
    }

    @GamlAnnotations.operator(value={"agents_partially_overlapping"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents that partially overlap the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="agents_partially_overlapping(self)", equals="the agents that partially overlap the shape of the agent applying the operator.", test=false)}, see={"agent_closest_to", "agents_overlapping", "closest_to", "inside", "overlapping"})
    public static IList<IAgent> agents_partially_overlapping(IScope iScope, Object object) {
        return SpatialQueries._gather(iScope, Different.with(), object, ITopology.SpatialRelation.PARTIALLY_OVERLAP);
    }

    @GamlAnnotations.operator(value={"agents_covering"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents covered by the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="agents_covering(self)", equals="the agents that cover the shape of the agent applying the operator.", test=false)}, see={"agent_closest_to", "agents_overlapping", "closest_to", "inside", "overlapping"})
    public static IList<IAgent> agents_cover(IScope iScope, Object object) {
        return SpatialQueries._gather(iScope, Different.with(), object, ITopology.SpatialRelation.COVER);
    }

    @GamlAnnotations.operator(value={"agents_inside"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents covered by the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="agents_inside(self)", equals="the agents that are covered by the shape of the agent applying the operator.", test=false)}, see={"agent_closest_to", "agents_overlapping", "closest_to", "inside", "overlapping"})
    public static IList<IAgent> agents_inside(IScope iScope, Object object) {
        return SpatialQueries._gather(iScope, Different.with(), object, ITopology.SpatialRelation.INSIDE);
    }

    @GamlAnnotations.operator(value={"agents_overlapping", "agent_intersecting"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents overlapping the operand (casted as a geometry).", examples={@GamlAnnotations.example(value="agents_overlapping(self)", equals="the agents that overlap the shape of the agent applying the operator.", test=false)}, see={"neighbors_at", "neighbors_of", "agent_closest_to", "agents_inside", "closest_to", "inside", "overlapping", "at_distance"})
    public static IList<IAgent> agents_overlapping(IScope iScope, Object object) {
        return SpatialQueries._gather(iScope, Different.with(), object, ITopology.SpatialRelation.OVERLAP);
    }

    @GamlAnnotations.operator(value={"agents_at_distance"}, content_type=11, category={"Spatial operators", "Spatial queries operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "agent_location"})
    @GamlAnnotations.doc(value="A list of agents situated at a distance lower than the right argument.", examples={@GamlAnnotations.example(value="agents_at_distance(20)", equals="all the agents (excluding the caller) which distance to the caller is lower than 20", test=false)}, see={"neighbors_at", "neighbors_of", "agent_closest_to", "agents_inside", "closest_to", "inside", "overlapping", "at_distance"})
    public static IList agents_at_distance(IScope iScope, Double d) {
        return SpatialQueries._neighbors(iScope, Different.with(), iScope.getAgent(), d);
    }

    private static IList<IAgent> _gather(IScope iScope, IAgentFilter iAgentFilter, Object object, ITopology.SpatialRelation spatialRelation) {
        if (iAgentFilter == null || object == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        IType iType = iAgentFilter.getSpecies() == null ? Types.AGENT : iScope.getType(iAgentFilter.getSpecies().getName());
        return GamaListFactory.wrap(iType, iScope.getTopology().getAgentsIn(iScope, Cast.asGeometry(iScope, object, false), iAgentFilter, spatialRelation));
    }

    private static IAgent _closest(IScope iScope, IAgentFilter iAgentFilter, Object object) {
        if (iAgentFilter == null || object == null) {
            return null;
        }
        ITopology iTopology = iScope.getTopology();
        if (iTopology == null) {
            return null;
        }
        return iTopology.getAgentClosestTo(iScope, Cast.asGeometry(iScope, object, false), iAgentFilter);
    }

    private static IList<IAgent> _closest(IScope iScope, IAgentFilter iAgentFilter, Object object, int n) {
        if (iAgentFilter == null || object == null) {
            return null;
        }
        IType iType = iAgentFilter.getSpecies() == null ? Types.AGENT : iScope.getType(iAgentFilter.getSpecies().getName());
        return GamaListFactory.wrap(iType, iScope.getTopology().getAgentClosestTo(iScope, Cast.asGeometry(iScope, object, false), iAgentFilter, n));
    }

    private static IAgent _farthest(IScope iScope, IAgentFilter iAgentFilter, Object object) {
        if (iAgentFilter == null || object == null) {
            return null;
        }
        return iScope.getTopology().getAgentFarthestTo(iScope, Cast.asGeometry(iScope, object, false), iAgentFilter);
    }

    private static IList<IAgent> _neighbors(IScope iScope, IAgentFilter iAgentFilter, Object object, Object object2) {
        return SpatialQueries._neighbors(iScope, iAgentFilter, object, object2, iScope.getTopology());
    }

    static IList<IAgent> _neighbors(IScope iScope, IAgentFilter iAgentFilter, Object object, Object object2, ITopology iTopology) {
        if (iAgentFilter == null || object == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        IType iType = iAgentFilter.getSpecies() == null ? Types.AGENT : iScope.getType(iAgentFilter.getSpecies().getName());
        return GamaListFactory.wrap(iType, iTopology.getNeighborsOf(iScope, Cast.asGeometry(iScope, object, false), Cast.asFloat(iScope, object2), iAgentFilter));
    }
}

