/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.Facets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Arguments
extends Facets {
    public static final Arguments NULL = new Arguments();
    List<String> keys;
    ThreadLocal<IAgent> caller = new ThreadLocal();

    public Arguments(Arguments arguments) {
        super(arguments);
        if (arguments != null) {
            this.setCaller(arguments.caller.get());
        }
    }

    public Arguments(Map<String, Object> map) {
        map.forEach((string, object) -> {
            IExpressionDescription iExpressionDescription = this.put((String)string, ConstantExpressionDescription.create(object));
        });
    }

    public Arguments(IAgent iAgent, Map<String, Object> map) {
        this(map);
        this.setCaller(iAgent);
    }

    public Arguments() {
    }

    @Override
    public Arguments cleanCopy() {
        Arguments arguments = new Arguments();
        arguments.setCaller(this.caller.get());
        this.forEach((string, iExpressionDescription) -> {
            IExpressionDescription iExpressionDescription2 = arguments.put((String)string, iExpressionDescription.cleanCopy());
        });
        return arguments;
    }

    public Arguments resolveAgainst(IScope iScope) {
        Arguments arguments = new Arguments();
        arguments.setCaller(this.caller.get());
        this.forEach((string, iExpressionDescription) -> {
            IExpression iExpression = this.getExpr((String)string);
            if (iExpression != null) {
                arguments.putExpression((String)string, iExpression.resolveAgainst(iScope));
            }
        });
        return arguments;
    }

    @Override
    public IExpressionDescription put(String string, IExpressionDescription iExpressionDescription) {
        if (this.keys == null || !this.keys.contains(string)) {
            if (this.keys == null) {
                this.keys = new ArrayList<String>();
            }
            this.keys.add(string);
        }
        return super.put(string, iExpressionDescription);
    }

    public IExpressionDescription remove(String string) {
        if (this.keys != null) {
            this.keys.remove(string);
        }
        return (IExpressionDescription)super.remove(string);
    }

    public void setCaller(IAgent iAgent) {
        this.caller.set(iAgent);
    }

    public IAgent getCaller() {
        return this.caller.get();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.caller.set(null);
    }

    public IExpression getExpr(int n) {
        if (n > this.size() || n < 0) {
            return null;
        }
        String string = this.keys.get(n);
        return ((IExpressionDescription)this.get(string)).getExpression();
    }
}

