/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.gaml.constants.GamlCoreConstants;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class DrawingAttributes {
    private static int INDEX;
    public static final GamaColor TEXTURED_COLOR;
    public static final GamaColor SELECTED_COLOR;
    EnumSet<Flag> flags = EnumSet.of(Flag.Lighted);
    private final int uniqueIndex;
    GamaPoint location;
    Scaling3D size;
    AxisAngle rotation;
    Double depth = null;
    Double lineWidth = GamaPreferences.Displays.CORE_LINE_WIDTH.getValue();
    public IShape.Type type;
    GamaColor fill;
    GamaColor highlight;
    GamaColor border;
    List<?> textures;

    static {
        DEBUG.ON();
        INDEX = 0;
        TEXTURED_COLOR = GamaColor.get(Color.white);
        SELECTED_COLOR = GamaColor.get(Color.red);
    }

    private DrawingAttributes() {
        this.uniqueIndex = INDEX++;
    }

    public DrawingAttributes(Scaling3D scaling3D, AxisAngle axisAngle, GamaPoint gamaPoint, GamaColor gamaColor, GamaColor gamaColor2, Boolean bl) {
        this();
        this.setBorder(gamaColor2);
        this.setFill(gamaColor);
        this.setSize(scaling3D);
        this.setLocation(gamaPoint == null ? null : new GamaPoint(gamaPoint));
        this.setRotation(axisAngle);
        this.setLighting(bl);
    }

    public int getIndex() {
        return this.uniqueIndex;
    }

    public void setSynthetic(boolean bl) {
        this.setFlag(Flag.Synthetic, bl);
    }

    public boolean isSynthetic() {
        return this.isSet(Flag.Synthetic);
    }

    public void setLighting(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.setFlag(Flag.Lighted, bl);
    }

    public void setEmpty(Boolean bl) {
        if (bl == null || !bl.booleanValue()) {
            this.setFilled();
        } else {
            this.setEmpty();
        }
    }

    public IAgent getAgentIdentifier() {
        return null;
    }

    public String getSpeciesName() {
        return null;
    }

    public Double getAngle() {
        if (this.getRotation() == null) {
            return null;
        }
        return this.getRotation().angle;
    }

    public void setTexture(Object object) {
        if (object == null) {
            this.setTextures(null);
        } else {
            this.setTextures(Collections.singletonList(object));
        }
    }

    public void markSelected(int n) {
        this.setSelected(n == this.uniqueIndex);
    }

    public GamaPoint getAnchor() {
        return GamlCoreConstants.bottom_left;
    }

    public GamaPoint getLocation() {
        return this.location;
    }

    public Scaling3D getSize() {
        return this.size;
    }

    public Double getDepth() {
        return this.depth;
    }

    public void setLineWidth(Double d) {
        this.lineWidth = d == null ? GamaPreferences.Displays.CORE_LINE_WIDTH.getValue() : d;
    }

    public Double getLineWidth() {
        return this.lineWidth;
    }

    public IShape.Type getType() {
        return this.type;
    }

    public boolean useCache() {
        return this.isSet(Flag.UseCache);
    }

    public void setUseCache(boolean bl) {
        this.setFlag(Flag.UseCache, bl);
    }

    public void setType(IShape.Type type2) {
        this.type = type2;
    }

    public AxisAngle getRotation() {
        return this.rotation;
    }

    public void setLocation(GamaPoint gamaPoint) {
        this.location = gamaPoint;
    }

    public void setSize(Scaling3D scaling3D) {
        this.size = scaling3D;
    }

    public void setRotation(AxisAngle axisAngle) {
        if (axisAngle == null) {
            return;
        }
        this.rotation = axisAngle;
    }

    public void setHeight(Double d) {
        if (d == null) {
            return;
        }
        this.depth = d;
    }

    public GamaColor getColor() {
        if (this.isSelected()) {
            return SELECTED_COLOR;
        }
        if (this.highlight != null) {
            return this.highlight;
        }
        if (this.isSet(Flag.Empty)) {
            return null;
        }
        if (this.fill == null) {
            if (this.textures != null) {
                return TEXTURED_COLOR;
            }
            return GamaPreferences.Displays.CORE_COLOR.getValue();
        }
        return this.fill;
    }

    public GamaColor getBorder() {
        if (this.isSet(Flag.Empty) && this.border == null) {
            return this.fill;
        }
        return this.border;
    }

    public void setEmpty() {
        this.setFlag(Flag.Empty, true);
    }

    public void setFilled() {
        this.setFlag(Flag.Empty, false);
    }

    public void setFill(GamaColor gamaColor) {
        this.fill = gamaColor;
    }

    public void setBorder(GamaColor gamaColor) {
        this.border = gamaColor;
    }

    void setLighting(boolean bl) {
        this.setFlag(Flag.Lighted, bl);
    }

    public void setNoBorder() {
        this.border = null;
    }

    public void setTextures(List<?> list) {
        this.textures = list;
    }

    public List getTextures() {
        return this.textures;
    }

    public boolean isEmpty() {
        return this.isSet(Flag.Empty);
    }

    public boolean isAnimated() {
        if (!this.useCache()) {
            return true;
        }
        if (this.textures == null) {
            return false;
        }
        Object obj = this.textures.get(0);
        if (!(obj instanceof IImageProvider)) {
            return false;
        }
        IImageProvider iImageProvider = (IImageProvider)obj;
        return iImageProvider.isAnimated();
    }

    public boolean isLighting() {
        return this.isSet(Flag.Lighted);
    }

    public void setHighlighted(GamaColor gamaColor) {
        this.highlight = gamaColor;
    }

    public boolean isSelected() {
        return this.isSet(Flag.Selected);
    }

    public void setSelected(boolean bl) {
        this.setFlag(Flag.Selected, bl);
    }

    public boolean isSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public void setFlag(Flag flag, boolean bl) {
        if (bl) {
            this.flags.add(flag);
        } else {
            this.flags.remove((Object)flag);
        }
    }

    public static enum DrawerType {
        GEOMETRY,
        STRING,
        MESH,
        RESOURCE;

    }

    public static enum Flag {
        Empty,
        Selected,
        Synthetic,
        Lighted,
        UseCache,
        Grayscaled,
        Triangulated,
        WithText,
        Perspective;

    }
}

