/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Transformation3D;
import gama.core.metamodel.shape.GamaPoint;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;

public class Rotation3D
implements Serializable,
Transformation3D {
    public static final GamaPoint PLUS_I = new GamaPoint(1.0, 0.0, 0.0);
    public static final GamaPoint MINUS_I = new GamaPoint(-1.0, 0.0, 0.0);
    public static final GamaPoint PLUS_J = new GamaPoint(0.0, 1.0, 0.0);
    public static final GamaPoint PLUS_K = new GamaPoint(0.0, 0.0, 1.0);
    private double q0;
    private double q1;
    private double q2;
    private double q3;

    public Rotation3D(double d, double d2, double d3, double d4, boolean bl) {
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
        if (bl) {
            double d5 = 1.0 / Math.sqrt(this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3);
            this.q0 *= d5;
            this.q1 *= d5;
            this.q2 *= d5;
            this.q3 *= d5;
        }
    }

    public void setToIdentity() {
        this.q0 = 1.0;
        this.q1 = 0.0;
        this.q2 = 0.0;
        this.q3 = 0.0;
    }

    public void alignToHorizontal(GamaPoint gamaPoint) {
        double d = gamaPoint.norm();
        if (-gamaPoint.x < -0.999999999999998 * d) {
            GamaPoint gamaPoint2 = gamaPoint.orthogonal();
            this.q0 = 0.0;
            this.q1 = -gamaPoint2.x;
            this.q2 = -gamaPoint2.y;
            this.q3 = -gamaPoint2.z;
        } else {
            this.q0 = Math.sqrt(0.5 * (1.0 - gamaPoint.x / d));
            double d2 = 1.0 / (2.0 * this.q0 * d);
            this.q1 = 0.0;
            this.q2 = d2 * gamaPoint.z;
            this.q3 = d2 * -gamaPoint.y;
        }
    }

    public Rotation3D(GamaPoint gamaPoint, double d) {
        GamaPoint gamaPoint2 = gamaPoint;
        if (gamaPoint2 == null) {
            gamaPoint2 = PLUS_K;
        }
        double d2 = gamaPoint2.norm();
        double d3 = -0.5 * d;
        double d4 = Math.sin(d3) / d2;
        this.q0 = Math.cos(d3);
        this.q1 = d4 * gamaPoint2.x;
        this.q2 = d4 * gamaPoint2.y;
        this.q3 = d4 * gamaPoint2.z;
    }

    public Rotation3D(AxisAngle axisAngle) {
        this(axisAngle.axis, Math.toRadians(axisAngle.angle));
    }

    public Rotation3D rotateToHorizontal(GamaPoint gamaPoint, GamaPoint gamaPoint2, boolean bl) {
        if (Math.abs(gamaPoint.z) == 1.0) {
            this.alignToHorizontal(gamaPoint2);
            return this;
        }
        double d = gamaPoint.x;
        double d2 = gamaPoint.y;
        double d3 = gamaPoint.z;
        double d4 = d2 * gamaPoint2.z - d3 * gamaPoint2.y;
        double d5 = gamaPoint2.x * d3 - gamaPoint2.z * d;
        double d6 = d * gamaPoint2.y - d2 * gamaPoint2.x;
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        gamaPoint2.setLocation(-(d5 /= d7) * d3 + (d6 /= d7) * d2, -d * d6 + d3 * (d4 /= d7), -d4 * d2 + d5 * d).normalize();
        if (bl) {
            d *= -1.0;
            d2 *= -1.0;
            d3 *= -1.0;
        } else {
            d4 *= -1.0;
            d5 *= -1.0;
            d6 *= -1.0;
        }
        double d8 = gamaPoint2.x + d5 + d3;
        if (d8 > -0.19) {
            this.q0 = 0.5 * Math.sqrt(d8 + 1.0);
            double d9 = 0.25 / this.q0;
            this.q1 = d9 * (d6 - d2);
            this.q2 = d9 * (d - gamaPoint2.z);
            this.q3 = d9 * (gamaPoint2.y - d4);
        } else {
            d8 = gamaPoint2.x - d5 - d3;
            if (d8 > -0.19) {
                this.q1 = 0.5 * Math.sqrt(d8 + 1.0);
                double d10 = 0.25 / this.q1;
                this.q0 = d10 * (d6 - d2);
                this.q2 = d10 * (gamaPoint2.y + d4);
                this.q3 = d10 * (gamaPoint2.z + d);
            } else {
                d8 = d5 - gamaPoint2.x - d3;
                if (d8 > -0.19) {
                    this.q2 = 0.5 * Math.sqrt(d8 + 1.0);
                    double d11 = 0.25 / this.q2;
                    this.q0 = d11 * (d - gamaPoint2.z);
                    this.q1 = d11 * (gamaPoint2.y + d4);
                    this.q3 = d11 * (d2 + d6);
                } else {
                    d8 = d3 - gamaPoint2.x - d5;
                    this.q3 = 0.5 * Math.sqrt(d8 + 1.0);
                    double d12 = 0.25 / this.q3;
                    this.q0 = d12 * (gamaPoint2.y - d4);
                    this.q1 = d12 * (gamaPoint2.z + d);
                    this.q2 = d12 * (d2 + d6);
                }
            }
        }
        return this;
    }

    public Rotation3D revertInPlace() {
        this.q0 = -this.q0;
        return this;
    }

    public GamaPoint getAxis() {
        double d = this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (d == 0.0) {
            return PLUS_I;
        }
        if (this.q0 < 0.0) {
            double d2 = 1.0 / Math.sqrt(d);
            return new GamaPoint(this.q1 * d2, this.q2 * d2, this.q3 * d2);
        }
        double d3 = -1.0 / Math.sqrt(d);
        return new GamaPoint(this.q1 * d3, this.q2 * d3, this.q3 * d3);
    }

    public double getAngle() {
        if (this.q0 < -0.1 || this.q0 > 0.1) {
            return 2.0 * Math.asin(Math.sqrt(this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3));
        }
        if (this.q0 < 0.0) {
            return 2.0 * Math.acos(-this.q0);
        }
        return 2.0 * Math.acos(this.q0);
    }

    @Override
    public void applyTo(GamaPoint gamaPoint) {
        double d = gamaPoint.x;
        double d2 = gamaPoint.y;
        double d3 = gamaPoint.z;
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        gamaPoint.x = 2.0 * (this.q0 * (d * this.q0 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d;
        gamaPoint.y = 2.0 * (this.q0 * (d2 * this.q0 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2;
        gamaPoint.z = 2.0 * (this.q0 * (d3 * this.q0 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3;
    }

    public void applyTo(Coordinate coordinate) {
        double d = coordinate.x;
        double d2 = coordinate.y;
        double d3 = coordinate.z;
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        coordinate.x = 2.0 * (this.q0 * (d * this.q0 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d;
        coordinate.y = 2.0 * (this.q0 * (d2 * this.q0 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2;
        coordinate.z = 2.0 * (this.q0 * (d3 * this.q0 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3;
    }

    public Rotation3D applyTo(Rotation3D rotation3D) {
        return new Rotation3D(rotation3D.q0 * this.q0 - (rotation3D.q1 * this.q1 + rotation3D.q2 * this.q2 + rotation3D.q3 * this.q3), rotation3D.q1 * this.q0 + rotation3D.q0 * this.q1 + (rotation3D.q2 * this.q3 - rotation3D.q3 * this.q2), rotation3D.q2 * this.q0 + rotation3D.q0 * this.q2 + (rotation3D.q3 * this.q1 - rotation3D.q1 * this.q3), rotation3D.q3 * this.q0 + rotation3D.q0 * this.q3 + (rotation3D.q1 * this.q2 - rotation3D.q2 * this.q1), false);
    }

    public static Rotation3D identity() {
        return new Rotation3D(1.0, 0.0, 0.0, 0.0, false);
    }

    public void filter(Coordinate coordinate) {
        this.applyTo(coordinate);
    }

    public static class CenteredOn
    extends Rotation3D {
        final GamaPoint center;

        public CenteredOn(AxisAngle axisAngle, GamaPoint gamaPoint) {
            super(axisAngle);
            this.center = gamaPoint;
        }

        @Override
        public void filter(Coordinate coordinate) {
            GamaPoint gamaPoint = (GamaPoint)coordinate;
            gamaPoint.subtract(this.center);
            this.applyTo(gamaPoint);
            gamaPoint.add(this.center);
        }
    }
}

