/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.agent;

import com.google.common.primitives.Ints;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.agent.ISerialisedAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.List;
import java.util.Map;

public abstract class AbstractAgent
implements IAgent {
    private final int index;
    protected volatile boolean dead = false;
    protected volatile boolean dying = false;
    protected IMap<String, Object> attributes;

    protected AbstractAgent(int n) {
        this.index = n;
    }

    @Override
    public IAgent getAgent() {
        return this;
    }

    @Override
    public void setAgent(IAgent iAgent) {
    }

    @Override
    public void dispose() {
        IShape iShape;
        if (this.dead) {
            return;
        }
        this.dead = true;
        IPopulation<? extends IAgent> iPopulation = this.getPopulation();
        if (iPopulation != null && !iPopulation.isDisposing()) {
            iPopulation.removeValue(null, this);
        }
        if ((iShape = this.getGeometry()) != null) {
            iShape.dispose();
        }
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        GAMA.getBufferingController().flushSaveFilesOfAgent(this);
        GAMA.getBufferingController().flushWriteOfAgent(this);
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.serializeToGaml(true);
    }

    @Override
    public IShape copy(IScope iScope) throws GamaRuntimeException {
        return this;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(this.getSpeciesName()).append('(').append(this.getIndex()).append(')');
        if (this.dead()) {
            stringBuilder.append(" /* dead */");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getName();
    }

    public IMap<String, Object> getAttributes(boolean bl) {
        if (this.attributes == null && bl) {
            this.attributes = GamaMapFactory.create(Types.STRING, Types.NO_TYPE);
        }
        return this.attributes;
    }

    @Override
    public int compareTo(IAgent iAgent) {
        return Ints.compare((int)this.getIndex(), (int)iAgent.getIndex());
    }

    @Override
    public boolean init(IScope iScope) throws GamaRuntimeException {
        return this.getSpecies().getArchitecture().init(iScope) ? this.initSubPopulations(iScope) : false;
    }

    @Override
    public boolean step(IScope iScope) throws GamaRuntimeException {
        boolean bl = false;
        try {
            boolean bl2 = bl = this.preStep(iScope) && this.doStep(iScope);
            return bl2;
        }
        finally {
            if (bl) {
                this.postStep(iScope);
            }
        }
    }

    protected boolean preStep(IScope iScope) {
        return iScope.update(this).passed();
    }

    protected boolean doStep(IScope iScope) {
        return iScope.execute(this.getSpecies().getArchitecture(), this, null).passed() ? this.stepSubPopulations(iScope) : false;
    }

    protected boolean initSubPopulations(IScope iScope) {
        return true;
    }

    protected boolean stepSubPopulations(IScope iScope) {
        return true;
    }

    protected void postStep(IScope iScope) {
    }

    @Override
    public ITopology getTopology() {
        return this.getPopulation().getTopology();
    }

    @Override
    public void setPeers(IList<IAgent> iList) {
    }

    @Override
    public IList<IAgent> getPeers() throws GamaRuntimeException {
        if (this.getHost() == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        IPopulation<? extends IAgent> iPopulation = this.getHost().getPopulationFor(this.getSpecies());
        if (iPopulation != null) {
            IScope iScope = this.getScope();
            IList<IAgent> iList = GamaListFactory.createWithoutCasting(iScope.getType(this.getSpeciesName()), iPopulation);
            iList.remove(this);
            return iList;
        }
        return GamaListFactory.EMPTY_LIST;
    }

    @Override
    public String getName() {
        return this.getSpeciesName() + this.getIndex() + (this.dead() ? " (dead)" : "");
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public GamaPoint getLocation(IScope iScope) {
        return this.getGeometry().getLocation();
    }

    @Override
    public GamaPoint setLocation(IScope iScope, GamaPoint gamaPoint) {
        return this.getGeometry(iScope).setLocation(gamaPoint);
    }

    @Override
    public void setGeometry(IScope iScope, IShape iShape) {
        this.getGeometry(iScope).setGeometry(iShape);
    }

    @Override
    public boolean dead() {
        return this.dead;
    }

    @Override
    public IMacroAgent getHost() {
        return this.getPopulation().getHost();
    }

    @Override
    public void setHost(IMacroAgent iMacroAgent) {
    }

    @Override
    public void schedule(IScope iScope) {
        if (!this.dead()) {
            iScope.init(this);
        }
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public String getSpeciesName() {
        return this.getSpecies().getName();
    }

    @Override
    public ISpecies getSpecies() {
        return this.getPopulation().getSpecies();
    }

    @Override
    public boolean isInstanceOf(ISpecies iSpecies, boolean bl) {
        ISpecies iSpecies2 = this.getSpecies();
        if (iSpecies2 == iSpecies) {
            return true;
        }
        if (!bl) {
            return iSpecies2.extendsSpecies(iSpecies);
        }
        return false;
    }

    @Override
    public Object getDirectVarValue(IScope iScope, String string) throws GamaRuntimeException {
        IVariable iVariable;
        IVariable iVariable2 = this.getPopulation().getVar(string);
        if (iVariable2 != null) {
            return iVariable2.value(iScope, this);
        }
        IMacroAgent iMacroAgent = this.getHost();
        if (iMacroAgent != null && (iVariable = iMacroAgent.getPopulation().getVar(string)) != null) {
            return iVariable.value(iScope, iMacroAgent);
        }
        return null;
    }

    @Override
    public void setDirectVarValue(IScope iScope, String string, Object object) throws GamaRuntimeException {
        IVariable iVariable = this.getPopulation().getVar(string);
        if (iVariable != null) {
            iVariable.setVal(iScope, this, object);
        } else {
            IVariable iVariable2;
            IMacroAgent iMacroAgent = this.getHost();
            if (iMacroAgent != null && (iVariable2 = iMacroAgent.getPopulation().getVar(string)) != null) {
                iVariable2.setVal(iScope, iMacroAgent, object);
            }
        }
    }

    @Override
    public List<IAgent> getMacroAgents() {
        IList<IAgent> iList = GamaListFactory.create(Types.AGENT);
        IMacroAgent iMacroAgent = this.getHost();
        while (iMacroAgent != null) {
            iList.add(iMacroAgent);
            iMacroAgent = iMacroAgent.getHost();
        }
        return iList;
    }

    @Override
    public IModel getModel() {
        IMacroAgent iMacroAgent = this.getHost();
        if (iMacroAgent == null) {
            return GAMA.getModel();
        }
        return iMacroAgent.getModel();
    }

    @Override
    public IScope getScope() {
        IMacroAgent iMacroAgent = this.getHost();
        if (iMacroAgent == null) {
            return null;
        }
        return iMacroAgent.getScope();
    }

    @Override
    public boolean isInstanceOf(String string, boolean bl) {
        return this.getSpecies().implementsSkill(string);
    }

    @Override
    public IPopulation<? extends IAgent> getPopulationFor(ISpecies iSpecies) {
        IPopulation<? extends IAgent> iPopulation = this.getPopulationFor(iSpecies.getName());
        if (iPopulation == null) {
            ModelDescription modelDescription = iSpecies.getDescription().getModelDescription();
            ModelDescription modelDescription2 = this.getModel().getDescription();
            if (modelDescription2.getMicroModel(modelDescription.getAlias()) != null && this.getHost() != null) {
                iPopulation = this.getHost().getExternMicroPopulationFor(modelDescription.getAlias() + "." + iSpecies.getName());
            }
        }
        return iPopulation;
    }

    @Override
    public IPopulation<? extends IAgent> getPopulationFor(String string) {
        IMacroAgent iMacroAgent = this.getHost();
        if (iMacroAgent == null) {
            return null;
        }
        return this.getHost().getPopulationFor(string);
    }

    @GamlAnnotations.action(name="debug", args={@GamlAnnotations.arg(name="message", type=4, doc={@GamlAnnotations.doc(value="The message to display")})})
    public final Object primDebug(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("message", 4);
        iScope.getGui().getConsole().debugConsole(iScope.getClock().getCycle(), string + "\nsender: " + String.valueOf(Cast.asMap(iScope, this, false)), iScope.getRoot());
        return string;
    }

    @GamlAnnotations.action(name="error", args={@GamlAnnotations.arg(name="message", type=4, doc={@GamlAnnotations.doc(value="The message to display")})})
    public final Object primError(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("message", 4);
        iScope.getGui().openErrorDialog(iScope, string);
        return string;
    }

    @GamlAnnotations.action(name="tell", args={@GamlAnnotations.arg(name="msg", type=4, doc={@GamlAnnotations.doc(value="The message to display")}), @GamlAnnotations.arg(name="add_name", optional=true, type=3, doc={@GamlAnnotations.doc(value="Should the name of the agent that uses the action be displayed?")})})
    public final Object primTell(IScope iScope) throws GamaRuntimeException {
        boolean bl = !iScope.hasArg("add_name") || Cast.asBool(iScope, iScope.getArg("add_name", 3)) != false;
        String string = (String)(bl ? this.getName() + " says : " : "") + String.valueOf(iScope.getArg("msg", 4));
        iScope.getGui().openMessageDialog(iScope, string);
        return string;
    }

    @Override
    public Object primDie(IScope iScope) throws GamaRuntimeException {
        if (!this.dying) {
            this.dying = true;
            this.getSpecies().getArchitecture().abort(iScope);
            iScope.setDeathStatus();
            this.dispose();
        }
        return null;
    }

    @Override
    public IShape.Type getGeometricalType() {
        return this.getGeometry().getGeometricalType();
    }

    @Override
    public IType<?> getGamlType() {
        return this.getScope().getType(this.getSpeciesName());
    }

    @Override
    public Object get(IScope iScope, String string) throws GamaRuntimeException {
        if (this.getPopulation().hasVar(string)) {
            return iScope.getAgentVarValue(this, string);
        }
        return this.getAttribute(string);
    }

    @Override
    public Object getFromIndicesList(IScope iScope, IList<String> iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return this.get(iScope, iList.firstValue(iScope));
    }

    public void setDefiningPlugin(String string) {
    }

    @Override
    public void updateWith(IScope iScope, ISerialisedAgent iSerialisedAgent) {
        Map<String, Object> map = iSerialisedAgent.attributes();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.setDirectVarValue(iScope, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public SimulationAgent getSimulation() {
        return this.getPopulation().getHost().getSimulation();
    }
}

