/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.population;

import com.google.common.base.Predicate;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.interfaces.IStepable;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.GamaPopulation;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonObject;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.variables.IVariable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IPopulation<T extends IAgent>
extends Comparable<IPopulation<T>>,
IList<T>,
IStepable,
IDisposable,
IPopulationSet<T> {
    public static IPopulation<? extends IAgent> createEmpty(ISpecies iSpecies) {
        return new GamaPopulation(null, iSpecies);
    }

    public void createVariablesFor(IScope var1, T var2) throws GamaRuntimeException;

    public boolean hasVar(String var1);

    @Override
    default public IPopulation<? extends IAgent> getPopulation(IScope iScope) {
        return this;
    }

    public IList<T> createAgents(IScope var1, int var2, List<? extends Map<String, Object>> var3, boolean var4, boolean var5, RemoteSequence var6) throws GamaRuntimeException;

    public IList<T> createAgents(IScope var1, IContainer<?, ? extends IShape> var2) throws GamaRuntimeException;

    default public IList<T> createAgents(IScope iScope, int n, List<? extends Map<String, Object>> list, boolean bl, boolean bl2) throws GamaRuntimeException {
        return this.createAgents(iScope, n, list, bl, bl2, null);
    }

    public T createAgentAt(IScope var1, int var2, Map<String, Object> var3, boolean var4, boolean var5) throws GamaRuntimeException;

    public String getName();

    public boolean isGrid();

    public boolean hasAspect(String var1);

    public IExecutable getAspect(String var1);

    public Collection<String> getAspectNames();

    @Override
    public ISpecies getSpecies();

    public IVariable getVar(String var1);

    public boolean hasUpdatableVariables();

    public ITopology getTopology();

    public void initializeFor(IScope var1) throws GamaRuntimeException;

    public IMacroAgent getHost();

    public void setHost(IMacroAgent var1);

    public void killMembers() throws GamaRuntimeException;

    public T getAgent(Integer var1);

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public void updateVariables(IScope var1, IAgent var2);

    public T getAgent(IScope var1, GamaPoint var2);

    @Override
    public T[] toArray();

    public boolean isInitOverriden();

    public boolean isStepOverriden();

    public T getOrCreateAgent(IScope var1, Integer var2);

    @Override
    default public JsonObject serializeToJson(Json json) {
        return json.object("population", this.getSpecies().getName(), "agents", this.subList(0, this.size()));
    }

    default public <T extends IAgent> void fireAgentsAdded(IScope iScope, IList<T> iList) {
    }

    public boolean isDisposing();

    public static class IsLiving
    implements Predicate<IAgent> {
        public boolean apply(IAgent iAgent) {
            return iAgent != null && !iAgent.dead();
        }
    }

    public static interface Listener {
        public void notifyAgentRemoved(IScope var1, IPopulation<? extends IAgent> var2, IAgent var3);

        public void notifyAgentAdded(IScope var1, IPopulation<? extends IAgent> var2, IAgent var3);

        public void notifyAgentsAdded(IScope var1, IPopulation<? extends IAgent> var2, Collection<? extends IAgent> var3);

        public void notifyAgentsRemoved(IScope var1, IPopulation<? extends IAgent> var2, Collection<? extends IAgent> var3);

        public void notifyPopulationCleared(IScope var1, IPopulation<? extends IAgent> var2);
    }
}

