/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import com.google.common.collect.Ordering;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaProxyGeometry;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.grid.GridHexagonalNeighborhood;
import gama.core.metamodel.topology.grid.GridHexagonalNeighborhoodHorizontal;
import gama.core.metamodel.topology.grid.GridHexagonalNeighborhoodVertical;
import gama.core.metamodel.topology.grid.GridMooreNeighborhood;
import gama.core.metamodel.topology.grid.GridVonNeumannNeighborhood;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.metamodel.topology.grid.INeighborhood;
import gama.core.metamodel.topology.grid.NoCacheNeighborhood;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaGridFile;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.IMatrix;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.PathFactory;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialProjections;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.referencing.ReferenceIdentifier;

public class GamaSpatialMatrix
extends GamaMatrix<IShape>
implements IGrid {
    public final boolean useIndividualShapes;
    public final IShape environmentFrame;
    public boolean useNeighborsCache = false;
    public String optimizer = "A*";
    final Envelope bounds;
    final double precision;
    protected IShape[] matrix;
    double cellWidth;
    double cellHeight;
    public int[] supportImagePixels;
    public double[] gridValue;
    public int nbBands = 1;
    public List<IList<Double>> bands = null;
    protected Boolean usesVN = null;
    protected Boolean isTorus = null;
    protected Boolean isHexagon = null;
    protected Boolean isHorizontalOrientation = null;
    public INeighborhood neighborhood;
    int actualNumberOfCells;
    int firstCell;
    int lastCell;
    private ISpecies cellSpecies;
    Map hexAgentToLoc = null;
    final IShape referenceShape;

    @Override
    public void dispose() {
        if (this.neighborhood != null) {
            this.neighborhood.clear();
        }
        this.neighborhood = null;
        this.gridValue = null;
        this._clear();
        this.matrix = null;
        this.cellSpecies = null;
    }

    public GamaSpatialMatrix(IScope iScope, IShape iShape, Integer n, Integer n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws GamaRuntimeException {
        super(n, n2, Types.GEOMETRY);
        this.environmentFrame = iShape.getGeometry();
        this.bounds = this.environmentFrame.getEnvelope();
        this.cellWidth = this.bounds.getWidth() / (double)n.intValue();
        this.cellHeight = this.bounds.getHeight() / (double)n2.intValue();
        this.precision = this.bounds.getWidth() / 1000.0;
        int n3 = this.numRows * this.numCols;
        this.createMatrix(n3);
        this.supportImagePixels = new int[n3];
        this.isTorus = bl;
        this.usesVN = bl2;
        this.actualNumberOfCells = 0;
        this.referenceShape = GamaGeometryType.buildRectangle(this.cellWidth, this.cellHeight, new GamaPoint(0.0, 0.0));
        this.firstCell = -1;
        this.lastCell = -1;
        this.isHexagon = false;
        this.useIndividualShapes = bl3;
        this.useNeighborsCache = bl4;
        this.createCells(iScope, false);
        this.optimizer = string;
    }

    public GamaSpatialMatrix(IScope iScope, GamaGridFile gamaGridFile, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws GamaRuntimeException {
        super(100, 100, Types.GEOMETRY);
        this.numRows = gamaGridFile.getRows(iScope);
        this.numCols = gamaGridFile.getCols(iScope);
        this.environmentFrame = iScope.getSimulation().getGeometry();
        this.bounds = this.environmentFrame.getEnvelope();
        this.cellWidth = this.bounds.getWidth() / (double)this.numCols;
        this.cellHeight = this.bounds.getHeight() / (double)this.numRows;
        this.precision = this.bounds.getWidth() / 1000.0;
        int n = gamaGridFile.length(iScope);
        this.createMatrix(n);
        this.supportImagePixels = new int[n];
        this.referenceShape = GamaGeometryType.buildRectangle(this.cellWidth, this.cellHeight, new GamaPoint(0.0, 0.0));
        this.isTorus = bl;
        this.usesVN = bl2;
        this.useIndividualShapes = bl3;
        this.isHexagon = false;
        this.useNeighborsCache = bl4;
        this.optimizer = string;
        this.gridValue = (double[])gamaGridFile.getFieldData(iScope).clone();
        this.nbBands = gamaGridFile.getBandsNumber(iScope);
        if (this.nbBands > 1) {
            this.bands = new ArrayList<IList<Double>>();
            int n2 = 0;
            while (n2 < n) {
                IList iList = GamaListFactory.create(Types.FLOAT);
                int n3 = 0;
                while (n3 < this.nbBands) {
                    iList.add(gamaGridFile.getBand(iScope, n3)[n2]);
                    ++n3;
                }
                this.bands.add(iList);
                ++n2;
            }
        }
        this.actualNumberOfCells = 0;
        this.firstCell = -1;
        this.lastCell = -1;
        this.createCells(iScope, false);
    }

    public GamaSpatialMatrix(IScope iScope, IList<GamaGridFile> iList, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws GamaRuntimeException {
        this(iScope, iList.firstValue(iScope), bl, bl2, bl3, bl4, string);
        Object object;
        Object object2;
        Object object3;
        this.nbBands = iList.size();
        this.bands = new ArrayList<IList<Double>>();
        ArrayList arrayList = new ArrayList();
        int n = 1;
        while (n < iList.size()) {
            object3 = null;
            IProjection iProjection = ((GamaGridFile)iList.get(n)).getGis(iScope);
            object2 = iProjection.getInitialCRS(iScope);
            object = object2.getIdentifiers().toArray(new ReferenceIdentifier[0]);
            if (((ReferenceIdentifier[])object).length > 0) {
                object3 = object[0].toString();
            }
            arrayList.add(object3);
            ++n;
        }
        n = 0;
        while (n < this.matrix.length) {
            object3 = GamaListFactory.create(Types.FLOAT);
            object3.add(this.gridValue[n]);
            int n2 = 1;
            while (n2 < iList.size()) {
                object2 = (GamaGridFile)iList.get(n2);
                object = (String)arrayList.get(n2 - 1);
                GamaPoint gamaPoint = this.matrix[n].getLocation();
                if (object != null) {
                    gamaPoint = SpatialProjections.transform_CRS(iScope, gamaPoint, (String)object).getLocation();
                }
                Double d = ((GamaGridFile)object2).valueOf(iScope, gamaPoint);
                object3.add(d);
                ++n2;
            }
            this.bands.add((IList<Double>)object3);
            ++n;
        }
        this.actualNumberOfCells = 0;
        this.firstCell = -1;
        this.lastCell = -1;
        this.createCells(iScope, false);
    }

    public GamaSpatialMatrix(IScope iScope, IShape iShape, Integer n, Integer n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string) {
        super(n, n2, Types.GEOMETRY);
        this.isHorizontalOrientation = bl4;
        this.environmentFrame = iShape.getGeometry();
        this.bounds = this.environmentFrame.getEnvelope();
        this.cellWidth = this.bounds.getWidth() / (double)n.intValue();
        this.cellHeight = this.bounds.getHeight() / (double)n2.intValue();
        this.referenceShape = GamaGeometryType.buildRectangle(this.cellWidth, this.cellHeight, new GamaPoint(0.0, 0.0));
        this.precision = this.bounds.getWidth() / 1000.0;
        int n3 = this.numRows * this.numCols;
        this.createMatrix(n3);
        this.supportImagePixels = new int[n3];
        this.isTorus = bl;
        this.usesVN = false;
        this.isHexagon = bl3;
        this.actualNumberOfCells = 0;
        this.firstCell = -1;
        this.lastCell = -1;
        this.useIndividualShapes = bl5;
        this.optimizer = string;
        this.useNeighborsCache = bl6;
        if (this.isHorizontalOrientation != null && !this.isHorizontalOrientation.booleanValue()) {
            this.createHexagonsVertical(iScope, false);
        } else {
            this.createHexagonsHorizontal(iScope, false);
        }
    }

    private void createMatrix(int n) {
        this.matrix = new IShape[n];
        this.gridValue = new double[n];
    }

    private void createHexagonsHorizontal(IScope iScope, boolean bl) {
        GamaShape gamaShape;
        int n;
        double d = this.environmentFrame.getEnvelope().getWidth();
        double d2 = this.environmentFrame.getEnvelope().getHeight();
        double d3 = this.environmentFrame.getEnvelope().getMinX();
        double d4 = this.environmentFrame.getEnvelope().getMinY();
        this.cellWidth = d / ((double)this.numCols * 0.75 + 0.25);
        this.cellHeight = d2 / ((double)this.numRows + 0.5);
        d3 += this.cellWidth / 2.0;
        d4 += this.cellHeight / 2.0;
        this.hexAgentToLoc = GamaMapFactory.create();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                n2 = n + this.numCols * n3;
                gamaShape = (GamaShape)GamaGeometryType.buildHexagon(this.cellWidth, this.cellHeight, new GamaPoint(d3 + (double)n * this.cellWidth * 0.75, d4 + (double)n3 * this.cellHeight));
                if (this.firstCell == -1) {
                    this.firstCell = n2;
                }
                this.matrix[n2] = gamaShape;
                this.hexAgentToLoc.put(gamaShape, new GamaPoint(n, n3));
                ++this.actualNumberOfCells;
                this.lastCell = Math.max(this.lastCell, n2);
                n += 2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.numRows) {
            n = 1;
            while (n < this.numCols) {
                n2 = n + this.numCols * n3;
                gamaShape = (GamaShape)GamaGeometryType.buildHexagon(this.cellWidth, this.cellHeight, new GamaPoint(d3 + (double)n * this.cellWidth * 0.75, d4 + ((double)n3 + 0.5) * this.cellHeight));
                if (this.firstCell == -1) {
                    this.firstCell = n2;
                }
                this.matrix[n2] = gamaShape;
                this.hexAgentToLoc.put(gamaShape, new GamaPoint(n, n3));
                ++this.actualNumberOfCells;
                this.lastCell = Math.max(this.lastCell, n2);
                n += 2;
            }
            ++n3;
        }
    }

    private void createHexagonsVertical(IScope iScope, boolean bl) {
        IShape iShape;
        int n;
        double d = this.environmentFrame.getEnvelope().getWidth();
        double d2 = this.environmentFrame.getEnvelope().getHeight();
        double d3 = this.environmentFrame.getEnvelope().getMinX();
        double d4 = this.environmentFrame.getEnvelope().getMinY();
        this.cellWidth = d / ((double)this.numCols + 0.5);
        this.cellHeight = d2 / ((double)this.numRows * 0.75 + 0.25);
        d3 += this.cellWidth / 2.0;
        d4 += this.cellHeight / 2.0;
        this.hexAgentToLoc = GamaMapFactory.create();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                n2 = n + this.numCols * n3;
                iShape = SpatialTransformations.rotated_by(iScope, GamaGeometryType.buildHexagon(this.cellHeight, this.cellWidth, new GamaPoint(d3 + (double)n * this.cellWidth, d4 + (double)n3 * this.cellHeight * 0.75)), 90.0);
                if (this.firstCell == -1) {
                    this.firstCell = n2;
                }
                this.matrix[n2] = iShape;
                this.hexAgentToLoc.put(iShape, new GamaPoint(n, n3));
                ++this.actualNumberOfCells;
                this.lastCell = Math.max(this.lastCell, n2);
                ++n;
            }
            n3 += 2;
        }
        n3 = 1;
        while (n3 < this.numRows) {
            n = 0;
            while (n < this.numCols) {
                n2 = n + this.numCols * n3;
                iShape = SpatialTransformations.rotated_by(iScope, GamaGeometryType.buildHexagon(this.cellHeight, this.cellWidth, new GamaPoint(d3 * 2.0 + (double)n * this.cellWidth, d4 + (double)n3 * this.cellHeight * 0.75)), 90.0);
                if (this.firstCell == -1) {
                    this.firstCell = n2;
                }
                this.matrix[n2] = iShape;
                this.hexAgentToLoc.put(iShape, new GamaPoint(n, n3));
                ++this.actualNumberOfCells;
                this.lastCell = Math.max(this.lastCell, n2);
                ++n;
            }
            n3 += 2;
        }
    }

    private void createCells(IScope iScope, boolean bl) throws GamaRuntimeException {
        int n;
        boolean bl2 = this.environmentFrame.getInnerGeometry().isRectangle();
        GamaPoint gamaPoint = new GamaPoint(this.environmentFrame.getEnvelope().getMinX(), this.environmentFrame.getEnvelope().getMinY());
        IShape iShape = SpatialTransformations.translated_by(iScope, this.environmentFrame, gamaPoint);
        GamaPoint[][] gamaPointArray = new GamaPoint[this.numCols + 1][this.numRows + 1];
        int n2 = 0;
        while (n2 < this.numCols + 1) {
            n = 0;
            while (n < this.numRows + 1) {
                GamaPoint gamaPoint2;
                gamaPointArray[n2][n] = gamaPoint2 = new GamaPoint((double)n2 * this.cellWidth, (double)n * this.cellHeight);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        n = this.numRows * this.numCols;
        while (n2 < n) {
            boolean bl3;
            int n3 = n2 / this.numCols;
            int n4 = n2 - n3 * this.numCols;
            IShape iShape2 = null;
            if (this.useIndividualShapes) {
                iShape2 = GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createRectangle(gamaPointArray[n4][n3], gamaPointArray[n4 + 1][n3], gamaPointArray[n4 + 1][n3 + 1], gamaPointArray[n4][n3 + 1], gamaPointArray[n4][n3]));
            } else {
                double d = this.cellWidth / 2.0;
                double d2 = this.cellHeight / 2.0;
                iShape2 = new CellProxyGeometry(new GamaPoint((double)n4 * this.cellWidth + d, (double)n3 * this.cellHeight + d2));
            }
            boolean bl4 = bl3 = bl2 || iShape.covers(iShape2);
            if (bl && !bl3 && iShape2.intersects(iShape)) {
                iShape2.setGeometry(SpatialOperators.inter(iScope, iShape2, iShape));
                bl3 = true;
            }
            if (bl3) {
                if (this.firstCell == -1) {
                    this.firstCell = n2;
                }
                this.matrix[n2] = iShape2;
                ++this.actualNumberOfCells;
                this.lastCell = n2;
            }
            ++n2;
        }
    }

    @Override
    public INeighborhood getNeighborhood() {
        if (this.neighborhood == null) {
            this.neighborhood = this.useNeighborsCache ? (this.isHexagon.booleanValue() ? (this.isHorizontalOrientation != null && !this.isHorizontalOrientation.booleanValue() ? new GridHexagonalNeighborhoodVertical(this) : new GridHexagonalNeighborhoodHorizontal(this)) : (this.usesVN != false ? new GridVonNeumannNeighborhood(this) : new GridMooreNeighborhood(this))) : new NoCacheNeighborhood(this);
        }
        return this.neighborhood;
    }

    @Override
    public int[] getDisplayData() {
        return this.supportImagePixels;
    }

    @Override
    public double[] getGridValue() {
        return this.gridValue;
    }

    @Override
    public double[] getGridValueOf(IScope iScope, IExpression iExpression) {
        double[] dArray = new double[this.matrix.length];
        int n = 0;
        while (n < this.matrix.length) {
            IAgent iAgent;
            IShape iShape = this.matrix[n];
            if (iShape != null && (iAgent = iShape.getAgent()) != null) {
                dArray[n] = Cast.asFloat(iScope, iScope.evaluate(iExpression, iAgent).getValue());
            }
            ++n;
        }
        return dArray;
    }

    public double getGridValue(int n, int n2) {
        int n3 = this.getPlaceIndexAt(n, n2);
        if (n3 != -1) {
            return this.gridValue[n3];
        }
        return 0.0;
    }

    final int getPlaceIndexAt(int n, int n2) {
        if (this.isHexagon.booleanValue()) {
            return n2 * this.numCols + n;
        }
        if (this.isTorus.booleanValue()) {
            return (n2 < 0 ? n2 + this.numCols : n2) % this.numRows * this.numCols + (n < 0 ? n + this.numCols : n) % this.numCols;
        }
        if (n < 0 || n >= this.numCols || n2 < 0 || n2 >= this.numRows) {
            return -1;
        }
        return n2 * this.numCols + n;
    }

    private final int getPlaceIndexAt(GamaPoint gamaPoint) {
        if (this.isHexagon.booleanValue()) {
            int n = 0;
            int n2 = 0;
            if (this.isHorizontalOrientation.booleanValue()) {
                n = (int)(gamaPoint.getX() / (this.cellWidth * 0.75));
                n2 = n % 2 == 0 ? (int)(gamaPoint.getY() / this.cellHeight) : (int)((gamaPoint.getY() - this.cellHeight) / this.cellHeight);
            } else {
                n2 = (int)(gamaPoint.getY() / (this.cellHeight * 0.75));
                n = n2 % 2 == 0 ? (int)(gamaPoint.getX() / this.cellWidth) : (int)((gamaPoint.getX() - this.cellWidth) / this.cellWidth);
            }
            n = Math.min(n, this.numCols - 1);
            n2 = Math.min(n2, this.numRows - 1);
            int n3 = this.getPlaceIndexAt(n, n2);
            if (this.matrix[n3] == null) {
                return -1;
            }
            if (this.matrix[n3].getLocation() == gamaPoint || this.matrix[n3].intersects(gamaPoint)) {
                return n3;
            }
            Set<Integer> set = ((GridHexagonalNeighborhood)this.getNeighborhood()).getNeighborsAtRadius1(n3, this.numCols, this.numRows, this.isTorus);
            set.add(n3);
            int n4 = 0;
            int n5 = 0;
            for (int n6 : set) {
                IShape iShape = this.matrix[n6];
                if (!iShape.intersects(gamaPoint)) continue;
                GamaPoint gamaPoint2 = (GamaPoint)this.hexAgentToLoc.get(iShape.getGeometry());
                n4 = (int)gamaPoint2.x;
                n5 = (int)gamaPoint2.y;
                return this.getPlaceIndexAt(n4, n5);
            }
            return -1;
        }
        double d = gamaPoint.getX();
        double d2 = gamaPoint.getY();
        double d3 = d == this.bounds.getMaxX() ? (d - this.precision) / this.cellWidth : d / this.cellWidth;
        double d4 = d2 == this.bounds.getMaxY() ? (d2 - this.precision) / this.cellHeight : d2 / this.cellHeight;
        int n = (int)d3;
        int n7 = (int)d4;
        return this.getPlaceIndexAt(n, n7);
    }

    @Override
    public final int getX(IShape iShape) {
        return (int)((GamaPoint)this.hexAgentToLoc.get((Object)iShape)).x;
    }

    @Override
    public final int getY(IShape iShape) {
        return (int)((GamaPoint)this.hexAgentToLoc.get((Object)iShape)).y;
    }

    @Override
    public IShape getPlaceAt(GamaPoint gamaPoint) {
        if (gamaPoint == null) {
            return null;
        }
        int n = this.getPlaceIndexAt(gamaPoint);
        if (n == -1) {
            return null;
        }
        return this.matrix[n];
    }

    @Override
    public void shuffleWith(RandomUtils randomUtils) {
    }

    @Override
    public IShape get(IScope iScope, int n, int n2) {
        int n3 = this.getPlaceIndexAt(n, n2);
        if (n3 != -1) {
            return this.matrix[n3];
        }
        return null;
    }

    @Override
    public void set(IScope iScope, int n, int n2, Object object) throws GamaRuntimeException {
    }

    @Override
    public IShape remove(IScope iScope, int n, int n2) {
        return null;
    }

    @Override
    public boolean _removeFirst(IScope iScope, IShape iShape) throws GamaRuntimeException {
        return false;
    }

    @Override
    public boolean _removeAll(IScope iScope, IContainer<?, IShape> iContainer) throws GamaRuntimeException {
        return false;
    }

    @Override
    public void _clear() {
        Arrays.fill(this.matrix, null);
        this.matrix = null;
    }

    @Override
    protected IList _listValue(IScope iScope, IType iType, boolean bl) {
        if (this.actualNumberOfCells == 0) {
            return GamaListFactory.EMPTY_LIST;
        }
        if (this.cellSpecies == null) {
            return bl ? GamaListFactory.create(iScope, iType, this.matrix) : GamaListFactory.wrap(iType, this.matrix);
        }
        IList iList = GamaListFactory.create(iType, this.actualNumberOfCells);
        IShape[] iShapeArray = this.matrix;
        int n = this.matrix.length;
        int n2 = 0;
        while (n2 < n) {
            IShape iShape = iShapeArray[n2];
            if (iShape != null) {
                IAgent iAgent = iShape.getAgent();
                IShape iShape2 = iAgent == null ? iShape : iAgent;
                iList.add(bl ? iType.cast(iScope, iShape2, null, false) : iShape2);
            }
            ++n2;
        }
        return iList;
    }

    @Override
    public Iterable<IShape> iterable(IScope iScope) {
        return Arrays.asList(this.matrix);
    }

    @Override
    protected IMatrix _matrixValue(IScope iScope, GamaPoint gamaPoint, IType iType, boolean bl) {
        return GamaMatrixType.from(iScope, this, iType, gamaPoint, bl);
    }

    @Override
    public Integer _length(IScope iScope) {
        return this.actualNumberOfCells;
    }

    @Override
    public IShape _first(IScope iScope) {
        if (this.firstCell == -1) {
            return null;
        }
        return this.matrix[this.firstCell];
    }

    @Override
    public IShape _last(IScope iScope) {
        if (this.lastCell == -1) {
            return null;
        }
        return this.matrix[this.lastCell];
    }

    @Override
    public IMatrix _reverse(IScope iScope) throws GamaRuntimeException {
        return null;
    }

    @Override
    public IMatrix copy(IScope iScope, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        if (gamaPoint == null && !bl) {
            return this;
        }
        return new GamaSpatialMatrix(iScope, this.environmentFrame, this.numCols, this.numRows, this.isTorus, this.usesVN, this.useIndividualShapes, this.useNeighborsCache, this.optimizer);
    }

    @Override
    public boolean _contains(IScope iScope, Object object) {
        if (this.cellSpecies != null) {
            return this.cellSpecies.contains(iScope, object);
        }
        return false;
    }

    @Override
    public void _putAll(IScope iScope, Object object) throws GamaRuntimeException {
    }

    @Override
    public boolean _isEmpty(IScope iScope) {
        return this.actualNumberOfCells == 0;
    }

    @Override
    public boolean usesIndiviualShapes() {
        return this.useIndividualShapes;
    }

    @Override
    public int manhattanDistanceBetween(IShape iShape, IShape iShape2) {
        IGridAgent iGridAgent;
        IGridAgent iGridAgent2 = iShape.getAgent() != null && iShape.getAgent().getSpecies() == this.getCellSpecies() ? (IGridAgent)iShape.getAgent() : null;
        IGridAgent iGridAgent3 = iGridAgent = iShape2.getAgent() != null && iShape2.getAgent().getSpecies() == this.getCellSpecies() ? (IGridAgent)iShape2.getAgent() : null;
        if (iGridAgent2 == null || iGridAgent == null) {
            GamaPoint gamaPoint;
            GamaPoint gamaPoint2 = iShape.isPoint() ? iShape.getLocation() : null;
            GamaPoint gamaPoint3 = gamaPoint = iShape2.isPoint() ? iShape2.getLocation() : null;
            if (iGridAgent2 == null && !(iGridAgent2 = (IGridAgent)this.getPlaceAt(iShape.getLocation())).covers(iShape)) {
                iGridAgent2 = null;
            }
            if (iGridAgent == null && !(iGridAgent = (IGridAgent)this.getPlaceAt(iShape2.getLocation())).covers(iShape2)) {
                iGridAgent = null;
            }
            Coordinate[] coordinateArray = new DistanceOp(iShape.getInnerGeometry(), iShape2.getInnerGeometry()).nearestPoints();
            if (iGridAgent2 == null) {
                gamaPoint2 = new GamaPoint(coordinateArray[0]);
                iGridAgent2 = (IGridAgent)this.getPlaceAt(gamaPoint2);
            }
            if (iGridAgent == null) {
                gamaPoint = new GamaPoint(coordinateArray[1]);
                iGridAgent = (IGridAgent)this.getPlaceAt(gamaPoint);
            }
        }
        int n = Math.abs(iGridAgent2.getX() - iGridAgent.getX());
        int n2 = Math.abs(iGridAgent2.getY() - iGridAgent.getY());
        if (this.usesVN.booleanValue()) {
            return n + n2;
        }
        return Math.max(n, n2);
    }

    @Override
    public Set<IAgent> getNeighborsOf(IScope iScope, IShape iShape, Double d, IAgentFilter iAgentFilter) {
        if (iShape.isPoint() || iShape.getAgent() != null && iShape.getAgent().getSpecies() == this.cellSpecies) {
            return this.getNeighborsOf(iScope, iShape.getLocation(), d, iAgentFilter);
        }
        Collection collection = this.allInEnvelope(iScope, iShape, iShape.getEnvelope(), null, true);
        LinkedHashSet<IAgent> linkedHashSet = new LinkedHashSet<IAgent>();
        for (IAgent iAgent : collection) {
            linkedHashSet.addAll(this.getNeighborhood().getNeighborsIn(iScope, this.getPlaceIndexAt(iAgent.getLocation()), d.intValue()));
        }
        linkedHashSet.removeAll(collection);
        if (iAgentFilter != null && iAgentFilter.getSpecies() != this.cellSpecies) {
            iAgentFilter.filter(iScope, iShape, linkedHashSet);
        }
        return linkedHashSet;
    }

    protected Set<IAgent> getNeighborsOf(IScope iScope, GamaPoint gamaPoint, Double d, IAgentFilter iAgentFilter) {
        Set<IAgent> set = this.getNeighborhood().getNeighborsIn(iScope, this.getPlaceIndexAt(gamaPoint), d.intValue());
        if (iAgentFilter != null) {
            if (iAgentFilter.getSpecies() == this.cellSpecies) {
                return set;
            }
            iAgentFilter.filter(iScope, gamaPoint, set);
        }
        return set;
    }

    static IAgent testPlace(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, IShape iShape2) {
        if (iAgentFilter.accept(iScope, iShape, iShape2)) {
            return iShape2.getAgent();
        }
        ITopology.SpatialRelation spatialRelation = iAgentFilter.getSpecies() != null && iShape2.getAgent() != null && iAgentFilter.getSpecies().equals(iShape2.getAgent().getSpecies()) ? ITopology.SpatialRelation.INSIDE : ITopology.SpatialRelation.OVERLAP;
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>(iScope.getTopology().getAgentsIn(iScope, iShape2, iAgentFilter, spatialRelation));
        arrayList.remove(iShape);
        if (arrayList.isEmpty()) {
            return null;
        }
        iScope.getRandom().shuffleInPlace(arrayList);
        return (IAgent)arrayList.get(0);
    }

    public IAgent getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter) throws GamaRuntimeException {
        int n = this.getPlaceIndexAt(iShape.getLocation());
        IAgent iAgent = this.matrix[n].getAgent();
        if (iAgentFilter.accept(iScope, iShape, iAgent)) {
            return iAgent;
        }
        IAgent iAgent2 = GamaSpatialMatrix.testPlace(iScope, iShape, iAgentFilter, iAgent);
        if (iAgent2 != null) {
            return iAgent2;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        arrayList.add(iAgent.getIndex());
        List<IAgent> list = this.getNeighborhoods(iScope, iAgent, arrayList, new ArrayList<IAgent>());
        iScope.getRandom().shuffleInPlace(list);
        while (n2 < this.numCols * this.numRows) {
            ++n2;
            Throwable throwable = null;
            Object var11_12 = null;
            try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
                for (IAgent iAgent3 : list) {
                    iAgent2 = GamaSpatialMatrix.testPlace(iScope, iShape, iAgentFilter, iAgent3);
                    if (iAgent2 != null) {
                        return iAgent2;
                    }
                    arrayList.add(iAgent3.getIndex());
                    asOrderedSet.addAll(this.getNeighborhoods(iScope, iAgent3, arrayList, list));
                }
                asOrderedSet.shuffleInPlaceWith(iScope.getRandom());
                list = new ArrayList<IAgent>(asOrderedSet.items());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return null;
    }

    private List<IAgent> getNeighborhoods(IScope iScope, IAgent iAgent, List<Integer> list, List<IAgent> list2) throws GamaRuntimeException {
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>(this.getNeighborsOf(iScope, iAgent.getLocation(), (Double)1.0, null));
        ArrayList<IAgent> arrayList2 = new ArrayList<IAgent>();
        for (IAgent iAgent2 : arrayList) {
            if (list.contains(iAgent2.getIndex()) || list2.contains(iAgent2) || arrayList2.contains(iAgent2)) continue;
            arrayList2.add(iAgent2);
        }
        return arrayList2;
    }

    double heuristic(IAgent iAgent, IAgent iAgent2) {
        return iAgent.getLocation().euclidianDistanceTo(iAgent2.getLocation());
    }

    public GamaSpatialPath computeShortestPathBetweenBF(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IList<IAgent> iList) throws GamaRuntimeException {
        IAgent iAgent;
        int n = this.getPlaceIndexAt(iShape.getLocation());
        int n2 = this.getPlaceIndexAt(iShape2.getLocation());
        IAgent iAgent2 = this.matrix[n].getAgent();
        if (iAgent2 == (iAgent = this.matrix[n2].getAgent())) {
            return this.simplePath(iScope, iShape, iShape2, iTopology, iAgent2, iAgent);
        }
        boolean[] blArray = new boolean[this.getAgents().size()];
        this.initOpen(blArray, iList);
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>();
        Hashtable<IAgent, IAgent> hashtable = new Hashtable<IAgent, IAgent>();
        arrayList.add(iAgent2);
        while (!arrayList.isEmpty()) {
            IAgent iAgent3 = (IAgent)arrayList.remove(0);
            if (iAgent3 == iAgent) {
                return this.finalPath(iScope, iShape, iShape2, iTopology, iAgent2, iAgent3, hashtable);
            }
            Set<IAgent> set = this.getNeighborhood().getNeighborsIn(iScope, iAgent3.getIndex(), 1);
            for (IAgent iAgent4 : set) {
                if (!blArray[iAgent4.getIndex()]) continue;
                arrayList.add(iAgent4);
                hashtable.put(iAgent4, iAgent3);
                blArray[iAgent4.getIndex()] = false;
            }
        }
        return null;
    }

    public GamaSpatialPath computeShortestPathBetweenDijkstra(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IList<IAgent> iList, Map<IAgent, Object> map) throws GamaRuntimeException {
        IAgent iAgent;
        int n = this.getPlaceIndexAt(iShape.getLocation());
        int n2 = this.getPlaceIndexAt(iShape2.getLocation());
        IAgent iAgent2 = this.matrix[n].getAgent();
        if (iAgent2 == (iAgent = this.matrix[n2].getAgent())) {
            return this.simplePath(iScope, iShape, iShape2, iTopology, iAgent2, iAgent);
        }
        Double d = map != null ? Math.max(this.cellHeight, this.cellWidth) : 0.0;
        boolean[] blArray = new boolean[this.getAgents().size()];
        this.initOpen(blArray, map != null ? map.keySet() : iList);
        HashMap<IAgent, IAgent> hashMap = new HashMap<IAgent, IAgent>();
        PriorityQueue priorityQueue = this.newPriorityQueue();
        HashMap<IAgent, Double> hashMap2 = new HashMap<IAgent, Double>();
        hashMap2.put(iAgent2, 0.0);
        priorityQueue.add(new ArrayList(iAgent2){
            {
                this.add(iAgent);
                this.add(0.0);
            }
        });
        while (!priorityQueue.isEmpty()) {
            IAgent iAgent3 = (IAgent)((List)priorityQueue.remove()).get(0);
            if (iAgent3 == iAgent) {
                if (map != null) {
                    return this.finalPath(iScope, iShape, iShape2, iTopology, iAgent2, iAgent3, hashMap, map);
                }
                return this.finalPath(iScope, iShape, iShape2, iTopology, iAgent2, iAgent3, hashMap);
            }
            Set<IAgent> set = this.getNeighborhood().getNeighborsIn(iScope, iAgent3.getIndex(), 1);
            Double d2 = (Double)hashMap2.get(iAgent3);
            for (IAgent iAgent4 : set) {
                if (!blArray[iAgent4.getIndex()]) continue;
                double d3 = iAgent3.getLocation().euclidianDistanceTo(iAgent4.getLocation());
                double d4 = d2 + (map == null ? d3 : Cast.asFloat(iScope, map.get(iAgent4)) + (d3 > d ? Double.MIN_VALUE : 0.0));
                priorityQueue.add(new ArrayList(iAgent4, d4){
                    {
                        this.add(iAgent);
                        this.add(d);
                    }
                });
                blArray[iAgent4.getIndex()] = false;
                Double d5 = (Double)hashMap2.get(iAgent4);
                if (d5 != null && !(d4 < d5)) continue;
                hashMap2.put(iAgent4, d4);
                hashMap.put(iAgent4, iAgent3);
            }
        }
        return null;
    }

    public GamaSpatialPath computeShortestPathBetweenAStar(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IList<IAgent> iList, Map<IAgent, Object> map) throws GamaRuntimeException {
        boolean bl;
        int n = this.getPlaceIndexAt(iShape.getLocation());
        int n2 = this.getPlaceIndexAt(iShape2.getLocation());
        IAgent iAgent = this.matrix[n].getAgent();
        IAgent iAgent2 = this.matrix[n2].getAgent();
        boolean bl2 = bl = map != null;
        if (iAgent == iAgent2) {
            return this.simplePath(iScope, iShape, iShape2, iTopology, iAgent, iAgent2);
        }
        Double d = bl ? Math.max(this.cellHeight, this.cellWidth) : 0.0;
        boolean[] blArray = new boolean[this.getAgents().size()];
        this.initOpen(blArray, bl ? map.keySet() : iList);
        PriorityQueue priorityQueue = this.newPriorityQueue();
        HashMap<IAgent, IAgent> hashMap = new HashMap<IAgent, IAgent>();
        HashMap<IAgent, Double> hashMap2 = new HashMap<IAgent, Double>();
        priorityQueue.add(new ArrayList(iAgent, bl, iScope, map){
            {
                this.add(iAgent);
                this.add(bl ? Cast.asFloat(iScope, map.get(iAgent)) : 0.0);
            }
        });
        hashMap2.put(iAgent, 0.0);
        while (!priorityQueue.isEmpty()) {
            IAgent iAgent3 = (IAgent)((List)priorityQueue.remove()).get(0);
            if (iAgent3 == iAgent2) {
                if (bl) {
                    return this.finalPath(iScope, iShape, iShape2, iTopology, iAgent, iAgent3, hashMap, map);
                }
                return this.finalPath(iScope, iShape, iShape2, iTopology, iAgent, iAgent3, hashMap);
            }
            Double d2 = (Double)hashMap2.get(iAgent3);
            Set<IAgent> set = this.getNeighborhood().getNeighborsIn(iScope, iAgent3.getIndex(), 1);
            for (IAgent iAgent4 : set) {
                if (!blArray[iAgent4.getIndex()]) continue;
                double d3 = iAgent3.getLocation().euclidianDistanceTo(iAgent4.getLocation());
                double d4 = d2 + (!bl ? d3 : Cast.asFloat(iScope, map.get(iAgent4)) + (d3 > d ? Double.MIN_VALUE : 0.0));
                Double d5 = (Double)hashMap2.get(iAgent4);
                if (d5 != null && !(d4 < d5)) continue;
                hashMap2.put(iAgent4, d4);
                priorityQueue.add(new ArrayList(iAgent4, d4, iAgent2){
                    {
                        this.add(iAgent);
                        this.add(d + GamaSpatialMatrix.this.heuristic(iAgent, iAgent2));
                    }
                });
                hashMap.put(iAgent4, iAgent3);
            }
        }
        return null;
    }

    public GamaSpatialPath computeShortestPathBetweenJPS(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IList<IAgent> iList) throws GamaRuntimeException {
        IAgent iAgent;
        int n = this.getPlaceIndexAt(iShape.getLocation());
        int n2 = this.getPlaceIndexAt(iShape2.getLocation());
        IAgent iAgent2 = this.matrix[n].getAgent();
        if (iAgent2 == (iAgent = this.matrix[n2].getAgent())) {
            return this.simplePath(iScope, iShape, iShape2, iTopology, iAgent2, iAgent);
        }
        boolean[] blArray = new boolean[this.getAgents().size()];
        this.initOpen(blArray, iList);
        PriorityQueue priorityQueue = this.newPriorityQueue();
        HashMap<IAgent, IAgent> hashMap = new HashMap<IAgent, IAgent>();
        HashMap<IAgent, Double> hashMap2 = new HashMap<IAgent, Double>();
        priorityQueue.add(new ArrayList(iAgent2){
            {
                this.add(iAgent);
                this.add(0.0);
            }
        });
        hashMap2.put(iAgent2, 0.0);
        while (!priorityQueue.isEmpty()) {
            IAgent iAgent3 = (IAgent)((List)priorityQueue.remove()).get(0);
            if (iAgent3 == iAgent) {
                return this.finalPath(iScope, iShape, iShape2, iTopology, iAgent2, iAgent3, hashMap);
            }
            Double d = (Double)hashMap2.get(iAgent3);
            Set<IAgent> set = this.getNeighborsPrune(iScope, iAgent3, (IAgent)hashMap.get(iAgent3), blArray);
            for (IAgent iAgent4 : set) {
                if (!blArray[iAgent4.getIndex()]) continue;
                IAgent iAgent5 = this.jump(iScope, iAgent4, iAgent3, blArray, iAgent);
                IAgent iAgent6 = iAgent5 == null ? iAgent4 : iAgent5;
                double d2 = d + iAgent3.getLocation().euclidianDistanceTo(iAgent6.getLocation());
                Double d3 = (Double)hashMap2.get(iAgent6);
                if (d3 != null && !(d2 < d3)) continue;
                hashMap2.put(iAgent6, d2);
                priorityQueue.add(new ArrayList(iAgent6, d2, iAgent){
                    {
                        this.add(iAgent);
                        this.add(d + GamaSpatialMatrix.this.heuristic(iAgent, iAgent2));
                    }
                });
                hashMap.put(iAgent6, iAgent3);
            }
        }
        return null;
    }

    public boolean walkable(IScope iScope, int n, int n2, boolean[] blArray) {
        IAgent iAgent = (IAgent)this.get(iScope, n, n2);
        return iAgent != null && blArray[iAgent.getIndex()];
    }

    public boolean notwalkable(IScope iScope, int n, int n2, boolean[] blArray) {
        IAgent iAgent = (IAgent)this.get(iScope, n, n2);
        return iAgent == null || !blArray[iAgent.getIndex()];
    }

    public IAgent jump(IScope iScope, IAgent iAgent, IAgent iAgent2, boolean[] blArray, IAgent iAgent3) {
        if (iAgent == null || !blArray[iAgent.getIndex()]) {
            return null;
        }
        if (iAgent == iAgent3) {
            return iAgent;
        }
        int n = ((IGridAgent)iAgent).getX();
        int n2 = ((IGridAgent)iAgent).getY();
        blArray[iAgent.getIndex()] = true;
        int n3 = ((IGridAgent)iAgent2).getX();
        int n4 = ((IGridAgent)iAgent2).getY();
        int n5 = (n - n3) / Math.max(Math.abs(n - n3), 1);
        int n6 = (n2 - n4) / Math.max(Math.abs(n2 - n4), 1);
        IAgent iAgent4 = (IAgent)this.get(iScope, n + n5, n2 + n6);
        if (n5 != 0 && n6 != 0 ? this.walkable(iScope, n - n5, n2 + n6, blArray) && this.notwalkable(iScope, n - n5, n2, blArray) || this.walkable(iScope, n + n5, n2 - n6, blArray) && this.notwalkable(iScope, n, n2 - n6, blArray) : (n5 != 0 ? this.walkable(iScope, n + n5, n2 + 1, blArray) && this.notwalkable(iScope, n, n2 + 1, blArray) || this.walkable(iScope, n + n5, n2 - 1, blArray) && this.notwalkable(iScope, n, n2 - 1, blArray) : this.walkable(iScope, n + 1, n2 + n6, blArray) && this.notwalkable(iScope, n + 1, n2, blArray) || this.walkable(iScope, n - 1, n2 + n6, blArray) && this.notwalkable(iScope, n - 1, n2, blArray))) {
            return iAgent;
        }
        if (n5 != 0 && n6 != 0) {
            IAgent iAgent5 = this.jump(iScope, (IAgent)this.get(iScope, n + n5, n2), iAgent, blArray, iAgent3);
            IAgent iAgent6 = this.jump(iScope, (IAgent)this.get(iScope, n, n2 + n6), iAgent, blArray, iAgent3);
            if (iAgent5 != null || iAgent6 != null) {
                return iAgent;
            }
        }
        return this.jump(iScope, iAgent4, iAgent, blArray, iAgent3);
    }

    public Set<IAgent> getNeighborsPrune(IScope iScope, IAgent iAgent, IAgent iAgent2, boolean[] blArray) {
        if (iAgent2 == null) {
            return this.getNeighborhood().getNeighborsIn(iScope, iAgent.getIndex(), 1);
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            int n = ((IGridAgent)iAgent).getX();
            int n2 = ((IGridAgent)iAgent).getY();
            int n3 = ((IGridAgent)iAgent2).getX();
            int n4 = ((IGridAgent)iAgent2).getY();
            int n5 = (n - n3) / Math.max(Math.abs(n - n3), 1);
            int n6 = (n2 - n4) / Math.max(Math.abs(n2 - n4), 1);
            if (n5 != 0 && n6 != 0) {
                IAgent iAgent3;
                IAgent iAgent4;
                IAgent iAgent5;
                IAgent iAgent6;
                IAgent iAgent7;
                IAgent iAgent8 = (IAgent)this.get(iScope, n, n2 + n6);
                if (iAgent8 != null && blArray[iAgent8.getIndex()]) {
                    asOrderedSet.add(iAgent8);
                }
                if ((iAgent7 = (IAgent)this.get(iScope, n + n5, n2)) != null && blArray[iAgent7.getIndex()]) {
                    asOrderedSet.add(iAgent7);
                }
                if ((iAgent6 = (IAgent)this.get(iScope, n + n5, n2 + n6)) != null && blArray[iAgent6.getIndex()]) {
                    asOrderedSet.add(iAgent6);
                }
                if ((iAgent5 = (IAgent)this.get(iScope, n - n5, n2)) != null && !blArray[iAgent5.getIndex()] && (iAgent4 = (IAgent)this.get(iScope, n - n5, n2 + n6)) != null && blArray[iAgent4.getIndex()]) {
                    asOrderedSet.add(iAgent4);
                }
                if ((iAgent4 = (IAgent)this.get(iScope, n, n2 - n6)) != null && !blArray[iAgent4.getIndex()] && (iAgent3 = (IAgent)this.get(iScope, n + n5, n2 - n6)) != null && blArray[iAgent3.getIndex()]) {
                    asOrderedSet.add(iAgent3);
                }
            } else if (n6 == 0) {
                IAgent iAgent9;
                IAgent iAgent10;
                IAgent iAgent11;
                IAgent iAgent12 = (IAgent)this.get(iScope, n + n5, n2);
                if (iAgent12 != null && blArray[iAgent12.getIndex()]) {
                    asOrderedSet.add(iAgent12);
                }
                if ((iAgent11 = (IAgent)this.get(iScope, n, n2 + 1)) != null && !blArray[iAgent11.getIndex()] && (iAgent10 = (IAgent)this.get(iScope, n + n5, n2 + 1)) != null && blArray[iAgent10.getIndex()]) {
                    asOrderedSet.add(iAgent10);
                }
                if ((iAgent10 = (IAgent)this.get(iScope, n, n2 - 1)) != null && !blArray[iAgent10.getIndex()] && (iAgent9 = (IAgent)this.get(iScope, n + n5, n2 - 1)) != null && blArray[iAgent9.getIndex()]) {
                    asOrderedSet.add(iAgent9);
                }
            } else {
                IAgent iAgent13;
                IAgent iAgent14;
                IAgent iAgent15;
                IAgent iAgent16 = (IAgent)this.get(iScope, n, n2 + n6);
                if (iAgent16 != null && blArray[iAgent16.getIndex()]) {
                    asOrderedSet.add(iAgent16);
                }
                if ((iAgent15 = (IAgent)this.get(iScope, n + 1, n2)) != null && !blArray[iAgent15.getIndex()] && (iAgent14 = (IAgent)this.get(iScope, n + 1, n2 + n6)) != null && blArray[iAgent14.getIndex()]) {
                    asOrderedSet.add(iAgent14);
                }
                if ((iAgent14 = (IAgent)this.get(iScope, n - 1, n2)) != null && !blArray[iAgent14.getIndex()] && (iAgent13 = (IAgent)this.get(iScope, n - 1, n2 + n6)) != null && blArray[iAgent13.getIndex()]) {
                    asOrderedSet.add(iAgent13);
                }
            }
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public GamaSpatialPath computeShortestPathBetween(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IList<IAgent> iList) throws GamaRuntimeException {
        if ("Dijkstra".equals(this.optimizer)) {
            return this.computeShortestPathBetweenDijkstra(iScope, iShape, iShape2, iTopology, iList, null);
        }
        if (!this.neighborhood.isVN() && "JPS".equals(this.optimizer)) {
            return this.computeShortestPathBetweenJPS(iScope, iShape, iShape2, iTopology, iList);
        }
        if ("BF".equals(this.optimizer)) {
            return this.computeShortestPathBetweenBF(iScope, iShape, iShape2, iTopology, iList);
        }
        return this.computeShortestPathBetweenAStar(iScope, iShape, iShape2, iTopology, iList, null);
    }

    @Override
    public GamaSpatialPath computeShortestPathBetweenWeighted(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, Map<IAgent, Object> map) {
        if ("A*".equals(this.optimizer)) {
            return this.computeShortestPathBetweenAStar(iScope, iShape, iShape2, iTopology, null, map);
        }
        return this.computeShortestPathBetweenDijkstra(iScope, iShape, iShape2, iTopology, null, map);
    }

    private GamaSpatialPath simplePath(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IAgent iAgent, IAgent iAgent2) {
        IList iList = GamaListFactory.create(Types.GEOMETRY);
        iList.add(iShape.getLocation());
        iList.add(iShape2.getLocation());
        return PathFactory.newInstance(iScope, iTopology, iList, 0.0);
    }

    private GamaSpatialPath finalPath(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IAgent iAgent, IAgent iAgent2, Map<IAgent, IAgent> map, Map<IAgent, Object> map2) {
        IAgent iAgent3 = iAgent2;
        IList iList = GamaListFactory.create(Types.GEOMETRY);
        double d = Cast.asFloat(iScope, map2.get(iAgent3));
        iList.add(iShape2.getLocation());
        while (iAgent3 != iAgent) {
            iAgent3 = map.get(iAgent3);
            d += Cast.asFloat(iScope, map2.get(iAgent3)).doubleValue();
            if (iAgent3 == iAgent) continue;
            iList.add(iAgent3.getLocation());
        }
        iList.add(iShape.getLocation());
        Collections.reverse(iList);
        return PathFactory.newInstance(iScope, iTopology, iList, d);
    }

    private GamaSpatialPath finalPath(IScope iScope, IShape iShape, IShape iShape2, ITopology iTopology, IAgent iAgent, IAgent iAgent2, Map<IAgent, IAgent> map) {
        IAgent iAgent3 = iAgent2;
        IList iList = GamaListFactory.create(Types.GEOMETRY);
        double d = 1.0;
        iList.add(iShape2.getLocation());
        while (iAgent3 != iAgent) {
            iAgent3 = map.get(iAgent3);
            d += 1.0;
            if (iAgent3 == iAgent) continue;
            iList.add(iAgent3.getLocation());
        }
        iList.add(iShape.getLocation());
        Collections.reverse(iList);
        return PathFactory.newInstance(iScope, iTopology, iList, d);
    }

    private void initOpen(boolean[] blArray, Collection<IAgent> collection) {
        if (collection == null) {
            Arrays.fill(blArray, true);
        } else {
            Arrays.fill(blArray, false);
            for (IAgent iAgent : collection) {
                blArray[iAgent.getIndex()] = true;
            }
        }
    }

    private PriorityQueue newPriorityQueue() {
        Comparator comparator = (list, list2) -> ((Double)list.get(1)).compareTo((Double)list2.get(1));
        return new PriorityQueue(comparator);
    }

    @Override
    public final IAgent getAgentAt(GamaPoint gamaPoint) {
        IShape iShape = this.getPlaceAt(gamaPoint);
        if (iShape == null) {
            return null;
        }
        return iShape.getAgent();
    }

    public void setCellSpecies(IPopulation iPopulation) {
        this.cellSpecies = iPopulation.getSpecies();
    }

    @Override
    public ISpecies getCellSpecies() {
        return this.cellSpecies;
    }

    @Override
    public Boolean isHexagon() {
        return this.isHexagon;
    }

    @Override
    public Boolean isHorizontalOrientation() {
        return this.isHorizontalOrientation;
    }

    @Override
    public IList<IAgent> getAgents() {
        if (this.matrix == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        IList<IAgent> iList = GamaListFactory.create(Types.AGENT);
        IShape[] iShapeArray = this.matrix;
        int n = this.matrix.length;
        int n2 = 0;
        while (n2 < n) {
            IShape iShape = iShapeArray[n2];
            if (iShape != null) {
                iList.add(iShape.getAgent());
            }
            ++n2;
        }
        return iList;
    }

    public Object[] getMatrix() {
        return this.matrix;
    }

    @Override
    public void insert(IAgent iAgent) {
    }

    @Override
    public void remove(Envelope3D envelope3D, IAgent iAgent) {
    }

    public Set<IAgent> allAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
        double d2 = d * Maths.SQRT2;
        Envelope3D envelope3D = Envelope3D.of(iShape.getEnvelope());
        try {
            envelope3D.expandBy(d2);
            Collection collection = this.allInEnvelope(iScope, iShape, envelope3D, iAgentFilter, false);
            collection.removeIf(iAgent -> iShape.euclidianDistanceTo((IShape)iAgent) >= d);
            Collection collection2 = collection;
            return collection2;
        }
        finally {
            envelope3D.dispose();
        }
    }

    @Override
    public IAgent firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
        double d2 = d * Maths.SQRT2;
        Envelope3D envelope3D = Envelope3D.of(iShape.getEnvelope());
        try {
            envelope3D.expandBy(d2);
            Ordering ordering = Ordering.natural().onResultOf(iShape2 -> Double.valueOf(iShape.euclidianDistanceTo((IShape)iShape2)));
            Collection collection = this.allInEnvelope(iScope, iShape, envelope3D, iAgentFilter, false);
            if (collection.isEmpty()) {
                return null;
            }
            IAgent iAgent = (IAgent)ordering.min((Iterable)collection);
            return iAgent;
        }
        finally {
            envelope3D.dispose();
        }
    }

    @Override
    public Collection<IAgent> firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter, int n, Collection<IAgent> collection) {
        double d2 = d * Maths.SQRT2;
        Envelope3D envelope3D = Envelope3D.of(iShape.getEnvelope());
        try {
            envelope3D.expandBy(d2);
            Collection collection2 = this.allInEnvelope(iScope, iShape, envelope3D, iAgentFilter, false);
            collection2.removeAll(collection);
            if (collection2.size() <= n) {
                Collection collection3 = collection2;
                return collection3;
            }
            boolean bl = iAgentFilter.getSpecies() != null && iAgentFilter.getSpecies().isGrid();
            Ordering ordering = bl ? Ordering.natural().onResultOf(iShape2 -> Double.valueOf(iShape.euclidianDistanceTo(iShape2.getLocation()))) : Ordering.natural().onResultOf(iShape2 -> Double.valueOf(iShape.euclidianDistanceTo((IShape)iShape2)));
            List list = ordering.leastOf((Iterable)collection2, n);
            return list;
        }
        finally {
            envelope3D.dispose();
        }
    }

    private Set<IAgent> inEnvelope(Envelope envelope) {
        LinkedHashSet<IAgent> linkedHashSet = new LinkedHashSet<IAgent>();
        int n = 0;
        int n2 = 0;
        int n3 = this.numCols - 1;
        int n4 = this.numRows - 1;
        if (this.isHexagon.booleanValue()) {
            if (this.isHorizontalOrientation.booleanValue()) {
                n = Math.max(0, (int)(Math.max(0.0, envelope.getMinX() - this.cellWidth / 2.0) / (this.cellWidth / 0.75)));
                n2 = Math.max(0, (int)(Math.max(0.0, envelope.getMinY() - this.cellHeight / 2.0) / this.cellHeight));
                n3 = Math.min(this.numCols - 1, (int)(envelope.getMaxX() / (this.cellWidth * 0.75)));
                n4 = Math.min(this.numRows - 1, (int)(envelope.getMaxY() / this.cellHeight));
            } else {
                n = Math.max(0, (int)(Math.max(0.0, envelope.getMinX() - this.cellWidth / 2.0) / this.cellWidth));
                n2 = Math.max(0, (int)(Math.max(0.0, envelope.getMinY() - this.cellHeight / 2.0) / (this.cellHeight / 0.75)));
                n3 = Math.min(this.numCols - 1, (int)(envelope.getMaxX() / this.cellWidth));
                n4 = Math.min(this.numRows - 1, (int)(envelope.getMaxY() / (this.cellHeight * 0.75)));
            }
        } else {
            n = Math.max(0, (int)(envelope.getMinX() / this.cellWidth));
            n2 = Math.max(0, (int)(envelope.getMinY() / this.cellHeight));
            n3 = Math.min(this.numCols - 1, (int)(envelope.getMaxX() / this.cellWidth));
            n4 = Math.min(this.numRows - 1, (int)(envelope.getMaxY() / this.cellHeight));
        }
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                IAgent iAgent;
                int n7 = this.getPlaceIndexAt(n5, n6);
                if (n7 != -1 && (iAgent = this.matrix[n7].getAgent()) != null) {
                    linkedHashSet.add(iAgent);
                }
                ++n6;
            }
            ++n5;
        }
        return linkedHashSet;
    }

    public Set<IAgent> allInEnvelope(IScope iScope, IShape iShape, Envelope envelope, IAgentFilter iAgentFilter, boolean bl) {
        Set<IAgent> set = this.inEnvelope(envelope);
        set.remove(iShape);
        set.removeIf(iAgent -> {
            Envelope3D envelope3D = iAgent.getEnvelope();
            return iAgent.getAgent() == null || !(bl ? envelope.covers((Envelope)envelope3D) : envelope.intersects((Envelope)envelope3D));
        });
        if (iAgentFilter != null) {
            iAgentFilter.filter(iScope, iShape, set);
        }
        return set;
    }

    @Override
    public boolean isTorus() {
        return this.isTorus;
    }

    @Override
    public IShape getEnvironmentFrame() {
        return this.environmentFrame;
    }

    @Override
    public boolean usesNeighborsCache() {
        return this.useNeighborsCache;
    }

    @Override
    public IShape getNthElement(Integer n) {
        if (n == null || n > this.lastCell) {
            return null;
        }
        return this.matrix[n];
    }

    @Override
    protected void setNthElement(IScope iScope, int n, Object object) {
    }

    @Override
    public StreamEx<IShape> stream(IScope iScope) {
        return StreamEx.of((Object[])this.matrix);
    }

    @Override
    public String optimizer() {
        return this.optimizer;
    }

    @Override
    public double[] getBand(IScope iScope, int n) {
        if (n == 0) {
            return this.getFieldData(iScope);
        }
        double[] dArray = new double[this.bands.size()];
        int n2 = 0;
        for (List list : this.bands) {
            dArray[n2++] = (Double)list.get(n);
        }
        return dArray;
    }

    @Override
    public double[] getFieldData(IScope iScope) {
        return this.gridValue;
    }

    @Override
    public int getNbNeighbours() {
        return this.getNeighborhood().isVN() ? 4 : 8;
    }

    @Override
    public double getValueAtIndex(IScope iScope, int n, String string) {
        IAgent iAgent = this.matrix[n].getAgent();
        return Cast.asFloat(iScope, iAgent.getDirectVarValue(iScope, string));
    }

    @Override
    public void setValueAtIndex(IScope iScope, int n, String string, double d) {
        IAgent iAgent = this.matrix[n].getAgent();
        iAgent.setDirectVarValue(iScope, string, d);
    }

    @Override
    public void getValuesInto(IScope iScope, String string, double d, double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            double d2 = Cast.asFloat(iScope, this.getValueAtIndex(iScope, n, string));
            dArray[n] = d2 < d ? 0.0 : d2;
            ++n;
        }
    }

    @Override
    public void setGridValues(double[] dArray) {
        this.gridValue = dArray;
    }

    private class CellProxyGeometry
    extends GamaProxyGeometry {
        public CellProxyGeometry(GamaPoint gamaPoint) {
            super(gamaPoint);
        }

        @Override
        public void setGeometricalType(IShape.Type type2) {
        }

        @Override
        protected IShape getReferenceGeometry() {
            return GamaSpatialMatrix.this.referenceShape;
        }

        @Override
        public IAgent getAgent() {
            IShape iShape = GamaSpatialMatrix.this.getPlaceAt(this.getLocation());
            if (iShape == this) {
                return null;
            }
            return iShape.getAgent();
        }

        @Override
        public void setDepth(double d) {
        }

        @Override
        public IList<? extends IShape> getGeometries() {
            IList iList = GamaListFactory.create(Types.GEOMETRY);
            if (this.isMultiple()) {
                Geometry geometry = this.getInnerGeometry();
                int n = 0;
                int n2 = geometry.getNumGeometries();
                while (n < n2) {
                    iList.add(GamaShapeFactory.createFrom(geometry.getGeometryN(n)));
                    ++n;
                }
            } else {
                iList.add(this);
            }
            return iList;
        }

        @Override
        public boolean isMultiple() {
            return this.getReferenceGeometry().isMultiple();
        }
    }
}

