/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.PlatformHelper;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;

@GamlAnnotations.facets(omissible="value", value={@GamlAnnotations.facet(name="value", type={0}, optional=true, doc={@GamlAnnotations.doc(value="Either #none, to indicate that no layout will be imposed, or one of the four possible predefined layouts: #stack, #split, #horizontal or #vertical. This layout will be applied to both experiment and simulation display views. In addition, it is possible to define a custom layout using the horizontal() and vertical() operators")}), @GamlAnnotations.facet(name="editors", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the editors should initially be visible or not")}), @GamlAnnotations.facet(name="toolbars", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the displays should show their toolbar or not")}), @GamlAnnotations.facet(name="controls", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the experiment should show its control toolbar on top or not")}), @GamlAnnotations.facet(name="parameters", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the parameters view is visible or not (true by default)")}), @GamlAnnotations.facet(name="navigator", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the navigator view is visible or not (false by default)")}), @GamlAnnotations.facet(name="consoles", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the consoles are visible or not (true by default)")}), @GamlAnnotations.facet(name="tray", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the bottom tray is visible or not (true by default)")}), @GamlAnnotations.facet(name="background", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Whether the whole interface of GAMA should be colored or not (nil by default)")}), @GamlAnnotations.facet(name="tabs", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the displays should show their tab or not")})})
@GamlAnnotations.inside(symbols={"output"})
@GamlAnnotations.doc(value="Represents the layout of the display views of simulations and experiments", usages={@GamlAnnotations.usage(value="For instance, this layout statement will allow to split the screen occupied by displays in four equal parts, with no tabs. Pairs of display::weight represent the number of the display in their order of definition and their respective weight within a horizontal and vertical section", examples={@GamlAnnotations.example(value="layout horizontal([vertical([0::5000,1::5000])::5000,vertical([2::5000,3::5000])::5000]) tabs: false;", isExecutable=false)})})
@validator(value=LayoutValidator.class)
public class LayoutStatement
extends Symbol {
    public LayoutStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    public static class LayoutValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
            boolean bl;
            if (!PlatformHelper.isWindows()) {
                return;
            }
            IExpression iExpression = iDescription.getFacetExpr("tabs");
            boolean bl2 = iExpression == null ? true : (bl = iExpression.isConst() ? Cast.asBool(null, iExpression.getConstValue()) : false);
            if (bl) {
                return;
            }
            IDescription iDescription2 = iDescription.getEnclosingDescription();
            IDescription iDescription3 = iDescription2.getEnclosingDescription().getChildWithKeyword("permanent");
            Iterable iterable = iDescription2.getChildrenWithKeyword("display");
            if (iDescription3 != null) {
                iterable = Iterables.concat(iterable, iDescription3.getChildrenWithKeyword("display"));
            }
            boolean bl3 = "2d".equals(GamaPreferences.Displays.CORE_DISPLAY.getValue());
            for (IDescription iDescription4 : iterable) {
                String string = iDescription4.getLitteral("type");
                if (!"2d".equals(string) && (!bl3 || string != null)) continue;
                iDescription.warning("A bug in GAMA 1.9 on Windows means that removing display tabs can prevent 2D displays from being shown. Please make sure you only use 3D (aka opengl) displays.", "gaml.conflicting.facets", "tabs", new String[0]);
                return;
            }
        }
    }
}

