/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.benchmark;

import gama.core.common.interfaces.IBenchmarkable;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.BenchmarkCSVExporter;
import gama.core.runtime.benchmark.BenchmarkConsolePrinter;
import gama.core.runtime.benchmark.BenchmarkRecord;
import gama.core.runtime.benchmark.BenchmarkTree;
import gama.core.runtime.benchmark.StopWatch;
import java.util.concurrent.ConcurrentHashMap;

public class Benchmark
extends ConcurrentHashMap<IScope, ScopeRecord> {
    public final BenchmarkTree tree;

    public Benchmark(IExperimentPlan iExperimentPlan) {
        this.tree = new BenchmarkTree(iExperimentPlan.getModel().getDescription(), iExperimentPlan.getDescription());
    }

    public StopWatch record(IScope iScope, IBenchmarkable iBenchmarkable) {
        return this.computeIfAbsent(iScope, ScopeRecord::new).getStopWatchFor(iBenchmarkable).start();
    }

    public void saveAndDispose(IExperimentPlan iExperimentPlan) {
        new BenchmarkConsolePrinter().print(this);
        new BenchmarkCSVExporter().save(iExperimentPlan, this);
        this.tree.dispose();
        this.clear();
    }

    public static class ScopeRecord
    extends ConcurrentHashMap<IBenchmarkable, BenchmarkRecord> {
        final BenchmarkRecord ownRecord;

        public ScopeRecord(IScope iScope) {
            this.ownRecord = new BenchmarkRecord(iScope);
        }

        public BenchmarkRecord find(IBenchmarkable iBenchmarkable) {
            return this.computeIfAbsent(iBenchmarkable, BenchmarkRecord::new);
        }

        public StopWatch getStopWatchFor(IBenchmarkable iBenchmarkable) {
            return new StopWatch(this.ownRecord, this.find(iBenchmarkable));
        }
    }
}

