/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.concurrent;

import gama.core.metamodel.agent.AbstractAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.statements.save.SaveOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;

public class BufferingController {
    public static final String PER_CYCLE_BUFFERING = "per_cycle";
    public static final String PER_SIMULATION_BUFFERING = "per_simulation";
    public static final String PER_AGENT = "per_agent";
    public static final String NO_BUFFERING = "no_buffering";
    public static final Set<String> BUFFERING_STRATEGIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("per_cycle", "per_simulation", "no_buffering", "per_agent")));
    protected Map<String, Map<AbstractAgent, TextBuffer>> fileBufferPerAgent = new HashMap<String, Map<AbstractAgent, TextBuffer>>();
    protected Map<String, Map<AbstractAgent, TextBuffer>> fileBufferPerAgentForCycles = new HashMap<String, Map<AbstractAgent, TextBuffer>>();
    protected Map<AbstractAgent, List<TextBuffer>> consoleBufferListPerAgent = new HashMap<AbstractAgent, List<TextBuffer>>();
    protected Map<AbstractAgent, List<TextBuffer>> consoleBufferListPerAgentForCycles = new HashMap<AbstractAgent, List<TextBuffer>>();

    public static BufferingStrategies stringToBufferingStrategies(IScope iScope, String string) {
        switch (string) {
            case "per_cycle": {
                return BufferingStrategies.PER_CYCLE_BUFFERING;
            }
            case "per_simulation": {
                return BufferingStrategies.PER_SIMULATION_BUFFERING;
            }
            case "no_buffering": {
                return BufferingStrategies.NO_BUFFERING;
            }
            case "per_agent": {
                return BufferingStrategies.PER_AGENT;
            }
        }
        throw GamaRuntimeException.create((Throwable)new NotImplementedException("This buffering strategie has not been implemented yet: " + string), iScope);
    }

    public synchronized boolean askWriteFile(String string, IScope iScope, CharSequence charSequence, SaveOptions saveOptions) {
        AbstractAgent abstractAgent = iScope.getSimulation();
        switch (saveOptions.bufferingStrategy) {
            case PER_SIMULATION_BUFFERING: 
            case PER_AGENT: {
                if (saveOptions.bufferingStrategy == BufferingStrategies.PER_AGENT) {
                    abstractAgent = (AbstractAgent)iScope.getAgent();
                }
                return BufferingController.appendSaveFileRequestToMap(abstractAgent, this.getOrInitBufferingMap(string, this.fileBufferPerAgent), charSequence, saveOptions);
            }
            case PER_CYCLE_BUFFERING: {
                return BufferingController.appendSaveFileRequestToMap(abstractAgent, this.getOrInitBufferingMap(string, this.fileBufferPerAgentForCycles), charSequence, saveOptions);
            }
            case NO_BUFFERING: {
                return BufferingController.directWriteFile(string, charSequence, saveOptions.getCharset(), !saveOptions.rewrite);
            }
        }
        IScope iScope2 = ((AbstractAgent)abstractAgent).getScope();
        throw GamaRuntimeException.create((Throwable)new NotImplementedException("This buffering strategie has not been implemented yet: " + saveOptions.bufferingStrategy.toString()), iScope2);
    }

    public synchronized boolean askWriteConsole(IScope iScope, StringBuilder stringBuilder, GamaColor gamaColor, BufferingStrategies bufferingStrategies) {
        AbstractAgent abstractAgent = iScope.getSimulation();
        switch (bufferingStrategies) {
            case PER_SIMULATION_BUFFERING: 
            case PER_AGENT: {
                if (bufferingStrategies == BufferingStrategies.PER_AGENT) {
                    abstractAgent = (AbstractAgent)iScope.getAgent();
                }
                return BufferingController.appendWriteConsoleRequestToMap(abstractAgent, this.consoleBufferListPerAgent, stringBuilder, gamaColor);
            }
            case PER_CYCLE_BUFFERING: {
                return BufferingController.appendWriteConsoleRequestToMap(abstractAgent, this.consoleBufferListPerAgentForCycles, stringBuilder, gamaColor);
            }
            case NO_BUFFERING: {
                iScope.getGui().getConsole().informConsole(stringBuilder.toString(), iScope.getRoot(), gamaColor);
                return true;
            }
        }
        IScope iScope2 = ((AbstractAgent)abstractAgent).getScope();
        throw GamaRuntimeException.create((Throwable)new NotImplementedException("This buffering strategie has not been implemented yet: " + bufferingStrategies.toString()), iScope2);
    }

    protected synchronized Map<AbstractAgent, TextBuffer> getOrInitBufferingMap(String string, Map<String, Map<AbstractAgent, TextBuffer>> map) {
        Map<AbstractAgent, TextBuffer> map2 = map.get(string);
        if (map2 == null) {
            map2 = new HashMap<AbstractAgent, TextBuffer>();
            map.put(string, map2);
        }
        return map2;
    }

    protected static boolean appendSaveFileRequestToMap(AbstractAgent abstractAgent, Map<AbstractAgent, TextBuffer> map, CharSequence charSequence, SaveOptions saveOptions) {
        TextBuffer textBuffer = map.get(abstractAgent);
        if (textBuffer == null) {
            try {
                map.put(abstractAgent, new TextBuffer(charSequence, saveOptions.getCharset(), saveOptions.rewrite));
                return true;
            }
            catch (Exception exception) {
                GAMA.reportError(abstractAgent.getScope(), GamaRuntimeException.create(exception, abstractAgent.getScope()), false);
                return false;
            }
        }
        if (saveOptions.rewrite) {
            textBuffer.setRewrite(true);
            textBuffer.content.setLength(0);
        }
        textBuffer.content.append(charSequence);
        return true;
    }

    protected static boolean appendWriteConsoleRequestToMap(AbstractAgent abstractAgent, Map<AbstractAgent, List<TextBuffer>> map, StringBuilder stringBuilder, GamaColor gamaColor) {
        List<TextBuffer> list = map.get(abstractAgent);
        if (list == null) {
            list = new ArrayList<TextBuffer>();
            map.put(abstractAgent, list);
        }
        if (list.size() == 0 || list.get((int)(list.size() - 1)).color != null && !list.get((int)(list.size() - 1)).color.equals(gamaColor)) {
            try {
                list.add(new TextBuffer(stringBuilder, gamaColor));
                return true;
            }
            catch (Exception exception) {
                GAMA.reportError(abstractAgent.getScope(), GamaRuntimeException.create(exception, abstractAgent.getScope()), false);
                return false;
            }
        }
        list.get((int)(list.size() - 1)).content.append((CharSequence)stringBuilder);
        return true;
    }

    protected static boolean directWriteFile(String string, CharSequence charSequence, Charset charset, boolean bl) {
        try {
            FileUtils.write((File)new File(string), (CharSequence)charSequence, (Charset)charset, (boolean)bl);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected static boolean flushAllFilesOfAgent(AbstractAgent abstractAgent, Map<String, Map<AbstractAgent, TextBuffer>> map) {
        boolean bl = true;
        for (Map.Entry<String, Map<AbstractAgent, TextBuffer>> entry : map.entrySet()) {
            TextBuffer textBuffer = entry.getValue().get(abstractAgent);
            if (textBuffer == null) continue;
            boolean bl2 = BufferingController.directWriteFile(entry.getKey(), textBuffer.content, textBuffer.encoding, !textBuffer.rewrite);
            bl &= bl2;
            if (!bl2) continue;
            entry.getValue().remove(abstractAgent);
        }
        return bl;
    }

    protected static void flushAllWriteOfAgent(AbstractAgent abstractAgent, Map<AbstractAgent, List<TextBuffer>> map) {
        List<TextBuffer> list = map.get(abstractAgent);
        if (list != null) {
            IScope iScope = abstractAgent.getScope();
            for (TextBuffer textBuffer : list) {
                iScope.getGui().getConsole().informConsole(textBuffer.content.toString(), iScope.getRoot(), textBuffer.color);
            }
            list.clear();
        }
    }

    public synchronized boolean flushSaveFilesOfAgent(AbstractAgent abstractAgent) {
        return BufferingController.flushAllFilesOfAgent(abstractAgent, this.fileBufferPerAgent);
    }

    public synchronized boolean flushSaveFilesInCycle(AbstractAgent abstractAgent) {
        return BufferingController.flushAllFilesOfAgent(abstractAgent, this.fileBufferPerAgentForCycles);
    }

    public synchronized void flushWriteInCycle(AbstractAgent abstractAgent) {
        BufferingController.flushAllWriteOfAgent(abstractAgent, this.consoleBufferListPerAgentForCycles);
    }

    public synchronized void flushWriteOfAgent(AbstractAgent abstractAgent) {
        BufferingController.flushAllWriteOfAgent(abstractAgent, this.consoleBufferListPerAgent);
    }

    public synchronized void flushAllBuffers() {
        AbstractAgent[] abstractAgentArray;
        Object object;
        AbstractAgent[] abstractAgentArray2;
        for (AbstractAgent abstractAgentArray22 : this.consoleBufferListPerAgentForCycles.keySet()) {
            this.flushWriteInCycle(abstractAgentArray22);
        }
        for (AbstractAgent abstractAgent : this.consoleBufferListPerAgent.keySet()) {
            this.flushWriteOfAgent(abstractAgent);
        }
        AbstractAgent[] abstractAgentArray3 = abstractAgentArray2 = (AbstractAgent[])this.fileBufferPerAgentForCycles.entrySet().stream().map(entry -> ((Map)entry.getValue()).keySet()).flatMap(Collection::stream).toArray(AbstractAgent[]::new);
        int n = abstractAgentArray2.length;
        int n2 = 0;
        while (n2 < n) {
            object = abstractAgentArray3[n2];
            this.flushSaveFilesInCycle((AbstractAgent)object);
            ++n2;
        }
        abstractAgentArray3 = abstractAgentArray = (AbstractAgent[])this.fileBufferPerAgent.entrySet().stream().map(entry -> ((Map)entry.getValue()).keySet()).flatMap(Collection::stream).toArray(AbstractAgent[]::new);
        n = abstractAgentArray.length;
        n2 = 0;
        while (n2 < n) {
            object = abstractAgentArray3[n2];
            this.flushSaveFilesOfAgent((AbstractAgent)object);
            ++n2;
        }
    }

    public synchronized boolean isFileWaitingToBeWritten(File file2) {
        if (this.fileBufferPerAgent.keySet().parallelStream().anyMatch(string -> string.equals(file2.getAbsolutePath()))) {
            return true;
        }
        return this.fileBufferPerAgentForCycles.keySet().parallelStream().anyMatch(string -> string.equals(file2.getAbsolutePath()));
    }

    public static enum BufferingStrategies {
        NO_BUFFERING,
        PER_CYCLE_BUFFERING,
        PER_SIMULATION_BUFFERING,
        PER_AGENT;

    }

    public static class TextBuffer {
        public final StringBuilder content;
        public final Charset encoding;
        public final GamaColor color;
        protected boolean rewrite;

        public TextBuffer(CharSequence charSequence, Charset charset, boolean bl) {
            this.content = new StringBuilder(charSequence);
            this.encoding = charset;
            this.rewrite = bl;
            this.color = null;
        }

        public TextBuffer(CharSequence charSequence, GamaColor gamaColor) {
            this.content = new StringBuilder(charSequence);
            this.color = gamaColor;
            this.encoding = null;
            this.rewrite = false;
        }

        public void setRewrite(boolean bl) {
            this.rewrite = bl;
        }

        public boolean isRewriting() {
            return this.rewrite;
        }
    }
}

