/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph.writer;

import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.nio.GraphExporter;
import org.jgrapht.nio.dimacs.DIMACSExporter;
import org.jgrapht.nio.dot.DOTExporter;
import org.jgrapht.nio.gexf.GEXFExporter;
import org.jgrapht.nio.gml.GmlExporter;
import org.jgrapht.nio.graph6.Graph6Sparse6Exporter;
import org.jgrapht.nio.graphml.GraphMLExporter;

public class GraphExporters {
    private static final Map<String, Class<? extends GraphExporter>> name2writer = new HashMap<String, Class<? extends GraphExporter>>(){
        {
            this.put("dimacs", DIMACSExporter.class);
            this.put("dot", DOTExporter.class);
            this.put("gexf", GEXFExporter.class);
            this.put("graphml", GraphMLExporter.class);
            this.put("graph6", Graph6Sparse6Exporter.class);
            this.put("gml", GmlExporter.class);
        }
    };
    private static Map<String, GraphExporter> name2singleton = new HashMap<String, GraphExporter>();

    public static Set<String> getAvailableWriters() {
        return name2writer.keySet();
    }

    public static GraphExporter getGraphWriter(String string) {
        GraphExporter graphExporter = name2singleton.get(string);
        if (graphExporter == null) {
            Class<? extends GraphExporter> clazz = name2writer.get(string);
            if (clazz == null) {
                throw GamaRuntimeException.error("unknown exporter name: " + string + "; please choose one of " + GraphExporters.getAvailableWriters().toString(), GAMA.getRuntimeScope());
            }
            try {
                Constructor<? extends GraphExporter> constructor = clazz.getConstructor(new Class[0]);
                graphExporter = constructor.newInstance(new Object[0]);
                name2singleton.put(string, graphExporter);
                return graphExporter;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw GamaRuntimeException.create(noSuchMethodException, GAMA.getRuntimeScope());
            }
            catch (SecurityException securityException) {
                throw GamaRuntimeException.create(securityException, GAMA.getRuntimeScope());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw GamaRuntimeException.create(illegalArgumentException, GAMA.getRuntimeScope());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw GamaRuntimeException.create(invocationTargetException, GAMA.getRuntimeScope());
            }
            catch (InstantiationException instantiationException) {
                throw GamaRuntimeException.create(instantiationException, GAMA.getRuntimeScope());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw GamaRuntimeException.create(illegalAccessException, GAMA.getRuntimeScope());
            }
        }
        return graphExporter;
    }
}

