/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.user;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.THREADS;
import gama.gaml.architecture.finite_state_machine.FsmStateStatement;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.UserCommandStatement;
import java.util.ArrayList;
import java.util.List;

@GamlAnnotations.inside(symbols={"fsm", "user_first", "user_last", "user_init", "user_only"}, kinds={0, 13, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="initial", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether or not this panel will be the initial one")}), @GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="The name of the panel")})}, omissible="name")
@GamlAnnotations.doc(value="It is the basic behavior of the user control architecture (it is similar to state for the FSM architecture). This user_panel translates, in the interface, in a semi-modal view that awaits the user to choose action buttons, change attributes of the controlled agent, etc. Each user_panel, like a state in FSM, can have a enter and exit sections, but it is only defined in terms of a set of user_commands which describe the different action buttons present in the panel.", usages={@GamlAnnotations.usage(value="The general syntax is for example:", examples={@GamlAnnotations.example(value="user_panel default initial: true {", isExecutable=false), @GamlAnnotations.example(value="\tuser_input 'Number' returns: number type: int <- 10;", isExecutable=false), @GamlAnnotations.example(value="\task (number among list(cells)){ do die; }", isExecutable=false), @GamlAnnotations.example(value="\ttransition to: \"Advanced Control\" when: every (10);", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="user_panel \"Advanced Control\" {", isExecutable=false), @GamlAnnotations.example(value="\tuser_input \"Location\" returns: loc type: point <- {0,0};", isExecutable=false), @GamlAnnotations.example(value="\tcreate cells number: 10 with: [location::loc];", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"user_command", "user_init", "user_input"})
public class UserPanelStatement
extends FsmStateStatement {
    List<IStatement> userCommands = new ArrayList<IStatement>();

    public UserPanelStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        for (ISymbol iSymbol2 : iterable) {
            if (!(iSymbol2 instanceof UserCommandStatement)) continue;
            UserCommandStatement userCommandStatement = (UserCommandStatement)iSymbol2;
            this.userCommands.add(userCommandStatement);
        }
        super.setChildren(Iterables.filter(iterable, iSymbol -> !this.userCommands.contains(iSymbol)));
    }

    public List<IStatement> getUserCommands() {
        return this.userCommands;
    }

    @Override
    protected Object bodyExecution(IScope iScope) throws GamaRuntimeException {
        super.bodyExecution(iScope);
        if (!this.userCommands.isEmpty()) {
            iScope.getGui().openUserControlPanel(iScope, this);
            while (iScope.isOnUserHold()) {
                THREADS.WAIT((long)100L, (String[])new String[0]);
            }
        }
        return this.name;
    }
}

