/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaFolderFile;
import gama.core.util.file.IGamaFile;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class Files {
    public static IGamaFile from(IScope iScope, String string, IContainer iContainer) {
        IType<?> iType = iContainer == null ? Types.NO_TYPE : iContainer.getGamlType().getKeyType();
        IType<?> iType2 = iContainer == null ? Types.NO_TYPE : iContainer.getGamlType().getContentType();
        return (IGamaFile)Types.FILE.cast(iScope, (Object)string, (Object)iContainer, (IType)iType, (IType)iType2, false);
    }

    public static IGamaFile from(IScope iScope, String string) throws GamaRuntimeException {
        return Files.from(iScope, string, null);
    }

    @GamlAnnotations.operator(value={"file_exists"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="Test whether the parameter is the path to an existing file. False if it does not exist of if it is a folder", examples={@GamlAnnotations.example(value="string file_name <-\"../includes/buildings.shp\";", isExecutable=false), @GamlAnnotations.example(value="if file_exists(file_name){", isExecutable=false), @GamlAnnotations.example(value="\twrite \"File exists in the computer\";", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})
    public static boolean exist_file(IScope iScope, String string) {
        if (string == null || iScope == null) {
            return false;
        }
        String string2 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        File file2 = new File(string2);
        return file2.exists() && !file2.isDirectory();
    }

    @GamlAnnotations.operator(value={"to_absolute_path"}, can_be_const=true, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="Transforms a relative path into an absolute path. If the path is already absolute doesn't transform it.")
    public static String toAbsoluteFile(IScope iScope, String string) {
        return FileUtils.constructAbsoluteFilePath(iScope, string, false);
    }

    public static void extractFolder(IScope iScope, String string, String string2) {
        try {
            int n = 2048;
            File file2 = new File(string);
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipFile zipFile = new ZipFile(file2);){
                String string3 = string2;
                new File(string3).mkdir();
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string4 = zipEntry.getName();
                    File file3 = new File(string3, string4);
                    File file4 = file3.getParentFile();
                    file4.mkdirs();
                    if (zipEntry.isDirectory()) continue;
                    Throwable throwable2 = null;
                    Object var15_19 = null;
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
                        byte[] byArray = new byte[n];
                        Throwable throwable3 = null;
                        Object var20_26 = null;
                        try (OutputStream outputStream = java.nio.file.Files.newOutputStream(file3.toPath(), new OpenOption[0]);){
                            Throwable throwable4 = null;
                            Object var23_31 = null;
                            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, n);){
                                int n2;
                                while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                                    bufferedOutputStream.write(byArray, 0, n2);
                                }
                                bufferedOutputStream.flush();
                            }
                            catch (Throwable throwable5) {
                                if (throwable4 == null) {
                                    throwable4 = throwable5;
                                } else if (throwable4 != throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable3 == null) {
                                throwable3 = throwable6;
                            } else if (throwable3 != throwable6) {
                                throwable3.addSuppressed(throwable6);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("ERROR: " + exception.getMessage(), iScope);
        }
    }

    private static void addFolderToZip(File file2, ZipOutputStream zipOutputStream, String string) throws IOException {
        File[] fileArray;
        if (file2.isDirectory()) {
            fileArray = file2.listFiles();
            if (fileArray == null) {
                return;
            }
        } else {
            fileArray = new File[]{file2};
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file3 = fileArray2[n2];
            if (file3.isDirectory()) {
                Files.addFolderToZip(file3, zipOutputStream, string);
            } else {
                String string2 = file3.getAbsolutePath().substring(string.length());
                ZipEntry zipEntry = new ZipEntry(string2);
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)java.nio.file.Files.newInputStream(file3.toPath(), new OpenOption[0]), (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
            ++n2;
        }
    }

    @GamlAnnotations.operator(value={"delete_file"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="delete a file or a folder", examples={@GamlAnnotations.example(value="bool delete_file_ok <- delete_file([\"../includes/my_folder\"];", isExecutable=false)})
    public static boolean delete(IScope iScope, String string) {
        if (string == null || iScope == null) {
            return false;
        }
        String string2 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        File file2 = new File(string2);
        if (!file2.isDirectory()) {
            return file2.delete();
        }
        Files.deleteDir(file2);
        return !Files.exist_folder(iScope, string);
    }

    @GamlAnnotations.operator(value={"rename_file"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="rename/move a file or a folder", examples={@GamlAnnotations.example(value="bool rename_file_ok <- rename_file(\"../includes/my_folder\",\"../includes/my_new_folder\");", isExecutable=false)})
    public static boolean rename(IScope iScope, String string, String string2) {
        if (string == null || iScope == null || string2 == null) {
            return false;
        }
        String string3 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        String string4 = FileUtils.constructAbsoluteFilePath(iScope, string2, false);
        File file2 = new File(string3);
        File file3 = new File(string4);
        return file2.renameTo(file3);
    }

    @GamlAnnotations.operator(value={"copy_file"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="copy a file or a folder", examples={@GamlAnnotations.example(value="bool copy_file_ok <- copy_file(\"../includes/my_folder\",\"../includes/my_new_folder\",true);", isExecutable=false)})
    public static boolean copy(IScope iScope, String string, String string2, boolean bl) {
        if (string == null || iScope == null || string2 == null) {
            return false;
        }
        String string3 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        String string4 = FileUtils.constructAbsoluteFilePath(iScope, string2, false);
        File file2 = new File(string3);
        if (!file2.isDirectory()) {
            Path path2 = null;
            try {
                path2 = bl ? java.nio.file.Files.copy(Paths.get(string3, new String[0]), Paths.get(string4, new String[0]), StandardCopyOption.REPLACE_EXISTING) : java.nio.file.Files.copy(Paths.get(string3, new String[0]), Paths.get(string4, new String[0]), new CopyOption[0]);
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.error("Error when copying the file " + iOException.getMessage(), iScope);
            }
            return path2 != null && path2.toFile().exists();
        }
        try {
            Throwable throwable = null;
            Object var8_12 = null;
            try (Stream<Path> stream = java.nio.file.Files.walk(Paths.get(string3, new String[0]), new FileVisitOption[0]);){
                stream.forEach(path -> {
                    Path path2 = Paths.get(string4, path.toString().substring(string3.length()));
                    try {
                        if (bl) {
                            java.nio.file.Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
                        } else {
                            java.nio.file.Files.copy(path, path2, new CopyOption[0]);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error("Error when copying the folder " + iOException.getMessage(), iScope);
        }
        return !Files.exist_folder(iScope, string2);
    }

    @GamlAnnotations.operator(value={"copy_file"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="copy a file or a folder", examples={@GamlAnnotations.example(value="bool copy_file_ok <- copy_file(\"../includes/my_folder\",\"../includes/my_new_folder\");", isExecutable=false)})
    public static boolean copy(IScope iScope, String string, String string2) {
        return Files.copy(iScope, string, string2, false);
    }

    static void deleteDir(File file2) {
        File[] fileArray;
        if (file2.isDirectory() && (fileArray = file2.listFiles()) != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray2[n2];
                if (!java.nio.file.Files.isSymbolicLink(file3.toPath())) {
                    Files.deleteDir(file3);
                }
                ++n2;
            }
        }
        file2.delete();
    }

    @GamlAnnotations.operator(value={"unzip"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="Unzip a given zip file into a given folder. Returns true if the file is well unzipped", examples={@GamlAnnotations.example(value="bool unzip_ok <- unzip([\"../includes/my_folder\"], \"folder.zip\";", isExecutable=false)})
    public static boolean unzip(IScope iScope, String string, String string2) {
        if (string == null || !Files.exist_file(iScope, string) || string2 == null || iScope == null) {
            return false;
        }
        String string3 = FileUtils.constructAbsoluteFilePath(iScope, string2, false);
        String string4 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        Files.extractFolder(iScope, string4, string3);
        return true;
    }

    @GamlAnnotations.operator(value={"zip"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="Zip a given list of files or folders. Returns true if the files are well zipped", examples={@GamlAnnotations.example(value="bool zip_ok <- zip([\"../includes/my_folder\"], \"folder.zip\";", isExecutable=false)})
    public static boolean zip(IScope iScope, IList<String> iList, String string) {
        if (iList == null || iList.isEmpty() || string == null || iScope == null) {
            return false;
        }
        String string2 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream outputStream = java.nio.file.Files.newOutputStream(new File(string2).toPath(), new OpenOption[0]);){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));){
                    for (String string3 : iList) {
                        String string4 = FileUtils.constructAbsoluteFilePath(iScope, string3, false);
                        File file2 = new File(string4);
                        Files.addFolderToZip(file2, zipOutputStream, file2.getParentFile().getAbsolutePath());
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error(iOException.getMessage(), iScope);
        }
        return true;
    }

    @GamlAnnotations.operator(value={"folder_exists", "directory_exists"}, can_be_const=false, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="Test whether the parameter is the path to an existing folder. False if it doesnt exist or if it is a file", examples={@GamlAnnotations.example(value="string file_name <-\"../includes/\";", isExecutable=false), @GamlAnnotations.example(value="if folder_exists(file_name){", isExecutable=false), @GamlAnnotations.example(value="\twrite \"Folder exists in the computer\";", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})
    public static boolean exist_folder(IScope iScope, String string) {
        if (string == null || iScope == null) {
            return false;
        }
        String string2 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        File file2 = new File(string2);
        return file2.exists() && file2.isDirectory();
    }

    @GamlAnnotations.operator(value={"directory", "folder"}, can_be_const=false, index_type=1, type=30, category={"Files-related operators"}, concept={"file"}, content_type=4)
    @GamlAnnotations.doc(value="opens an existing directory", usages={@GamlAnnotations.usage(value="If the specified string does not refer to an existing directory, an exception is risen.")}, examples={@GamlAnnotations.example(value="file dirT <- directory(\"../includes/\");", isExecutable=false), @GamlAnnotations.example(value="\t\t\t\t// dirT represents the directory \"../includes/\""), @GamlAnnotations.example(value="\t\t\t\t// dirT.contents here contains the list of the names of included files")}, see={"file", "new_folder"})
    public static GamaFolderFile folderFile(IScope iScope, String string) throws GamaRuntimeException {
        return new GamaFolderFile(iScope, string);
    }

    public static GamaFolderFile folderFile(IScope iScope, String string, boolean bl) throws GamaRuntimeException {
        return new GamaFolderFile(iScope, string, bl);
    }

    @GamlAnnotations.operator(value={"writable"}, category={"Files-related operators"}, concept={"file"}, index_type=-399, content_type=-299)
    @GamlAnnotations.doc(value="Marks the file as read-only or not, depending on the second boolean argument, and returns the first argument", comment="A file is created using its native flags. This operator can change them. Beware that this change is system-wide (and not only restrained to GAMA): changing a file to read-only mode (e.g. \"writable(f, false)\")", examples={@GamlAnnotations.example(value="shape_file(\"../images/point_eau.shp\") writable false", equals="returns a file in read-only mode", test=false)}, see={"file"})
    public static IGamaFile writable(IScope iScope, IGamaFile iGamaFile, Boolean bl) {
        if (iGamaFile == null) {
            throw GamaRuntimeException.error("Attempt to change the mode of a non-existent file", iScope);
        }
        boolean bl2 = bl == null ? false : bl;
        iGamaFile.setWritable(iScope, bl2);
        return iGamaFile;
    }

    @GamlAnnotations.operator(value={"read", "get"}, category={"Files-related operators"}, concept={"attribute", "file"})
    @GamlAnnotations.doc(value="Reads an attribute of the agent. The attribute's name is specified by the operand.", masterDoc=true, examples={@GamlAnnotations.example(var="agent_name", value="read ('name')", equals="reads the 'name' variable of agent then assigns the returned value to the 'agent_name' variable. ", test=false)})
    public static Object opRead(IScope iScope, String string) throws GamaRuntimeException {
        Map map = iScope.peekReadAttributes();
        if (map != null) {
            return map.get(string);
        }
        return Files.opRead(iScope, iScope.getAgent(), string);
    }

    @GamlAnnotations.operator(value={"get"}, category={"Containers-related operators"}, concept={"container", "species", "attribute"})
    @GamlAnnotations.doc(value="Reads an attribute of the specified agent (or geometry) (left operand). The attribute name is specified by the right operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="Reading the attribute of another agent", examples={@GamlAnnotations.example(value="string agent_name <- an_agent get('name');     // reads then 'name' attribute of an_agent then assigns the returned value to the agent_name variable", isExecutable=false)})})
    public static Object opRead(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        if (iAgent == null) {
            return null;
        }
        return iAgent.get(iScope, string);
    }

    @GamlAnnotations.operator(value={"get"}, category={"Files-related operators"}, concept={"geometry"})
    @GamlAnnotations.doc(value="Reads an attribute of the specified geometry (left operand). The attribute name is specified by the right operand.", usages={@GamlAnnotations.usage(value="Reading the attribute of a geometry", examples={@GamlAnnotations.example(value="string geom_area <- a_geometry get('area');     // reads then 'area' attribute of 'a_geometry' variable then assigns the returned value to the geom_area variable", isExecutable=false)})})
    public static Object opRead(IScope iScope, IShape iShape, String string) throws GamaRuntimeException {
        if (iShape == null) {
            return null;
        }
        return iShape.getGeometry().getAttribute(string);
    }

    @GamlAnnotations.operator(value={"new_folder"}, index_type=1, type=30, content_type=4, category={"Files-related operators"}, concept={"file"})
    @GamlAnnotations.doc(value="opens an existing repository or create a new folder if it does not exist.", comment="", usages={@GamlAnnotations.usage(value="If the specified string does not refer to an existing repository, the repository is created."), @GamlAnnotations.usage(value="If the string refers to an existing file, an exception is risen.")}, examples={@GamlAnnotations.example(value="file dirNewT <- new_folder(\"incl/\");   \t// dirNewT represents the repository \"../incl/\""), @GamlAnnotations.example(value="\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// eventually creates the directory ../incl")}, see={"folder", "file", "folder_exists"})
    public static GamaFolderFile newFolder(IScope iScope, String string) throws GamaRuntimeException {
        String string2 = FileUtils.constructAbsoluteFilePath(iScope, string, false);
        File file2 = new File(string2);
        if (file2.exists() && !file2.isDirectory()) {
            throw GamaRuntimeException.error("The folder " + string + " can not overwrite a file with the same name", iScope);
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return new GamaFolderFile(iScope, string);
    }

    @GamlAnnotations.operator(value={"flush_all_files"}, category={"Files-related operators"}, concept={"file"}, type=3)
    @GamlAnnotations.doc(value="Flushes all the pending save operations in the current simulation. ", comment="", usages={@GamlAnnotations.usage(value="This operator is only useful in simulations that save files using a buffering strategy."), @GamlAnnotations.usage(value="If a file writing fails it returns false, else it returns true."), @GamlAnnotations.usage(value="If a file writing fails it still tries to write the others.")}, examples={@GamlAnnotations.example(value="full_all_files(simulation);  // simulation is the current simulation, this can be important to differentiate in case of multi-simulation experiments")}, see={"save"})
    public static boolean flushAllFiles(IScope iScope, SimulationAgent simulationAgent) throws GamaRuntimeException {
        boolean bl = GAMA.getBufferingController().flushSaveFilesInCycle(simulationAgent);
        return bl &= GAMA.getBufferingController().flushSaveFilesOfAgent(simulationAgent);
    }
}

