/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.save;

import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.csv.AbstractCSVManipulator;
import gama.core.util.matrix.GamaMatrix;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import gama.gaml.statements.SaveStatement;
import gama.gaml.statements.save.AbstractSaver;
import gama.gaml.statements.save.SaveOptions;
import gama.gaml.types.IType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class CSVSaver
extends AbstractSaver {
    /*
     * WARNING - void declaration
     */
    @Override
    public void save(IScope iScope, IExpression iExpression, File file2, SaveOptions saveOptions) throws GamaRuntimeException, IOException {
        IList<Object> iList;
        StringBuilder stringBuilder = new StringBuilder();
        IType<?> iType = iExpression.getGamlType();
        SpeciesDescription speciesDescription = iType.isAgentType() ? iType.getSpecies() : (iType.getContentType().isAgentType() ? iType.getContentType().getSpecies() : null);
        Object object2 = iExpression.value(iScope);
        IList<Object> iList2 = iList = iType.isContainer() ? Cast.asList(iScope, object2) : GamaListFactory.create(iScope, iType, object2);
        if (iList.isEmpty()) {
            return;
        }
        char c = AbstractCSVManipulator.getDefaultDelimiter();
        if (speciesDescription != null) {
            Collection<String> collection = speciesDescription.getAttributeNames();
            collection.removeAll(SaveStatement.NON_SAVEABLE_ATTRIBUTE_NAMES);
            if (saveOptions.addHeader) {
                stringBuilder.append("cycle" + c + "name;location.x" + c + "location.y" + c + "location.z");
                for (String object3 : collection) {
                    stringBuilder.append(c + object3);
                }
                stringBuilder.append(Strings.LN);
            }
            for (Object e : iList) {
                if (!(e instanceof IAgent)) continue;
                IAgent iAgent = Cast.asAgent(iScope, e);
                stringBuilder.append(iScope.getClock().getCycle() + c + iAgent.getName().replace(';', ',') + c + iAgent.getLocation().getX() + c + iAgent.getLocation().getY() + c + iAgent.getLocation().getZ());
                for (String string : collection) {
                    String string2 = StringUtils.toGaml(iAgent.getDirectVarValue(iScope, string), false).replace(';', ',');
                    if (string2.startsWith("'") && string2.endsWith("'") || string2.startsWith("\"") && string2.endsWith("\"")) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    stringBuilder.append(c + string2);
                }
                stringBuilder.append(Strings.LN);
            }
        } else {
            if (saveOptions.addHeader) {
                stringBuilder.append(iExpression.serializeToGaml(true).replace("]", "").replace("[", "").replace(',', c));
                stringBuilder.append(Strings.LN);
            }
            if (iType.id() == 8) {
                GamaMatrix gamaMatrix = (GamaMatrix)object2;
                gamaMatrix.rowByRow(iScope, object -> {
                    StringBuilder stringBuilder2 = stringBuilder.append(this.toCleanString(object));
                }, () -> {
                    StringBuilder stringBuilder2 = stringBuilder.append(c);
                }, () -> {
                    StringBuilder stringBuilder2 = stringBuilder.append(Strings.LN);
                });
            } else {
                void var12_19;
                int n = iList.size();
                boolean bl = false;
                while (var12_19 < n) {
                    if (var12_19 > 0) {
                        stringBuilder.append(c);
                    }
                    stringBuilder.append(this.toCleanString(iList.get((int)var12_19)));
                    ++var12_19;
                }
            }
            stringBuilder.append(Strings.LN);
        }
        GAMA.getBufferingController().askWriteFile(file2.getAbsolutePath(), iScope, stringBuilder, saveOptions);
    }

    private String toCleanString(Object object) {
        String string = StringUtils.toGaml(object, false).replace(';', ',');
        if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (object instanceof String) {
            string = string.replace("\\'", "'");
            string = string.replace("\\\"", "\"");
        }
        return string;
    }

    @Override
    protected Set<String> computeFileTypes() {
        return Set.of("csv");
    }
}

