/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.continuous.ContinuousTopology;
import gama.core.metamodel.topology.continuous.MultipleTopology;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.metamodel.topology.graph.ISpatialGraph;
import gama.core.metamodel.topology.grid.GridTopology;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.type(name="topology", id=18, wraps={ITopology.class}, kind=104, concept={"type", "topology"}, doc={@GamlAnnotations.doc(value="Represents a topology, obtained from agents or geometries, that can be used to compute distances, neighbours, etc.")})
public class GamaTopologyType
extends GamaType<ITopology> {
    public static ITopology staticCast(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        if (object == null) {
            return null;
        }
        if (object instanceof ISpatialGraph) {
            return ((ISpatialGraph)object).getTopology(iScope);
        }
        if (object instanceof ITopology) {
            return (ITopology)object;
        }
        if (object instanceof IAgent) {
            return ((IAgent)object).getTopology();
        }
        if (object instanceof IPopulation) {
            return ((IPopulation)object).getTopology();
        }
        if (object instanceof ISpecies) {
            return GamaTopologyType.staticCast(iScope, iScope.getAgent().getPopulationFor((ISpecies)object), bl);
        }
        if (object instanceof IShape) {
            return GamaTopologyType.from(iScope, (IShape)object);
        }
        if (object instanceof IContainer) {
            return GamaTopologyType.from(iScope, (IContainer)object);
        }
        return GamaTopologyType.staticCast(iScope, Cast.asGeometry(iScope, object, bl), bl);
    }

    @Override
    @GamlAnnotations.doc(value="casting of the operand to a topology.", usages={@GamlAnnotations.usage(value="if the operand is a topology, returns the topology itself;"), @GamlAnnotations.usage(value="if the operand is a spatial graph, returns the graph topology associated;"), @GamlAnnotations.usage(value="if the operand is a population, returns the topology of the population;"), @GamlAnnotations.usage(value="if the operand is a shape or a geometry, returns the continuous topology bounded by the geometry;"), @GamlAnnotations.usage(value="if the operand is a matrix, returns the grid topology associated"), @GamlAnnotations.usage(value="if the operand is another kind of container, returns the multiple topology associated to the container"), @GamlAnnotations.usage(value="otherwise, casts the operand to a geometry and build a topology from it.")}, examples={@GamlAnnotations.example(value="topology(0)", equals="nil", isExecutable=true), @GamlAnnotations.example(value="topology(a_graph)\t--: Multiple topology in POLYGON ((24.712119771887785 7.867357373616512, 24.712119771887785 61.283226839310565, 82.4013676510046  7.867357373616512)) at location[53.556743711446195;34.57529210646354]", isExecutable=false)}, see={"geometry"})
    public ITopology cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaTopologyType.staticCast(iScope, object, bl);
    }

    public static ITopology from(IScope iScope, IShape iShape) {
        return new ContinuousTopology(iScope, iShape);
    }

    private static ITopology from(IScope iScope, IContainer<?, IShape> iContainer) throws GamaRuntimeException {
        if (iContainer instanceof GamaSpatialGraph) {
            return ((GamaSpatialGraph)iContainer).getTopology(iScope);
        }
        if (iContainer instanceof IGrid) {
            return new GridTopology(iScope, (IGrid)iContainer);
        }
        return new MultipleTopology(iScope, iContainer);
    }

    @Override
    public ITopology getDefault() {
        return null;
    }

    @Override
    public IType<?> getContentType() {
        return Types.GEOMETRY;
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }

    @Override
    public ITopology deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return GamaTopologyType.from(iScope, Cast.asGeometry(iScope, iMap.get("environment")));
    }
}

