/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.interfaces;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.common.interfaces.ILayerManager;
import gama.core.common.interfaces.IScoped;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.IEventLayerListener;
import gama.core.runtime.IScope;
import gama.gaml.statements.draw.DrawingAttributes;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.locationtech.jts.geom.Envelope;

public interface IDisplaySurface
extends LayeredDisplayData.DisplayDataListener,
IScoped,
IDisposable {
    public static final String SNAPSHOT_FOLDER_NAME = "snapshots";
    public static final double MIN_ZOOM_FACTOR = 0.1;
    public static final int MAX_ZOOM_FACTOR = 10;
    public static final double SELECTION_SIZE = 5.0;
    public static final GamaPoint NULL_POINT = new GamaPoint.Immutable();

    public BufferedImage getImage(int var1, int var2);

    public void updateDisplay(boolean var1, GeneralSynchronizer var2);

    default public void updateDisplay(boolean bl) {
        this.updateDisplay(bl, null);
    }

    public void setMenuManager(Object var1);

    public void zoomIn();

    public void zoomOut();

    public void zoomFit();

    public void toggleLock();

    public ILayerManager getManager();

    public void focusOn(IShape var1);

    public void runAndUpdate(Runnable var1);

    public int getWidth();

    public int getHeight();

    public void outputReloaded();

    public double getEnvWidth();

    public double getEnvHeight();

    public double getDisplayWidth();

    public double getDisplayHeight();

    default public GamaPoint getModelCoordinates() {
        return NULL_POINT;
    }

    default public GamaPoint getWindowCoordinates() {
        return NULL_POINT;
    }

    default public GamaPoint getModelCoordinatesFrom(int n, int n2, Point point, Point point2) {
        return NULL_POINT;
    }

    public Collection<IAgent> selectAgent(int var1, int var2);

    public double getZoomLevel();

    public void setSize(int var1, int var2);

    public LayeredDisplayOutput getOutput();

    public LayeredDisplayData getData();

    public void layersChanged();

    public void addListener(IEventLayerListener var1);

    public void removeListener(IEventLayerListener var1);

    public Collection<IEventLayerListener> getLayerListeners();

    public Envelope getVisibleRegionForLayer(ILayer var1);

    public int getFPS();

    public boolean isDisposed();

    public void getModelCoordinatesInfo(StringBuilder var1);

    public void dispatchKeyEvent(char var1);

    public void dispatchSpecialKeyEvent(int var1);

    public void dispatchMouseEvent(int var1, int var2, int var3);

    public void setMousePosition(int var1, int var2);

    public void draggedTo(int var1, int var2);

    public void selectAgentsAroundMouse();

    default public Font computeFont(Font font) {
        return font;
    }

    default public boolean canTriggerContextualMenu() {
        return !this.getManager().hasMouseMenuEventLayer();
    }

    @Override
    public IScope.IGraphicsScope getScope();

    public boolean isVisible();

    public IGraphics getIGraphics();

    public Rectangle getBoundsForRobotSnapshot();

    default public boolean isEscRedefined() {
        return this.getManager().hasEscEventLayer();
    }

    default public boolean isArrowRedefined() {
        return this.getManager().hasArrowEventLayer();
    }

    default public boolean shouldWaitToBecomeRendered() {
        return true;
    }

    public static interface OpenGL
    extends IDisplaySurface {
        public Envelope3D getROIDimensions();

        public void setPaused(boolean var1);

        public void selectAgent(DrawingAttributes var1);

        public void selectionIn(Envelope3D var1);
    }
}

