/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.util;

import com.google.common.collect.Queues;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.preferences.GamaPreferences;
import gama.dev.DEBUG;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;

public class PoolUtils {
    static Set<ObjectPool> POOLS = new LinkedHashSet<ObjectPool>();
    public static boolean POOL = GamaPreferences.Experimental.USE_POOLING.getValue();

    static {
        DEBUG.OFF();
        GamaPreferences.Experimental.USE_POOLING.onChange(bl -> {
            POOLS.forEach(ObjectPool::dispose);
            POOL = bl;
        });
    }

    public static void writeStats() {
        if (!DEBUG.IS_ON()) {
            return;
        }
        DEBUG.SECTION((String)"Pool statistics");
        POOLS.forEach(objectPool -> {
            long l = objectPool.accessed == 0L ? 100L : 100L - (long)((double)objectPool.created * 100.0 / (double)objectPool.accessed);
            DEBUG.OUT((String)objectPool.name, (int)30, (Object)("instances created " + objectPool.created + " / instances asked " + objectPool.accessed + " = " + l + "% of coverage"));
        });
    }

    public static <T> ObjectPool<T> create(String string, boolean bl, ObjectFactory<T> objectFactory, ObjectCopy<T> objectCopy, ObjectCleaner<T> objectCleaner) {
        DEBUG.OUT((Object)("Adding object pool: " + string));
        ObjectPool<T> objectPool = new ObjectPool<T>(objectFactory, objectCopy, objectCleaner);
        objectPool.active = bl;
        objectPool.name = string;
        POOLS.add(objectPool);
        return objectPool;
    }

    public static interface ObjectCleaner<T> {
        public void clean(T var1);
    }

    public static interface ObjectCopy<T> {
        public void createNew(T var1, T var2);
    }

    public static interface ObjectFactory<T> {
        public T createNew();
    }

    public static class ObjectPool<T>
    implements IDisposable {
        private String name;
        private long accessed;
        private long released;
        private long created;
        private final ObjectFactory<T> factory;
        private final ObjectCopy<T> copy;
        private final ObjectCleaner<T> cleaner;
        private final Queue<T> objects;
        public boolean active;

        private ObjectPool(ObjectFactory<T> objectFactory, ObjectCopy<T> objectCopy, ObjectCleaner<T> objectCleaner) {
            this.factory = objectFactory;
            this.copy = objectCopy;
            this.cleaner = objectCleaner;
            this.objects = Queues.synchronizedDeque((Deque)Queues.newArrayDeque());
        }

        public T get() {
            if (!POOL || !this.active) {
                return this.factory.createNew();
            }
            ++this.accessed;
            T t = this.objects.poll();
            if (t == null) {
                ++this.created;
                t = this.factory.createNew();
            }
            return t;
        }

        public T get(T t) {
            T t2 = this.get();
            if (this.copy != null) {
                this.copy.createNew(t, t2);
            }
            return t2;
        }

        public void release(T ... TArray) {
            if (TArray == null) {
                return;
            }
            T[] TArray2 = TArray;
            int n = TArray.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray2[n2];
                if (this.cleaner != null) {
                    this.cleaner.clean(t);
                }
                if (POOL && this.active) {
                    ++this.released;
                    this.objects.offer(t);
                }
                ++n2;
            }
        }

        @Override
        public void dispose() {
            this.objects.clear();
        }
    }
}

