/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaDate;
import gama.core.util.GamaDateInterval;
import gama.core.util.IList;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Dates;
import gama.gaml.statements.ActionStatement;
import gama.gaml.statements.IStatement;
import gama.gaml.types.GamaDateType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import gama.gaml.variables.Variable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.util.NumberUtil;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-200}, optional=true, doc={@GamlAnnotations.doc(value="The message displayed in the interface")}), @GamlAnnotations.facet(name="type", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="the variable type")}), @GamlAnnotations.facet(name="init", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the init value")}), @GamlAnnotations.facet(name="min", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the minimum value")}), @GamlAnnotations.facet(name="max", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the maximum value")}), @GamlAnnotations.facet(name="category", type={4}, optional=true, doc={@GamlAnnotations.doc(value="a category label, used to group parameters in the interface")}), @GamlAnnotations.facet(name="var", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the name of the variable (that should be declared in global)")}), @GamlAnnotations.facet(name="unit", type={4}, optional=true, doc={@GamlAnnotations.doc(value="the variable unit")}), @GamlAnnotations.facet(name="on_change", type={0}, optional=true, doc={@GamlAnnotations.doc(value="Provides a block of statements that will be executed whenever the value of the parameter changes")}), @GamlAnnotations.facet(name="enables", type={5}, optional=true, doc={@GamlAnnotations.doc(value="a list of global variables whose parameter editors will be enabled when this parameter value is set to true or to a value that casts to true (they are otherwise disabled)")}), @GamlAnnotations.facet(name="disables", type={5}, optional=true, doc={@GamlAnnotations.doc(value="a list of global variables whose parameter editors will be disabled when this parameter value is set to true or to a value that casts to true (they are otherwise enabled)")}), @GamlAnnotations.facet(name="updates", type={5}, optional=true, doc={@GamlAnnotations.doc(value="a list of global variables whose parameter editors will be updated when this parameter value is changed (their min, max, step and among values will be updated accordingly if they depend on this parameter. Note that it might lead to some inconsistencies, for instance a parameter value which becomes out of range, or which does not belong anymore to a list of possible values. In these cases, the value of the affected parameter will not change)")}), @GamlAnnotations.facet(name="in_workspace", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Makes only sense for file parameters. Whether the file selector will be restricted to the workspace or not")}), @GamlAnnotations.facet(name="extensions", type={5}, of=4, optional=true, doc={@GamlAnnotations.doc(value="Makes only sense for file parameters. A list of file extensions (like 'gaml', 'shp', etc.) that restricts the choice offered to the users to certain file types (folders not concerned). Default is empty, effectively accepting all files")}), @GamlAnnotations.facet(name="slider", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether or not to display a slider for entering an int or float value. Default is true when max and min values are defined, false otherwise. If no max or min value is defined, setting this facet to true will have no effect")}), @GamlAnnotations.facet(name="colors", type={5}, of=6, optional=true, doc={@GamlAnnotations.doc(value="The colors of the control in the UI. An empty list has no effects. Only used for sliders and switches so far. For sliders, 3 colors will allow to specify the color of the left section, the thumb and the right section (in this order); 2 colors will define the left and right sections only (thumb will be dark green); 1 color will define the left section and the thumb. For switches, 2 colors will define the background for respectively the left 'true' and right 'false' sections. 1 color will define both backgrounds")}), @GamlAnnotations.facet(name="labels", type={5}, of=4, optional=true, doc={@GamlAnnotations.doc(value="The labels that will be displayed for switches (instead of True/False)")}), @GamlAnnotations.facet(name="step", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the increment step (mainly used in batch mode to express the variation step between simulation)")}), @GamlAnnotations.facet(name="read_only", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether this parameter is read-only or editable")}), @GamlAnnotations.facet(name="among", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the list of possible values that this parameter can take")})}, omissible="name")
@GamlAnnotations.inside(kinds={13})
@validator(value=ExperimentParameterValidator.class)
@GamlAnnotations.doc(value="The parameter statement specifies which global attributes (i) will change through the successive simulations (in batch experiments), (ii) can be modified by user via the interface (in gui experiments). In GUI experiments, parameters are displayed depending on their type.", usages={@GamlAnnotations.usage(value="In gui experiment, the general syntax is the following:", examples={@GamlAnnotations.example(value="parameter title var: global_var category: cat;", isExecutable=false)}), @GamlAnnotations.usage(value="In batch experiment, the two following syntaxes can be used to describe the possible values of a parameter:", examples={@GamlAnnotations.example(value="parameter 'Value of toto:' var: toto among: [1, 3, 7, 15, 100]; ", isExecutable=false), @GamlAnnotations.example(value="parameter 'Value of titi:' var: titi min: 1 max: 100 step: 2; ", isExecutable=false)})})
public class ExperimentParameter
extends Symbol
implements IParameter.Batch {
    static final Object UNDEFINED = new Object();
    private Object value = UNDEFINED;
    private final String[] disables;
    private final String[] enables;
    private final String[] extensions;
    private final String[] updates;
    private final String[] labels;
    String varName;
    String title;
    String category;
    String unitLabel;
    IType type = Types.NO_TYPE;
    boolean isEditable;
    boolean canBeNull;
    boolean isDefined = true;
    boolean isExperiment = false;
    final IExpression init;
    final IExpression among;
    final IExpression min;
    final IExpression max;
    final IExpression step;
    final IExpression slider;
    final IExpression onChange;
    final IExpression inWorkspace;
    final List<IParameter.ParameterChangeListener> listeners = new ArrayList<IParameter.ParameterChangeListener>();
    ActionStatement action;

    public ExperimentParameter(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        IExpression iExpression;
        VariableDescription variableDescription = (VariableDescription)iDescription;
        this.setName(variableDescription.getLitteral("var"));
        this.type = variableDescription.getGamlType();
        this.title = iDescription.getName();
        this.unitLabel = this.getLiteral("unit");
        this.min = this.getFacet("min");
        IScope iScope2 = GAMA.getRuntimeScope();
        if (this.min != null && this.min.isConst()) {
            this.getMinValue(iScope2);
        }
        this.max = this.getFacet("max");
        if (this.max != null && this.max.isConst()) {
            this.getMaxValue(iScope2);
        }
        this.step = this.getFacet("step");
        if (this.step != null && this.step.isConst()) {
            this.getStepValue(iScope2);
        }
        this.among = this.getFacet("among");
        this.onChange = this.getFacet("on_change");
        if (this.onChange != null) {
            this.listeners.add((iScope, object) -> {
                IStatement.WithArgs withArgs = iScope.getExperiment().getSpecies().getAction(Cast.asString(iScope, this.onChange.value(iScope)));
                iScope.getExperiment().executeAction(withArgs);
            });
        }
        this.inWorkspace = this.getFacet("in_workspace");
        this.slider = this.getFacet("slider");
        IExpressionDescription iExpressionDescription = this.getDescription().getFacet("disables");
        IExpressionDescription iExpressionDescription2 = this.getDescription().getFacet("enables");
        IExpressionDescription iExpressionDescription3 = this.getDescription().getFacet("extensions");
        IExpressionDescription iExpressionDescription4 = this.getDescription().getFacet("updates");
        IExpressionDescription iExpressionDescription5 = this.getDescription().getFacet("labels");
        this.disables = iExpressionDescription != null ? iExpressionDescription.getStrings(this.getDescription(), false).toArray(new String[0]) : EMPTY_STRINGS;
        this.enables = iExpressionDescription2 != null ? iExpressionDescription2.getStrings(this.getDescription(), false).toArray(new String[0]) : EMPTY_STRINGS;
        this.extensions = iExpressionDescription3 != null ? iExpressionDescription3.getStrings(this.getDescription(), false).toArray(new String[0]) : EMPTY_STRINGS;
        this.updates = iExpressionDescription4 != null ? iExpressionDescription4.getStrings(this.getDescription(), false).toArray(new String[0]) : EMPTY_STRINGS;
        String[] stringArray = iExpressionDescription5 != null ? iExpressionDescription5.getStrings(this.getDescription(), false).toArray(new String[0]) : SWITCH_STRINGS;
        this.labels = stringArray.length != 2 ? SWITCH_STRINGS : stringArray;
        VariableDescription variableDescription2 = ExperimentParameter.findTargetedVar(iDescription, this.varName);
        this.init = this.hasFacet("init") ? this.getFacet("init") : variableDescription2.getFacetExpr("init");
        boolean bl = this.isEditable = !variableDescription2.isNotModifiable();
        if (this.isEditable && (iExpression = this.getFacet("read_only")) != null) {
            this.isEditable = Cast.asBool(iScope2, iExpression.value(iScope2)) == false;
        }
        this.isExperiment = variableDescription2.isDefinedInExperiment();
        this.setCategory(variableDescription.getLitteral("category"));
    }

    public static VariableDescription findTargetedVar(IDescription iDescription, String string) {
        ModelDescription modelDescription = iDescription.getModelDescription();
        VariableDescription variableDescription = modelDescription.getAttribute(string);
        if (variableDescription == null) {
            ExperimentDescription experimentDescription = (ExperimentDescription)iDescription.getEnclosingDescription();
            variableDescription = experimentDescription.getAttribute(string);
        }
        return variableDescription;
    }

    public ExperimentParameter(IScope iScope, IParameter iParameter) {
        this(iScope, iParameter, iParameter.getTitle(), iParameter.getCategory(), iParameter.getAmongValue(iScope), false);
    }

    public ExperimentParameter(IScope iScope, IParameter iParameter, String string, String string2, List list, boolean bl) {
        this(iScope, iParameter, string, string2, null, list, bl);
    }

    public ExperimentParameter(IScope iScope, IParameter iParameter, String string, String string2, String string3, List list, boolean bl) {
        super(null);
        this.slider = null;
        this.title = string;
        this.disables = EMPTY_STRINGS;
        this.enables = EMPTY_STRINGS;
        this.labels = EMPTY_STRINGS;
        this.canBeNull = bl;
        this.among = list != null ? new ConstantExpression(list) : null;
        Object object = iParameter.getMinValue(iScope);
        this.min = object != null ? new ConstantExpression(object) : null;
        Object object2 = iParameter.getMaxValue(iScope);
        this.max = object2 != null ? new ConstantExpression(object2) : null;
        Comparable comparable = iParameter.getStepValue(iScope);
        this.step = comparable != null ? new ConstantExpression(comparable) : null;
        this.onChange = null;
        this.setName(iParameter.getName());
        this.setCategory(string2);
        this.setType(iParameter.getType());
        if (iParameter instanceof IVariable && this.getType().getGamlType().id() == 12) {
            this.init = ((IVariable)iParameter).getFacet("init");
        } else {
            this.init = null;
            this.setValue(iScope, iParameter.getInitialValue(iScope));
        }
        this.setEditable(iParameter.isEditable());
        this.isExperiment = iParameter.isDefinedInExperiment();
        this.inWorkspace = null;
        this.extensions = EMPTY_STRINGS;
        this.updates = EMPTY_STRINGS;
    }

    @Override
    public void setName(String string) {
        this.varName = string;
        if (this.title == null) {
            this.title = string;
        }
    }

    @Override
    public List<GamaColor> getColors(IScope iScope) {
        try {
            IExpression iExpression;
            if (iScope != null) {
                iScope.push(this);
            }
            List list = (iExpression = this.getFacet("colors")) == null ? null : (List)Types.LIST.cast(iScope, iExpression.value(iScope), (Object)null, (IType)Types.INT, (IType)Types.COLOR, false);
            return list;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        try {
            List<GamaColor> list;
            if (iScope != null) {
                iScope.push(this);
            }
            if ((list = this.getColors(iScope)) == null || list.isEmpty()) {
                return null;
            }
            GamaColor gamaColor = list.get(0);
            return gamaColor;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.listeners.clear();
    }

    private void setType(IType iType) {
        this.type = iType;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isDefined() {
        return this.isDefined;
    }

    @Override
    public void setDefined(boolean bl) {
        this.isDefined = bl;
    }

    @Override
    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    @Override
    public void addChangedListener(IParameter.ParameterChangeListener parameterChangeListener) {
        if (!this.listeners.contains(parameterChangeListener)) {
            this.listeners.add(parameterChangeListener);
        }
    }

    private Object verifyMin(IScope iScope, Object object) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (!(object instanceof Comparable)) {
                Object object2 = object;
                return object2;
            }
            Comparable comparable = (Comparable)object;
            Comparable comparable2 = this.getMinValue(iScope);
            if (comparable2 != null && comparable2.compareTo(comparable) > 0) {
                Comparable comparable3 = comparable2;
                return comparable3;
            }
            Object object3 = object;
            return object3;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    private Object verifyMax(IScope iScope, Object object) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (!(object instanceof Comparable)) {
                Object object2 = object;
                return object2;
            }
            Comparable comparable = (Comparable)object;
            Comparable comparable2 = this.getMaxValue(iScope);
            if (comparable2 != null && comparable2.compareTo(comparable) < 0) {
                Comparable comparable3 = comparable2;
                return comparable3;
            }
            Object object3 = object;
            return object3;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    public void setAndVerifyValue(IScope iScope, Object object) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            Object object2 = this.verifyMin(iScope, this.verifyMax(iScope, this.type.cast(iScope, object, null, false)));
            object2 = this.filterWithAmong(iScope, object2);
            if (this.value != UNDEFINED) {
                for (IParameter.ParameterChangeListener parameterChangeListener : this.listeners) {
                    parameterChangeListener.changed(iScope, object2);
                }
            }
            this.value = object2;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public void setValueNoCheckNoNotification(Object object) {
        this.value = object;
    }

    private Object filterWithAmong(IScope iScope, Object object) {
        try {
            List list;
            if (iScope != null) {
                iScope.push(this);
            }
            if ((list = this.getAmongValue(iScope)) == null || list.isEmpty()) {
                Object object2 = object;
                return object2;
            }
            if (Types.FLOAT.equals(this.getType())) {
                double d = Cast.asFloat(iScope, object);
                for (Object e : list) {
                    Double d2 = Cast.asFloat(iScope, e);
                    Double d3 = 1.0E-7;
                    if (!NumberUtil.equalsWithTolerance((double)d2, (double)d, (double)d3)) continue;
                    Double d4 = d2;
                    return d4;
                }
            } else if (list.contains(object)) {
                Object object3 = object;
                return object3;
            }
            Object e = list.get(0);
            return e;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public void setValue(IScope iScope, Object object) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (object == UNDEFINED) {
                List list = this.getAmongValue(iScope);
                this.value = list != null ? list.get(iScope.getRandom().between(0, list.size() - 1)) : (this.type.id() == 1 || this.type.id() == 2 || this.type.id() == 7 || this.type.id() == 23 ? this.drawRandomValue(iScope) : (this.type.id() == 3 ? Boolean.valueOf(iScope.getRandom().between(1, 100) > 50) : null));
                return;
            }
            this.setAndVerifyValue(iScope, object);
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public void reinitRandomly(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            this.setValue(iScope, UNDEFINED);
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    private Comparable drawRandomValue(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            Comparable comparable = this.getMinValue(iScope);
            Comparable comparable2 = this.getMaxValue(iScope);
            Comparable comparable3 = this.getStepValue(iScope);
            Number number = switch (this.type.id()) {
                case 1 -> {
                    int var5_5 = comparable == null ? Integer.MIN_VALUE : Cast.asInt(iScope, comparable);
                    int var6_9 = comparable2 == null ? Integer.MAX_VALUE : Cast.asInt(iScope, comparable2);
                    int var7_11 = comparable3 == null ? 1 : Cast.asInt(iScope, comparable3);
                    yield iScope.getRandom().between(var5_5, var6_9, var7_11);
                }
                case 7 -> {
                    GamaPoint var5_6 = comparable3 == null ? new GamaPoint(1.0, 1.0, 1.0) : Cast.asPoint(iScope, comparable3);
                    GamaPoint var6_10 = comparable == null ? new GamaPoint(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE) : Cast.asPoint(iScope, comparable);
                    GamaPoint var7_12 = comparable2 == null ? new GamaPoint(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE) : Cast.asPoint(iScope, comparable2);
                    yield iScope.getRandom().between(var6_10, var7_12, var5_6);
                }
                case 23 -> {
                    double var5_7 = comparable3 == null ? Dates.DATES_TIME_STEP.getValue() : Cast.asFloat(iScope, comparable3);
                    GamaDate var7_13 = comparable == null ? GamaDate.of(LocalDateTime.now()).minus(Integer.MAX_VALUE, ChronoUnit.SECONDS) : GamaDateType.staticCast(iScope, comparable, null, false);
                    GamaDate var8_15 = comparable2 == null ? GamaDate.of(LocalDateTime.now()).plus(Integer.MAX_VALUE, (TemporalUnit)ChronoUnit.SECONDS) : GamaDateType.staticCast(iScope, comparable2, null, false);
                    yield new GamaDateInterval(var7_13, var8_15, Duration.of((long)var5_7, ChronoUnit.SECONDS)).anyValue(iScope);
                }
                default -> {
                    double var5_8 = comparable3 == null ? 1.0 : Cast.asFloat(iScope, comparable3);
                    double var7_14 = comparable == null ? Double.MIN_VALUE : Cast.asFloat(iScope, comparable);
                    double var9_16 = comparable2 == null ? Double.MAX_VALUE : Cast.asFloat(iScope, comparable2);
                    yield iScope.getRandom().between(var7_14, var9_16, var5_8);
                }
            };
            return number;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<Object> neighborValues(IScope var1_1) throws GamaRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getName() {
        return this.varName;
    }

    @Override
    public String getCategory() {
        return this.category == null ? IParameter.Batch.super.getCategory() : this.category;
    }

    @Override
    public void setCategory(String string) {
        this.category = string;
    }

    @Override
    public Object value(IScope iScope) {
        return this.getValue(iScope);
    }

    @Override
    public Object value() {
        return GAMA.run(this::getValue);
    }

    @Override
    public Object getInitialValue(IScope iScope) {
        return this.getValue(iScope);
    }

    @Override
    public Comparable getMinValue(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (this.min == null) {
                return null;
            }
            Object Support = this.type.cast(iScope, this.min.value(iScope), null, false);
            if (!(Support instanceof Comparable)) {
                return null;
            }
            Comparable comparable = (Comparable)Support;
            Comparable comparable2 = comparable;
            return comparable2;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public Comparable getMaxValue(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (this.max == null) {
                return null;
            }
            Object Support = this.type.cast(iScope, this.max.value(iScope), null, false);
            if (!(Support instanceof Comparable)) {
                return null;
            }
            Comparable comparable = (Comparable)Support;
            Comparable comparable2 = comparable;
            return comparable2;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public List getAmongValue(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (this.among != null) {
                IList iList = Cast.asList(iScope, this.among.value(iScope));
                return iList;
            }
            return null;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public Comparable getStepValue(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            Comparable comparable = this.step == null ? null : (Comparable)this.step.value(iScope);
            return comparable;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.varName;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList<IStatement> arrayList = new ArrayList<IStatement>();
        for (ISymbol iDisposable : iterable) {
            if (!(iDisposable instanceof IStatement)) continue;
            arrayList.add((IStatement)iDisposable);
        }
        if (!arrayList.isEmpty()) {
            IDescription iDescription = DescriptionFactory.create("action", this.getDescription(), "name", "inline");
            this.action = new ActionStatement(iDescription);
            this.action.setChildren(arrayList);
            this.listeners.add((iScope, object) -> iScope.getExperiment().executeAction(this.action));
        }
    }

    public String toString() {
        return "Parameter '" + this.title + "' targets var " + this.varName;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    @Override
    public boolean canBeExplored() {
        return this.among != null || this.min != null && this.max != null;
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (this.unitLabel == null && this.canBeExplored()) {
                List list = this.getAmongValue(iScope);
                if (list != null) {
                    String string = "among " + String.valueOf(list);
                    return string;
                }
                String string = "between " + String.valueOf(this.getMinValue(iScope)) + " and " + String.valueOf(this.getMaxValue(iScope)) + " every " + String.valueOf(this.getStepValue(iScope));
                return string;
            }
            String string = this.unitLabel;
            return string;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public void setUnitLabel(String string) {
        this.unitLabel = string;
    }

    Object getValue(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (this.value == UNDEFINED && this.init != null) {
                this.setValue(iScope, this.init.value(iScope));
            }
            Object object = this.value;
            return object;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public boolean acceptsSlider(IScope iScope) {
        try {
            if (iScope != null) {
                iScope.push(this);
            }
            if (this.slider == null) {
                return true;
            }
            boolean bl = Cast.asBool(iScope, this.slider.value(iScope));
            return bl;
        }
        finally {
            if (iScope != null) {
                iScope.pop(this);
            }
        }
    }

    @Override
    public String[] getEnablement() {
        return this.enables;
    }

    @Override
    public String[] getDisablement() {
        return this.disables;
    }

    @Override
    public boolean isDefinedInExperiment() {
        return this.isExperiment;
    }

    @Override
    public String[] getFileExtensions() {
        return this.extensions;
    }

    @Override
    public String[] getRefreshment() {
        return this.updates;
    }

    @Override
    public boolean isWorkspace() {
        if (this.inWorkspace == null) {
            return false;
        }
        return GAMA.run(iScope -> Cast.asBool(iScope, this.inWorkspace.value(iScope)));
    }

    @Override
    public String[] getLabels(IScope iScope) {
        return this.labels;
    }

    public static class ExperimentParameterValidator
    extends Variable.VarValidator {
        @Override
        public void validate(IDescription iDescription) {
            super.validate(iDescription);
            String string = iDescription.getLitteral("var");
            VariableDescription variableDescription = ExperimentParameter.findTargetedVar(iDescription, string);
            ExperimentDescription experimentDescription = (ExperimentDescription)iDescription.getEnclosingDescription();
            if (variableDescription != null && variableDescription.isDefinedInExperiment() && experimentDescription.isBatch().booleanValue()) {
                iDescription.info("This parameter will not be explored as " + string + " is an attribute of the experiment. Only attributes of the model/simulation, defined in 'global', can be explored by batch experiments.", "gaml.wrong.context.issue");
            }
        }
    }
}

