/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.population;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.PopulationNotifier;
import gama.core.metamodel.population.VariableOrderingGraph;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.continuous.ContinuousTopology;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.filter.In;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.metamodel.topology.graph.GraphTopology;
import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.StopWatch;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaList;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.AbstractGraphNodeAgent;
import gama.dev.DEBUG;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.GamaTopologyType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jgrapht.graph.DirectedAcyclicGraph;

public class GamaPopulation<T extends IAgent>
extends GamaList<T>
implements IPopulation<T> {
    private volatile boolean isDisposing = false;
    protected IMacroAgent host;
    protected ITopology topology;
    protected final ISpecies species;
    protected final IVariable[] orderedVars;
    protected final IVariable[] updatableVars;
    protected int currentAgentIndex;
    private final int hashCode;
    private final boolean isInitOverriden;
    private final boolean isStepOverriden;
    private final MirrorPopulationManagement mirrorManagement;
    private final PopulationNotifier notifier = new PopulationNotifier();
    public final LinkedHashSet<String> orderedVarNames = new LinkedHashSet();
    public static final IPopulation.IsLiving isLiving;

    static {
        DEBUG.ON();
        isLiving = new IPopulation.IsLiving();
    }

    private static void tryAdd(DirectedAcyclicGraph<String, Object> directedAcyclicGraph, String string, String string2) {
        directedAcyclicGraph.addVertex((Object)string);
        try {
            directedAcyclicGraph.addEdge((Object)string, (Object)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    public boolean isDisposing() {
        return this.isDisposing;
    }

    public static IVariable[] orderAttributes(IPopulation iPopulation, TypeDescription typeDescription, com.google.common.base.Predicate<VariableDescription> predicate, Set<String> set) {
        VariableOrderingGraph variableOrderingGraph = new VariableOrderingGraph();
        typeDescription.visitAllAttributes(iDescription -> {
            VariableDescription variableDescription = (VariableDescription)iDescription;
            if (predicate.apply((Object)variableDescription)) {
                String string = variableDescription.getName();
                variableOrderingGraph.addVertex(string);
                for (VariableDescription variableDescription2 : variableDescription.getDependencies(set, false, true)) {
                    if (!predicate.apply((Object)variableDescription2)) continue;
                    GamaPopulation.tryAdd(variableOrderingGraph, variableDescription2.getName(), string);
                }
                if (variableDescription.isSyntheticSpeciesContainer()) {
                    GamaPopulation.tryAdd(variableOrderingGraph, "shape", string);
                }
            }
            return true;
        });
        ArrayList arrayList = new ArrayList();
        typeDescription.visitAllAttributes(iDescription -> {
            VariableDescription variableDescription = (VariableDescription)iDescription;
            if (variableDescription.isSyntheticSpeciesContainer()) {
                arrayList.add(variableDescription);
            }
            return true;
        });
        int n = 0;
        while (n < arrayList.size() - 1) {
            VariableDescription variableDescription;
            VariableDescription variableDescription2 = (VariableDescription)arrayList.get(n);
            if (predicate.apply((Object)variableDescription2) && predicate.apply((Object)(variableDescription = (VariableDescription)arrayList.get(n + 1)))) {
                String string2 = variableDescription2.getName();
                String string3 = variableDescription.getName();
                if (!variableOrderingGraph.containsEdge(string3, string2)) {
                    GamaPopulation.tryAdd(variableOrderingGraph, string2, string3);
                }
            }
            ++n;
        }
        return (IVariable[])Iterators.toArray((Iterator)Iterators.transform((Iterator)variableOrderingGraph.iterator(), string -> iPopulation.getVar((String)string)), IVariable.class);
    }

    public GamaPopulation(IMacroAgent iMacroAgent, ISpecies iSpecies) {
        super(0, iMacroAgent == null ? Types.get("experiment") : iMacroAgent.getModel().getDescription().getTypeNamed(iSpecies.getName()));
        Object object;
        this.host = iMacroAgent;
        this.species = iSpecies;
        SpeciesDescription speciesDescription = iSpecies.getDescription();
        IVariable[] iVariableArray = this.orderedVars = GamaPopulation.orderAttributes(this, speciesDescription, (com.google.common.base.Predicate<VariableDescription>)Predicates.alwaysTrue(), VariableDescription.INIT_DEPENDENCIES_FACETS);
        int n = this.orderedVars.length;
        int n2 = 0;
        while (n2 < n) {
            object = iVariableArray[n2];
            this.orderedVarNames.add(object.getName());
            ++n2;
        }
        this.updatableVars = GamaPopulation.orderAttributes(this, speciesDescription, (com.google.common.base.Predicate<VariableDescription>)((com.google.common.base.Predicate)VariableDescription::isUpdatable), VariableDescription.UPDATE_DEPENDENCIES_FACETS);
        this.mirrorManagement = iSpecies.isMirror() && iMacroAgent != null ? new MirrorPopulationManagement(iSpecies.getFacet("mirrors")) : null;
        this.hashCode = Objects.hash(this.getSpecies(), this.getHost());
        object = new boolean[2];
        iSpecies.getDescription().visitChildren(arg_0 -> GamaPopulation.lambda$4((boolean[])object, arg_0));
        this.isInitOverriden = object[0];
        this.isStepOverriden = object[1];
    }

    @Override
    public boolean step(IScope iScope) throws GamaRuntimeException {
        IExpression iExpression = this.species.getFrequency();
        if (iExpression != null) {
            int n = Cast.asInt(iScope, iExpression.value(iScope));
            int n2 = iScope.getClock().getCycle();
            if (n == 0 || n2 % n != 0) {
                return true;
            }
        }
        if (this.mirrorManagement != null) {
            this.mirrorManagement.executeOn(iScope);
        }
        this.getSpecies().getArchitecture().preStep(iScope, this);
        return this.stepAgents(iScope);
    }

    protected boolean stepAgents(IScope iScope) {
        return GamaExecutorService.step(iScope, this, this.getSpecies());
    }

    @Override
    public IList<T> listValue(IScope iScope, IType iType, boolean bl) {
        if (bl) {
            return GamaListFactory.create(iScope, iType, this);
        }
        return this;
    }

    @Override
    public IList<T> copy(IScope iScope) {
        return this.listValue(iScope, (IType)this.getGamlType().getContentType(), true);
    }

    @Override
    public void updateVariables(IScope iScope, IAgent iAgent) {
        IVariable[] iVariableArray = this.updatableVars;
        int n = this.updatableVars.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable iVariable = iVariableArray[n2];
            Throwable throwable = null;
            Object var8_9 = null;
            try (StopWatch stopWatch = GAMA.benchmark(iScope, iVariable);){
                iScope.setCurrentSymbol(iVariable);
                iScope.setAgentVarValue(iAgent, iVariable.getName(), iVariable.getUpdatedValue(iScope));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
        iScope.setCurrentSymbol(null);
    }

    @Override
    public boolean init(IScope iScope) {
        if (this.mirrorManagement != null) {
            this.mirrorManagement.executeOn(iScope);
        }
        return true;
    }

    @Override
    public void createVariablesFor(IScope iScope, T t) throws GamaRuntimeException {
        IVariable[] iVariableArray = this.orderedVars;
        int n = this.orderedVars.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable iVariable = iVariableArray[n2];
            iVariable.initializeWith(iScope, (IAgent)t, null);
            ++n2;
        }
    }

    @Override
    public T getAgent(Integer n) {
        return (T)((IAgent)Iterables.find((Iterable)this, iAgent -> iAgent.getIndex() == n.intValue(), null));
    }

    @Override
    public T getOrCreateAgent(IScope iScope, Integer n) {
        T t = this.getAgent(n);
        return t == null ? this.createAgentAt(iScope, n, Collections.EMPTY_MAP, false, true) : t;
    }

    @Override
    public int compareTo(IPopulation<T> iPopulation) {
        return this.getName().compareTo(iPopulation.getName());
    }

    @Override
    public ITopology getTopology() {
        return this.topology;
    }

    @Override
    public String getName() {
        return this.species.getName();
    }

    @Override
    public boolean isGrid() {
        return this.species.isGrid();
    }

    @Override
    public ISpecies getSpecies() {
        return this.species;
    }

    @Override
    public Iterable<T> iterable(IScope iScope) {
        return (Iterable)((Object)this.getAgents(iScope));
    }

    @Override
    public void dispose() {
        this.isDisposing = true;
        this.killMembers();
        IScope iScope = this.getHost() == null ? GAMA.getRuntimeScope() : this.getHost().getScope();
        this.firePopulationCleared(iScope);
        if (this.topology != null) {
            this.topology.dispose();
            this.topology = null;
        }
        this.clear();
    }

    @Override
    public T[] toArray() {
        return super.toArray(new IAgent[0]);
    }

    @Override
    public IList<T> createAgents(IScope iScope, IContainer<?, ? extends IShape> iContainer) {
        int n = iContainer.length(iScope);
        if (n == 0) {
            return GamaListFactory.EMPTY_LIST;
        }
        IList<IShape> iList = GamaListFactory.create(this.getGamlType().getContentType(), n);
        IAgentConstructor iAgentConstructor = this.species.getDescription().getAgentConstructor();
        for (IShape iShape : iContainer.iterable(iScope)) {
            Object t = iAgentConstructor.createOneAgent(this, this.currentAgentIndex++);
            t.setGeometry(iShape);
            iList.add((IShape)t);
        }
        this.addAll(iList);
        for (IAgent iAgent : iList) {
            iAgent.schedule(iScope);
        }
        this.createVariablesFor(iScope, iList, Collections.EMPTY_LIST);
        this.fireAgentsAdded(iScope, iList);
        return iList;
    }

    @Override
    public T createAgentAt(IScope iScope, int n, Map<String, Object> map, boolean bl, boolean bl2) throws GamaRuntimeException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        arrayList.add(map);
        int n2 = this.currentAgentIndex;
        this.currentAgentIndex = n;
        IList<T> iList = this.createAgents(iScope, 1, arrayList, bl, bl2, null);
        this.currentAgentIndex = n2;
        return (T)((IAgent)iList.firstValue(iScope));
    }

    @Override
    public IList<T> createAgents(IScope iScope, int n, List<? extends Map<String, Object>> list, boolean bl, boolean bl2, RemoteSequence remoteSequence) throws GamaRuntimeException {
        if (n == 0) {
            return GamaListFactory.EMPTY_LIST;
        }
        IList<IAgent> iList = GamaListFactory.create(this.getGamlType().getContentType(), n);
        IAgentConstructor iAgentConstructor = this.species.getDescription().getAgentConstructor();
        int n2 = 0;
        while (n2 < n) {
            Object t = iAgentConstructor.createOneAgent(this, this.currentAgentIndex++);
            if (list != null && !list.isEmpty()) {
                Map<String, Object> map = list.get(n2);
                Object object = map.get("shape");
                Object object2 = map.get("location");
                if (object != null) {
                    if (object instanceof GamaPoint) {
                        GamaPoint gamaPoint = (GamaPoint)object;
                        t.setGeometry(GamaShapeFactory.createFrom(gamaPoint));
                    } else {
                        t.setGeometry((IShape)object);
                    }
                    map.remove("shape");
                } else if (object2 != null) {
                    t.setLocation(iScope, (GamaPoint)object2);
                    map.remove("location");
                }
            }
            iList.add((IAgent)t);
            ++n2;
        }
        this.createVariablesFor(iScope, iList, list);
        this.addAll(iList);
        if (!bl) {
            for (IAgent iAgent : iList) {
                iAgent.schedule(iScope);
            }
            if (remoteSequence != null && !remoteSequence.isEmpty()) {
                for (IAgent iAgent : iList) {
                    if (!iScope.execute(remoteSequence, iAgent, null).passed() || iScope.getAndClearBreakStatus() == FlowStatus.BREAK) break;
                }
            }
        }
        this.fireAgentsAdded(iScope, iList);
        return iList;
    }

    public void createVariablesFor(IScope iScope, List<T> list, List<? extends Map<String, Object>> list2) throws GamaRuntimeException {
        if (list == null || list.isEmpty()) {
            return;
        }
        boolean bl = list2 == null || list2.isEmpty();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            IAgent iAgent = (IAgent)list.get(n);
            Map<String, Object> map = bl ? Collections.EMPTY_MAP : list2.get(n);
            IVariable[] iVariableArray = this.orderedVars;
            int n3 = this.orderedVars.length;
            int n4 = 0;
            while (n4 < n3) {
                IVariable iVariable = iVariableArray[n4];
                Object object2 = bl || !this.allowVarInitToBeOverridenByExternalInit(iVariable) ? null : map.get(iVariable.getName());
                iVariable.initializeWith(iScope, iAgent, object2);
                ++n4;
            }
            if (!bl) {
                map.forEach((? super K string, ? super V object) -> {
                    if (!this.orderedVarNames.contains(string)) {
                        iAgent.setAttribute((String)string, object);
                    }
                });
            }
            ++n;
        }
    }

    protected boolean allowVarInitToBeOverridenByExternalInit(IVariable iVariable) {
        return true;
    }

    @Override
    public void initializeFor(IScope iScope) throws GamaRuntimeException {
        this.computeTopology(iScope);
        if (this.topology != null) {
            this.topology.initialize(iScope, this);
        }
    }

    @Override
    public boolean hasVar(String string) {
        return this.species.getVar(string) != null;
    }

    @Override
    public boolean hasAspect(String string) {
        return this.species.hasAspect(string);
    }

    @Override
    public IExecutable getAspect(String string) {
        return this.species.getAspect(string);
    }

    @Override
    public Collection<String> getAspectNames() {
        return this.species.getAspectNames();
    }

    @Override
    public IVariable getVar(String string) {
        return this.species.getVar(string);
    }

    @Override
    public boolean hasUpdatableVariables() {
        return this.updatableVars.length > 0;
    }

    @Override
    public T getAgent(IScope iScope, GamaPoint gamaPoint) {
        IAgentFilter iAgentFilter = In.list(iScope, this);
        if (iAgentFilter == null) {
            return null;
        }
        return (T)(this.topology == null ? null : this.topology.getAgentClosestTo(iScope, gamaPoint, iAgentFilter));
    }

    protected void computeTopology(IScope iScope) throws GamaRuntimeException {
        boolean bl;
        IExpression iExpression = this.species.getFacet("topology");
        boolean bl2 = bl = this.species.isGraph() || this.species.isGrid();
        if (iExpression != null) {
            if (!bl) {
                this.topology = GamaTopologyType.staticCast(iScope, iScope.evaluate(iExpression, this.host).getValue(), false);
                return;
            }
            throw GamaRuntimeException.warning("Impossible to assign a topology to " + this.species.getName() + " as it already defines one.", iScope);
        }
        if (this.species.isGrid()) {
            this.topology = GridPopulation.buildGridTopology(iScope, this.species, this.getHost());
        } else if (this.species.isGraph()) {
            IExpression iExpression2 = this.species.getFacet("edge_species");
            String string = iExpression2 == null ? "base_edge" : iExpression2.literalValue();
            ISpecies iSpecies = iScope.getModel().getSpecies(string);
            IType iType = iScope.getType(string);
            IType<?> iType2 = this.getGamlType().getContentType();
            GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(GamaListFactory.EMPTY_LIST, false, false, false, new AbstractGraphNodeAgent.NodeRelation(), iSpecies, iScope, iType2, iType);
            this.addListener(gamaSpatialGraph);
            gamaSpatialGraph.postRefreshManagementAction(iScope);
            this.topology = new GraphTopology(iScope, (IShape)this.getHost(), gamaSpatialGraph);
        } else {
            this.topology = new ContinuousTopology(iScope, this.getHost());
        }
    }

    @Override
    public IMacroAgent getHost() {
        return this.host;
    }

    @Override
    public void setHost(IMacroAgent iMacroAgent) {
        this.host = iMacroAgent;
    }

    @Override
    public final boolean equals(Object object) {
        return object == this;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public void killMembers() throws GamaRuntimeException {
        IAgent[] iAgentArray;
        IAgent[] iAgentArray2 = iAgentArray = this.toArray();
        int n = iAgentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAgent iAgent = iAgentArray2[n2];
            if (iAgent != null) {
                iAgent.dispose();
            }
            ++n2;
        }
    }

    @Override
    public String toString() {
        return "Population of " + this.species.getName();
    }

    @Override
    public void addValue(IScope iScope, T t) {
        this.fireAgentAdded(iScope, (IAgent)t);
        this.add(t);
    }

    @Override
    public void addValueAtIndex(IScope iScope, Object object, T t) {
        this.fireAgentAdded(iScope, (IAgent)t);
        super.addValueAtIndex(iScope, object, t);
    }

    @Override
    public void addValues(IScope iScope, IContainer iContainer) {
        for (IAgent iAgent : iContainer.iterable(iScope)) {
            this.addValue(iScope, (T)iAgent);
        }
    }

    @Override
    public void removeValue(IScope iScope, Object object) {
        if (object instanceof IAgent && super.remove(object)) {
            if (this.topology != null) {
                this.topology.removeAgent((IAgent)object);
            }
            this.fireAgentRemoved(iScope, (IAgent)object);
        }
    }

    @Override
    public void removeValues(IScope iScope, IContainer iContainer) {
        for (Object ValueType : iContainer.iterable(iScope)) {
            this.removeValue(iScope, ValueType);
        }
    }

    @Override
    public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
        this.removeValue(iScope, object);
    }

    @Override
    public boolean remove(Object object) {
        this.removeValue(null, object);
        return true;
    }

    @Override
    public boolean contains(IScope iScope, Object object) {
        if (!(object instanceof IAgent)) {
            return false;
        }
        return ((IAgent)object).getPopulation() == this;
    }

    @Override
    public void addListener(IPopulation.Listener listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(IPopulation.Listener listener) {
        this.notifier.removeListener(listener);
    }

    protected void fireAgentAdded(IScope iScope, IAgent iAgent) {
        this.notifier.notifyAgentAdded(iScope, this, iAgent);
    }

    @Override
    public <T extends IAgent> void fireAgentsAdded(IScope iScope, IList<T> iList) {
        this.notifier.notifyAgentsAdded(iScope, this, iList);
    }

    protected void fireAgentRemoved(IScope iScope, IAgent iAgent) {
        this.notifier.notifyAgentRemoved(iScope, this, iAgent);
    }

    protected void firePopulationCleared(IScope iScope) {
        this.notifier.notifyPopulationCleared(iScope, this);
    }

    @Override
    public IContainer<?, ? extends IAgent> getAgents(IScope iScope) {
        return GamaListFactory.create(iScope, this.getGamlType().getContentType(), GamaPopulation.allLivingAgents(this));
    }

    @Override
    public boolean hasAgentList() {
        return true;
    }

    @Override
    public boolean accept(IScope iScope, IShape iShape, IShape iShape2) {
        IAgent iAgent = iShape2.getAgent();
        if (iAgent == null || iAgent.getPopulation() != this || iAgent.dead()) {
            return false;
        }
        IAgent iAgent2 = iShape.getAgent();
        return iAgent != iAgent2;
    }

    @Override
    public void filter(IScope iScope, IShape iShape2, Collection<? extends IShape> collection) {
        IAgent iAgent = iShape2 == null ? null : iShape2.getAgent();
        collection.remove(iAgent);
        com.google.common.base.Predicate predicate = iShape -> {
            IAgent iAgent = iShape.getAgent();
            return iAgent == null || iAgent.dead() || iAgent.getPopulation() != this && (iAgent.getPopulation().getGamlType().getContentType() != this.getGamlType().getContentType() || !this.contains(iAgent));
        };
        collection.removeIf((Predicate<? extends IShape>)predicate);
    }

    @Override
    public Collection<? extends IPopulation<? extends IAgent>> getPopulations(IScope iScope) {
        return Collections.singleton(this);
    }

    @Override
    public T getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        if (iList == null) {
            return null;
        }
        int n = iList.size();
        return (T)(switch (n) {
            case 0 -> null;
            case 1 -> (IAgent)super.getFromIndicesList(iScope, iList);
            case 2 -> this.getAgent(iScope, new GamaPoint(Cast.asFloat(iScope, iList.get(0)), Cast.asFloat(iScope, iList.get(1))));
            default -> throw GamaRuntimeException.error("Populations cannot be accessed with 3 or more indexes", iScope);
        });
    }

    public static <T extends IAgent> Iterable<T> allLivingAgents(Iterable<T> iterable) {
        return Iterables.filter(iterable, (com.google.common.base.Predicate)isLiving);
    }

    @Override
    public boolean isInitOverriden() {
        return this.isInitOverriden;
    }

    @Override
    public boolean isStepOverriden() {
        return this.isStepOverriden;
    }

    private static /* synthetic */ boolean lambda$4(boolean[] blArray, IDescription iDescription) {
        if (iDescription instanceof ActionDescription && !iDescription.isBuiltIn()) {
            String string = iDescription.getName();
            if ("_init_".equals(string)) {
                blArray[0] = true;
            } else if ("_step_".equals(string)) {
                blArray[1] = true;
            }
        }
        return true;
    }

    class MirrorPopulationManagement
    implements IExecutable {
        final IExpression listOfTargetAgents;

        MirrorPopulationManagement(IExpression iExpression) {
            this.listOfTargetAgents = iExpression;
        }

        @Override
        public Object executeOn(IScope iScope) throws GamaRuntimeException {
            Object object2;
            GamaPopulation gamaPopulation = GamaPopulation.this;
            HashSet hashSet = new HashSet(Cast.asList(iScope, this.listOfTargetAgents.value(iScope)));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object2 : gamaPopulation.iterable(iScope)) {
                IAgent iAgent = Cast.asAgent(iScope, object2.getAttribute("target"));
                if (hashSet.contains(iAgent)) {
                    hashSet.remove(iAgent);
                    continue;
                }
                arrayList.add(object2);
            }
            for (Object object2 : arrayList) {
                object2.dispose();
            }
            object2 = new ArrayList();
            for (Object object3 : hashSet) {
                IMap iMap = GamaMapFactory.createUnordered();
                iMap.put("target", object3);
                object2.add(iMap);
            }
            return gamaPopulation.createAgents(iScope, hashSet.size(), (List<Map<String, Object>>)object2, false, true, null);
        }
    }
}

