/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.metamodel.topology.grid.INeighborhood;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class NoCacheNeighborhood
implements INeighborhood {
    private final GamaSpatialMatrix matrix;

    public NoCacheNeighborhood(GamaSpatialMatrix gamaSpatialMatrix) {
        this.matrix = gamaSpatialMatrix;
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<IAgent> getNeighborsIn(IScope iScope, int n, int n2) {
        return this.computeNeighborsFrom(iScope, n, 1, n2);
    }

    private Set<IAgent> computeNeighborsFrom(IScope iScope, int n, int n2, int n3) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            int n4 = n2;
            while (n4 <= n3) {
                for (Integer n5 : this.matrix.usesVN != false ? this.get4NeighborsAtRadius(n, n4) : this.get8NeighborsAtRadius(n, n4)) {
                    asOrderedSet.add(this.matrix.matrix[n5].getAgent());
                }
                ++n4;
            }
            asOrderedSet.shuffleInPlaceWith(iScope.getRandom());
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected List<Integer> get8NeighborsAtRadius(int n, int n2) {
        int n3;
        int n4 = n / this.matrix.numCols;
        int n5 = n - n4 * this.matrix.numCols;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 + 1 * n2 + 1);
        int n6 = 1 - n2;
        while (n6 < n2) {
            n3 = this.matrix.getPlaceIndexAt(n5 + n6, n4 - n2);
            if (n3 != -1) {
                arrayList.add(n3);
            }
            if ((n3 = this.matrix.getPlaceIndexAt(n5 - n6, n4 + n2)) != -1) {
                arrayList.add(n3);
            }
            ++n6;
        }
        n6 = -n2;
        while (n6 < n2 + 1) {
            n3 = this.matrix.getPlaceIndexAt(n5 - n2, n4 - n6);
            if (n3 != -1) {
                arrayList.add(n3);
            }
            if ((n3 = this.matrix.getPlaceIndexAt(n5 + n2, n4 + n6)) != -1) {
                arrayList.add(n3);
            }
            ++n6;
        }
        return arrayList;
    }

    protected List<Integer> get4NeighborsAtRadius(int n, int n2) {
        int n3 = n / this.matrix.numCols;
        int n4 = n - n3 * this.matrix.numCols;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 << 2);
        int n5 = -n2;
        while (n5 < n2) {
            int n6 = this.matrix.getPlaceIndexAt(n4 - n5, n3 - Math.abs(n5) + n2);
            if (n6 != -1) {
                arrayList.add(n6);
            }
            if ((n6 = this.matrix.getPlaceIndexAt(n4 + n5, n3 + Math.abs(n5) - n2)) != -1) {
                arrayList.add(n6);
            }
            ++n5;
        }
        return arrayList;
    }

    @Override
    public boolean isVN() {
        return false;
    }

    @Override
    public int[] getRawNeighborsIncluding(IScope iScope, int n, int n2) {
        throw GamaRuntimeException.warning("The diffusion of signals must rely on a neighbors cache in the grid", iScope);
    }

    @Override
    public int neighborsIndexOf(IScope iScope, int n, int n2) {
        throw GamaRuntimeException.warning("The diffusion of signals must rely on a neighbors cache in the grid", iScope);
    }
}

