/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.GamaGraphFile;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.loader.GamaGraphMLEdgeImporter;
import gama.core.util.graph.loader.GamaGraphMLNodeImporter;
import gama.core.util.graph.loader.GraphImporters;
import gama.gaml.species.ISpecies;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.nio.GraphImporter;
import org.jgrapht.nio.graphml.GraphMLImporter;

@GamlAnnotations.file(name="graphml", extensions={"graphml"}, buffer_type=15, concept={"graph", "file"}, doc={@GamlAnnotations.doc(value="Represents files that contain Graph information. The internal representation is a graph")})
public class GamaGraphMLFile
extends GamaGraphFile {
    String nodeAttr = null;
    String edgeAttr = null;

    @GamlAnnotations.doc(value="References a graphml graph file by its filename")
    public GamaGraphMLFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    @GamlAnnotations.doc(value="References a graphml graph file by its filename and the species to use to instantiate the nodes")
    public GamaGraphMLFile(IScope iScope, String string, ISpecies iSpecies) {
        super(iScope, string, iSpecies);
    }

    @GamlAnnotations.doc(value="References a graphml graph file by its filename and the 2 species to use to instantiate the nodes and the edges")
    public GamaGraphMLFile(IScope iScope, String string, ISpecies iSpecies, ISpecies iSpecies2) {
        super(iScope, string, iSpecies, iSpecies2);
    }

    @GamlAnnotations.doc(value="References a graphml graph file by its filename and the 2 species to use to instantiate the nodes and the edges")
    public GamaGraphMLFile(IScope iScope, String string, ISpecies iSpecies, ISpecies iSpecies2, String string2, String string3) {
        super(iScope, string, iSpecies, iSpecies2);
        this.nodeAttr = string2;
        this.edgeAttr = string3;
    }

    @Override
    protected String getFileType() {
        return "graphml";
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        GraphImporter graphImporter = GraphImporters.getGraphImporter(this.getFileType());
        if (!(graphImporter instanceof GraphMLImporter)) {
            throw GamaRuntimeException.error("GraphML: Wrong importer loaded in fillBuffer", iScope);
        }
        GraphMLImporter graphMLImporter = (GraphMLImporter)graphImporter;
        graphMLImporter.addVertexAttributeConsumer((pair, attribute) -> {
            GamaGraphMLNodeImporter gamaGraphMLNodeImporter = (GamaGraphMLNodeImporter)pair.getFirst();
            String string = (String)pair.getSecond();
            gamaGraphMLNodeImporter.addAttribute(string, attribute.getValue());
        });
        graphMLImporter.addEdgeAttributeConsumer((pair, attribute) -> {
            GamaGraphMLEdgeImporter gamaGraphMLEdgeImporter = (GamaGraphMLEdgeImporter)((Object)((Object)pair.getFirst()));
            String string = (String)pair.getSecond();
            gamaGraphMLEdgeImporter.addAttribute(string, attribute.getValue());
        });
        DirectedMultigraph directedMultigraph = new DirectedMultigraph((Supplier)new GamaGraphMLNodeImporterSupplier(), (Supplier)new GamaGraphMLEdgeImporterSupplier(), true);
        graphMLImporter.importGraph((Graph)directedMultigraph, this.getFile(iScope));
        GamaGraph gamaGraph = new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, this.nodeS, this.edgeS, this.nodeAttr, this.edgeAttr);
        this.setBuffer(gamaGraph);
    }

    static class GamaGraphMLEdgeImporterSupplier
    implements Supplier<GamaGraphMLEdgeImporter> {
        GamaGraphMLEdgeImporterSupplier() {
        }

        @Override
        public GamaGraphMLEdgeImporter get() {
            return new GamaGraphMLEdgeImporter();
        }
    }

    static class GamaGraphMLNodeImporterSupplier
    implements Supplier<GamaGraphMLNodeImporter> {
        private int id = 0;

        GamaGraphMLNodeImporterSupplier() {
        }

        @Override
        public GamaGraphMLNodeImporter get() {
            return new GamaGraphMLNodeImporter(String.valueOf(this.id++));
        }
    }
}

