/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.runtime.IScope;
import gama.core.util.file.json.JsonValue;
import gama.core.util.file.json.JsonWriter;
import java.io.IOException;

class JsonInt
extends JsonValue {
    private final String string;

    JsonInt(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        this.string = string;
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    void write(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeNumber(this.string);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public int asInt() {
        return Integer.parseInt(this.string, 10);
    }

    @Override
    public long asLong() {
        return this.asInt();
    }

    @Override
    public float asFloat() {
        return this.asInt();
    }

    @Override
    public double asDouble() {
        return this.asInt();
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JsonInt jsonInt = (JsonInt)object;
        return this.string.equals(jsonInt.string);
    }

    @Override
    public Number toGamlValue(IScope iScope) {
        return this.asInt();
    }
}

