/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import gama.annotations.precompiler.GamlAnnotations;
import gama.dev.DEBUG;
import gama.gaml.compilation.IGamaHelper;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Strings;
import gama.gaml.statements.Facets;
import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class PrimitiveDescription
extends ActionDescription {
    private IGamaHelper helper;
    private AccessibleObject method;
    private String plugin;
    private IGamlDescription.RegularDoc documentation;

    static {
        DEBUG.OFF();
    }

    public PrimitiveDescription(IDescription iDescription, EObject eObject, Iterable<IDescription> iterable, Facets facets2, String string) {
        super("primitive", iDescription, iterable, eObject, facets2);
        this.plugin = string;
    }

    public boolean visitOwnChildrenRecursively(IDescription.DescriptionVisitor descriptionVisitor) {
        return true;
    }

    public boolean visitChildren(IDescription.DescriptionVisitor descriptionVisitor) {
        return true;
    }

    public boolean visitOwnChildren(IDescription.DescriptionVisitor descriptionVisitor) {
        return true;
    }

    @Override
    public String getDefiningPlugin() {
        return this.plugin;
    }

    @Override
    public boolean validateChildren() {
        return true;
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        if (this.documentation != null) {
            return this.documentation;
        }
        String string = this.getBuiltInDoc();
        this.documentation = new IGamlDescription.RegularDoc(string);
        if (this.getArgNames().size() > 0) {
            Map<String, GamlAnnotations.arg> map = this.getArgs();
            this.getFormalArgs().forEach(iDescription -> {
                GamlAnnotations.arg arg2;
                StringBuilder stringBuilder = new StringBuilder(100);
                String string = iDescription.getName();
                stringBuilder.append(iDescription.getGamlType());
                if (iDescription.hasFacet("default") && iDescription.getFacetExpr("default") != null) {
                    stringBuilder.append(" <i>(default: ").append(iDescription.getFacetExpr("default").serializeToGaml(false)).append(")</i>");
                }
                if ((arg2 = (GamlAnnotations.arg)map.get(string)) != null && arg2.doc().length > 0) {
                    stringBuilder.append("; ").append(arg2.doc()[0].value());
                }
                this.documentation.set("Arguments accepted: ", string, new IGamlDescription.ConstantDoc(stringBuilder.toString()));
            });
        }
        return this.documentation;
    }

    public String getDeprecated() {
        GamlAnnotations.doc doc2 = this.getDocAnnotation();
        if (doc2 == null) {
            return null;
        }
        String string = doc2.deprecated();
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    @Override
    public String getBuiltInDoc() {
        GamlAnnotations.doc doc2 = this.getDocAnnotation();
        Object object = doc2 == null ? "" : (doc2.deprecated().isEmpty() ? doc2.value() + Strings.LN : doc2.value() + Strings.LN + Strings.LN + doc2.deprecated() + Strings.LN);
        return object;
    }

    public GamlAnnotations.doc getDocAnnotation() {
        GamlAnnotations.doc[] docArray;
        GamlAnnotations.doc doc2 = null;
        if (this.method != null && this.method.isAnnotationPresent(GamlAnnotations.doc.class)) {
            doc2 = this.method.getAnnotation(GamlAnnotations.doc.class);
        } else if (this.method != null && this.method.isAnnotationPresent(GamlAnnotations.action.class) && (docArray = this.method.getAnnotation(GamlAnnotations.action.class).doc()).length > 0) {
            doc2 = docArray[0];
        }
        return doc2;
    }

    public Map<String, GamlAnnotations.arg> getArgs() {
        if (this.method == null || !this.method.isAnnotationPresent(GamlAnnotations.action.class)) {
            return Collections.EMPTY_MAP;
        }
        GamlAnnotations.action action2 = this.method.getAnnotation(GamlAnnotations.action.class);
        GamlAnnotations.arg[] argArray = action2.args();
        if (argArray.length == 0) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, GamlAnnotations.arg> linkedHashMap = new LinkedHashMap<String, GamlAnnotations.arg>();
        GamlAnnotations.arg[] argArray2 = argArray;
        int n = argArray.length;
        int n2 = 0;
        while (n2 < n) {
            GamlAnnotations.arg arg2 = argArray2[n2];
            linkedHashMap.put(arg2.name(), arg2);
            ++n2;
        }
        return linkedHashMap;
    }

    public IGamaHelper getHelper() {
        return this.helper;
    }

    @Override
    public PrimitiveDescription validate() {
        return this;
    }

    public void setHelper(IGamaHelper iGamaHelper, AccessibleObject accessibleObject) {
        this.helper = iGamaHelper;
        this.method = accessibleObject;
    }

    @Override
    public PrimitiveDescription copy(IDescription iDescription) {
        return this;
    }

    @Override
    public void setDefiningPlugin(String string) {
        this.plugin = string;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setEnclosingDescription(IDescription iDescription) {
    }
}

