/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.operators.AbstractNAryOperator;
import gama.gaml.expressions.types.TypeExpression;
import gama.gaml.expressions.variables.VariableExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import java.lang.reflect.Method;
import java.util.Arrays;

public class BinaryOperator
extends AbstractNAryOperator {
    public static IExpression create(OperatorProto operatorProto, IDescription iDescription, IExpression ... iExpressionArray) {
        return new BinaryOperator(operatorProto, iDescription, iExpressionArray).optimized();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        if ("as".equals(this.getName()) && this.exprs[1] instanceof TypeExpression) {
            IType<?> iType = this.exprs[1].getDenotedType();
            IGamlDescription.Doc doc2 = this.findDocOnType(iType);
            if (doc2 == null) {
                doc2 = this.findDocOnType(iType.getGamlType());
            }
            if (doc2 != null) {
                return doc2;
            }
        }
        return super.getDocumentation();
    }

    private IGamlDescription.Doc findDocOnType(IType iType) {
        Class<?> clazz = iType.getClass();
        GamlAnnotations.doc doc2 = null;
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("cast", IScope.class, Object.class, Object.class, Boolean.TYPE);
            if (method != null) {
                doc2 = method.getAnnotation(GamlAnnotations.doc.class);
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {}
        if (doc2 == null) {
            try {
                method = clazz.getDeclaredMethod("cast", IScope.class, Object.class, Object.class, IType.class, IType.class, Boolean.TYPE);
                if (method != null) {
                    doc2 = method.getAnnotation(GamlAnnotations.doc.class);
                }
            }
            catch (NoSuchMethodException | SecurityException exception) {}
        }
        if (doc2 != null) {
            GamlAnnotations.usage[] usageArray;
            IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc(new StringBuilder(200));
            String string = doc2.value();
            if (string != null && !string.isEmpty()) {
                regularDoc.append(string).append("<br/>");
            }
            GamlAnnotations.usage[] usageArray2 = usageArray = doc2.usages();
            int n = usageArray.length;
            int n2 = 0;
            while (n2 < n) {
                GamlAnnotations.usage usage2 = usageArray2[n2];
                regularDoc.append(usage2.value()).append("<br/>");
                ++n2;
            }
            string = doc2.deprecated();
            if (string != null && !string.isEmpty()) {
                regularDoc.append("<b>Deprecated</b>: ").append("<i>").append(string).append("</i><br/>");
            }
            return regularDoc;
        }
        return null;
    }

    public BinaryOperator(OperatorProto operatorProto, IDescription iDescription, IExpression ... iExpressionArray) {
        super(operatorProto, iExpressionArray);
        this.prototype.verifyExpectedTypes(iDescription, this.exprs[1].getGamlType());
    }

    @Override
    public String serializeToGaml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getName();
        if ("internal_at".equals(string)) {
            stringBuilder.append(this.exprs[0].serializeToGaml(bl)).append(this.exprs[1].serializeToGaml(bl));
        } else if (OperatorProto.binaries.contains(string)) {
            BinaryOperator.parenthesize(stringBuilder, this.exprs[0]);
            stringBuilder.append(' ').append(string).append(' ');
            BinaryOperator.parenthesize(stringBuilder, this.exprs[1]);
        } else if ("as".equals(string)) {
            stringBuilder.append(this.exprs[1].serializeToGaml(false)).append("(").append(this.exprs[0].serializeToGaml(bl)).append(")");
        } else {
            stringBuilder.append(string);
            BinaryOperator.parenthesize(stringBuilder, this.exprs[0], this.exprs[1]);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean shouldBeParenthesized() {
        String string = this.getName();
        if (".".equals(string) || ":".equals(string)) {
            return false;
        }
        return OperatorProto.binaries.contains(this.getName());
    }

    @Override
    public Object _value(IScope iScope) throws GamaRuntimeException {
        IExpression iExpression = null;
        IExpression iExpression2 = null;
        try {
            iExpression = this.prototype.getLazyness()[0] ? this.exprs[0] : this.exprs[0].value(iScope);
            iExpression2 = this.prototype.getLazyness()[1] ? this.exprs[1] : this.exprs[1].value(iScope);
            return this.prototype.getHelper().get(iScope, iExpression, iExpression2);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            throw gamaRuntimeException;
        }
        catch (Throwable throwable) {
            GamaRuntimeException gamaRuntimeException = GamaRuntimeException.create(throwable, iScope);
            gamaRuntimeException.addContext("when applying the " + this.literalValue() + " operator on " + StringUtils.toGaml(iExpression, false) + " and " + StringUtils.toGaml(iExpression2, false));
            throw gamaRuntimeException;
        }
    }

    @Override
    public BinaryOperator copy() {
        if (this.exprs == null) {
            return new BinaryOperator(this.prototype, null, new IExpression[0]);
        }
        return new BinaryOperator(this.prototype, null, Arrays.copyOf(this.exprs, this.exprs.length));
    }

    public static class BinaryVarOperator
    extends BinaryOperator
    implements IVarExpression.Agent {
        IDescription definitionDescription;

        public BinaryVarOperator(OperatorProto operatorProto, IDescription iDescription, IExpression iExpression, IVarExpression iVarExpression) {
            super(operatorProto, iDescription, iExpression, iVarExpression);
            this.definitionDescription = iDescription;
        }

        @Override
        public void setVal(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
            IAgent iAgent = Cast.asAgent(iScope, this.exprs[0].value(iScope));
            if (iAgent == null || iAgent.dead()) {
                return;
            }
            iScope.setAgentVarValue(iAgent, this.exprs[1].literalValue(), object);
        }

        @Override
        public IExpression getOwner() {
            return this.exprs[0];
        }

        @Override
        public VariableExpression getVar() {
            return (VariableExpression)this.exprs[1];
        }

        @Override
        public IDescription getDefinitionDescription() {
            return this.definitionDescription;
        }

        @Override
        public boolean isNotModifiable() {
            return ((IVarExpression)this.exprs[1]).isNotModifiable();
        }

        @Override
        public String serializeToGaml(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            BinaryVarOperator.parenthesize(stringBuilder, this.exprs[0]);
            stringBuilder.append('.');
            stringBuilder.append(this.exprs[1].serializeToGaml(bl));
            return stringBuilder.toString();
        }

        @Override
        public boolean isContextIndependant() {
            return false;
        }

        @Override
        public boolean isAllowedInParameters() {
            return true;
        }

        @Override
        public BinaryVarOperator copy() {
            return new BinaryVarOperator(this.prototype, null, this.exprs[0], (IVarExpression)this.exprs[1]);
        }
    }
}

