/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.gaml.compilation.IOperatorValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.IType;
import org.eclipse.emf.ecore.EObject;
import org.locationtech.jts.index.quadtree.IntervalSize;

public class Comparison {
    public static final String GT = ">";
    public static final String LT = "<";
    public static final String GTE = ">=";
    public static final String LTE = "<=";

    @GamlAnnotations.operator(value={"between"}, can_be_const=true, category={"Comparison operators"}, concept={"comparison"})
    @GamlAnnotations.doc(value="returns true the first operand is bigger than the second operand and smaller than the third operand", masterDoc=true, examples={@GamlAnnotations.example(value="between(5, 1, 10)", equals="true")})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="0 between(-2,4) = true"), @GamlAnnotations.test(value="-12 between(-22,-10)"), @GamlAnnotations.test(value="not(1 between(1,4))"), @GamlAnnotations.test(value="not(2 between(4,1))")})
    public static Boolean between(Integer n, Integer n2, Integer n3) {
        if (n2 > n3) {
            return false;
        }
        return n >= n3 ? false : n > n2;
    }

    @GamlAnnotations.operator(value={"between"}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="returns true if the first float operand is bigger than the second float operand and smaller than the third float operand", examples={@GamlAnnotations.example(value="between(5.0, 1.0, 10.0)", equals="true")})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="0.0 between(-2,4)"), @GamlAnnotations.test(value="-12.5 between(-22.0,-10.0)"), @GamlAnnotations.test(value="not(1.0 between(1.0,4.0))"), @GamlAnnotations.test(value="not(2.2 between(4.0,1.9))")})
    public static Boolean between(Double d, Double d2, Double d3) {
        if (d2 > d3) {
            return false;
        }
        return d >= d3 ? false : d > d2;
    }

    @GamlAnnotations.operator(value={">"}, can_be_const=true, category={"Comparison operators"}, concept={"comparison"})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater than the right-hand operand, false otherwise.", masterDoc=true, usages={@GamlAnnotations.usage(value="if one of the operands is nil, returns false")}, examples={@GamlAnnotations.example(value="13.0 > 7.0", equals="true")}, see={"<", ">=", "<=", "=", "!="})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="bool val <- (3 > 17); val = false "), @GamlAnnotations.test(value="val <- (13 > 7); val = true")})
    public static Boolean greater(Integer n, Integer n2) {
        if (n == null || n2 == null) {
            return false;
        }
        if (n > n2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">"}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3 > 2.5", equals="true")})
    public static Boolean greater(Integer n, Double d) {
        if (n == null || d == null) {
            return false;
        }
        if ((double)n.intValue() > d) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">"}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3.5 > 7", equals="false")})
    public static Boolean greater(Double d, Integer n) {
        if (d == null || n == null) {
            return false;
        }
        if (d > (double)n.intValue()) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">"}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3.5 > 7.6", equals="false")})
    public static Boolean greater(Double d, Double d2) {
        if (d == null || d2 == null) {
            return false;
        }
        if (d > d2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<"}, can_be_const=true, category={"Comparison operators"}, concept={"comparison"})
    @GamlAnnotations.doc(value="true if the left-hand operand is less than the right-hand operand, false otherwise.", masterDoc=true, special_cases={"if one of the operands is nil, returns false"}, examples={@GamlAnnotations.example(value="3 < 7", equals="true")}, see={">", ">=", "<=", "=", "!="})
    public static Boolean less(Integer n, Integer n2) {
        if (n == null || n2 == null) {
            return false;
        }
        if (n < n2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<"}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is less than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3 < 2.5", equals="false")})
    public static Boolean less(Integer n, Double d) {
        if (n == null || d == null) {
            return false;
        }
        if ((double)n.intValue() < d) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<"}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is less than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3.5 < 7", equals="true")})
    public static Boolean less(Double d, Integer n) {
        if (d == null || n == null) {
            return false;
        }
        if (d < (double)n.intValue()) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<"}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is less than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3.5 < 7.6", equals="true")})
    public static Boolean less(Double d, Double d2) {
        if (d == null || d2 == null) {
            return false;
        }
        if (d < d2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">="}, can_be_const=true, category={"Comparison operators"}, concept={"comparison"})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater or equal than the right-hand operand, false otherwise.", masterDoc=true, usages={@GamlAnnotations.usage(value="if one of the operands is nil, returns false")}, examples={@GamlAnnotations.example(value="3 >= 7", equals="false")}, see={">", "<", "<=", "=", "!="})
    public static Boolean greaterOrEqual(Integer n, Integer n2) {
        if (n == null || n2 == null) {
            return false;
        }
        if (n >= n2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater or equal than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3 >= 2.5", equals="true")})
    public static Boolean greaterOrEqual(Integer n, Double d) {
        if (n == null || d == null) {
            return false;
        }
        if ((double)n.intValue() >= d) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater or equal than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3.5 >= 7", equals="false")})
    public static Boolean greaterOrEqual(Double d, Integer n) {
        if (d == null || n == null) {
            return false;
        }
        if (d >= (double)n.intValue()) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater or equal than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3.5 >= 3.5", equals="true")})
    public static Boolean greaterOrEqual(Double d, Double d2) {
        if (d == null || d2 == null) {
            return false;
        }
        if (d >= d2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is less or equal than the right-hand operand, false otherwise.", masterDoc=true, usages={@GamlAnnotations.usage(value="if one of the operands is nil, returns false")}, examples={@GamlAnnotations.example(value="3 <= 7", equals="true")})
    public static Boolean opLessThanOrEqual(Integer n, Integer n2) {
        if (n == null || n2 == null) {
            return false;
        }
        if (n <= n2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is less or equal than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3 <= 2.5", equals="false")}, see={">", "<", ">=", "=", "!="})
    public static Boolean lessOrEqual(Integer n, Double d) {
        if (n == null || d == null) {
            return false;
        }
        if ((double)n.intValue() <= d) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is less or equal than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="7.0 <= 7", equals="true")})
    public static Boolean lessOrEqual(Double d, Integer n) {
        if (d == null || n == null) {
            return false;
        }
        if (d <= (double)n.intValue()) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="true if the left-hand operand is less or equal than the right-hand operand, false otherwise.", examples={@GamlAnnotations.example(value="3.5 <= 3.5", equals="true")})
    public static Boolean lessOrEqual(Double d, Double d2) {
        if (d == null || d2 == null) {
            return false;
        }
        if (d <= d2) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"="}, can_be_const=true, category={"Comparison operators"}, concept={"comparison"})
    @GamlAnnotations.doc(value="returns true if both operands are equal, false otherwise", masterDoc=true, examples={@GamlAnnotations.example(value="4.5 = 4.7", equals="false")}, see={">", "<", ">=", "<=", "!="})
    public static Boolean equal(Double d, Double d2) {
        return d == null ? d2 == null : IntervalSize.isZeroWidth((double)d, (double)d2);
    }

    @GamlAnnotations.operator(value={"="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="returns true if both operands are equal, false otherwise", masterDoc=true, examples={@GamlAnnotations.example(value="4 = 5", equals="false")}, see={"!="})
    public static Boolean equal(Integer n, Integer n2) {
        return n == null ? n2 == null : n.intValue() == n2.intValue();
    }

    @GamlAnnotations.operator(value={"="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="returns true if both operands are equal, false otherwise", examples={@GamlAnnotations.example(value="3 = 3.0", equals="true"), @GamlAnnotations.example(value="4 = 4.7", equals="false")}, see={"!="})
    public static Boolean equal(Integer n, Double d) {
        return n == null ? d == null : IntervalSize.isZeroWidth((double)n.doubleValue(), (double)d);
    }

    @GamlAnnotations.operator(value={"="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="returns true if both operands are equal, false otherwise", examples={@GamlAnnotations.example(value="4.7 = 4", equals="false")}, see={"!="})
    public static Boolean equal(Double d, Integer n) {
        return d == null ? n == null : IntervalSize.isZeroWidth((double)d, (double)n.doubleValue());
    }

    @GamlAnnotations.operator(value={"!="}, can_be_const=true, category={"Comparison operators"}, concept={"comparison"})
    @GamlAnnotations.doc(value="true if both operands are different, false otherwise", masterDoc=true, examples={@GamlAnnotations.example(value="3.0 != 3.0", equals="false"), @GamlAnnotations.example(value="4.0 != 4.7", equals="true")}, see={"=", ">", "<", ">=", "<=", "="})
    public static Boolean different(Double d, Double d2) {
        if (d == null) {
            if (d2 != null) {
                return true;
            }
            return false;
        }
        if (d2 == null) {
            return false;
        }
        return !IntervalSize.isZeroWidth((double)d, (double)d2);
    }

    @GamlAnnotations.operator(value={"!="}, can_be_const=true, category={"Comparison operators"}, concept={"comparison"})
    @GamlAnnotations.doc(value="true if both operands are different, false otherwise", masterDoc=true, examples={@GamlAnnotations.example(value="3 != 3", equals="false"), @GamlAnnotations.example(value="4 != 5", equals="true")}, see={"=", ">", "<", ">=", "<=", "="})
    public static Boolean different(Integer n, Integer n2) {
        if (n == null) {
            if (n2 != null) {
                return true;
            }
            return false;
        }
        if (n2 == null) {
            return false;
        }
        if (n.intValue() != n2.intValue()) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"!="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="returns true if both operands are different, false otherwise", examples={@GamlAnnotations.example(value="3 != 3.0", equals="false"), @GamlAnnotations.example(value="4 != 4.7", equals="true")}, see={"="})
    public static Boolean different(Integer n, Double d) {
        return n == null ? d == null : !IntervalSize.isZeroWidth((double)n.doubleValue(), (double)d);
    }

    @GamlAnnotations.operator(value={"!="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value="returns true if both operands are different, false otherwise", examples={@GamlAnnotations.example(value="3.0 != 3", equals="false"), @GamlAnnotations.example(value="4.7 != 4", equals="true")}, see={"="})
    public static Boolean different(Double d, Integer n) {
        return d == null ? n == null : !IntervalSize.isZeroWidth((double)d, (double)n.doubleValue());
    }

    @GamlAnnotations.operator(value={"<="}, can_be_const=true, category={"Comparison operators", "Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns true if the left-hand operand is smaller than or equal to the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are String, uses a lexicographic comparison of two strings", examples={@GamlAnnotations.example(value="'abc' <= 'aeb'", equals="true")})})
    public static Boolean lessOrEqual(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = string.compareTo(string2);
        if (n <= 0) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">="}, can_be_const=true, category={"Comparison operators", "Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns true if the left-hand operand is greater than or equal to the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are string, uses a lexicographic comparison of the two strings", examples={@GamlAnnotations.example(value="'abc' >= 'aeb'", equals="false"), @GamlAnnotations.example(value="'abc' >= 'abc'", equals="true")})})
    public static Boolean greaterOrEqual(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = string.compareTo(string2);
        if (n >= 0) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<"}, can_be_const=true, category={"Comparison operators", "Strings-related operators"}, concept={})
    @GamlAnnotations.doc(value="A lexicographic comparison of two strings. Returns true if the left-hand operand is smaller than the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are String, uses a lexicographic comparison of two strings", examples={@GamlAnnotations.example(value="'abc' < 'aeb'", equals="true")})})
    public static Boolean less(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = string.compareTo(string2);
        if (n < 0) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">"}, can_be_const=true, category={"Comparison operators", "Strings-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns true if the left-hand operand is greater than the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are String, uses a lexicographic comparison of two strings", examples={@GamlAnnotations.example(value="'abc' > 'aeb'", equals="false")})})
    public static Boolean greater(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = string.compareTo(string2);
        if (n > 0) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @validator(value=EqualValidator.class)
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if both operands are any kind of objects, returns true if they are identical (i.e., the same object) or equal (comparisons between nil values are permitted)", examples={@GamlAnnotations.example(value="[2,3] = [2,3]", equals="true")})})
    public static Boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    @GamlAnnotations.operator(value={"!="}, can_be_const=true, category={"Comparison operators"}, concept={})
    @GamlAnnotations.doc(value=" Returns false if the two operands are identical (i.e., the same object) or equal. Comparisons between nil values are permitted.", examples={@GamlAnnotations.example(value="[2,3] != [2,3]", equals="false"), @GamlAnnotations.example(value="[2,4] != [2,3]", equals="true")})
    public static Boolean different(Object object, Object object2) {
        return object == null ? object2 != null : !object.equals(object2);
    }

    @GamlAnnotations.operator(value={"<"}, can_be_const=true, category={"Comparison operators", "Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="true if the left-hand operand is lower than the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are points, returns true if and only if the left component (x) of the left operand if less than or equal to x of the right one and if the right component (y) of the left operand is greater than or equal to y of the right one.", examples={@GamlAnnotations.example(value="{5,7} < {4,6}", equals="false"), @GamlAnnotations.example(value="{5,7} < {4,8}", equals="false")})})
    public static Boolean less(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint.x < gamaPoint2.x && gamaPoint.y < gamaPoint2.y) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">"}, can_be_const=true, category={"Comparison operators", "Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater than the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are points, returns true if and only if the left component (x) of the left operand if greater than x of the right one and if the right component (y) of the left operand is greater than y of the right one.", examples={@GamlAnnotations.example(value="{5,7} > {4,6}", equals="true"), @GamlAnnotations.example(value="{5,7} > {4,8}", equals="false")})})
    public static Boolean greater(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint.x > gamaPoint2.x && gamaPoint.y > gamaPoint2.y) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"<="}, can_be_const=true, category={"Comparison operators", "Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="true if the left-hand operand is lower or equals than the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are points, returns true if and only if the left component (x) of the left operand if less than or equal to x of the right one and if the right component (y) of the left operand is greater than or equal to y of the right one.", examples={@GamlAnnotations.example(value="{5,7} <= {4,6}", equals="false"), @GamlAnnotations.example(value="{5,7} <= {4,8}", equals="false")})})
    public static Boolean lessOrEqual(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint.x <= gamaPoint2.x && gamaPoint.y <= gamaPoint2.y) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={">="}, can_be_const=true, category={"Comparison operators", "Points-related operators"}, concept={"point"})
    @GamlAnnotations.doc(value="true if the left-hand operand is greater or equals than the right-hand operand, false otherwise.", usages={@GamlAnnotations.usage(value="if both operands are points, returns true if and only if the left component (x) of the left operand if greater or equal than x of the right one and if the right component (y) of the left operand is greater than or equal to y of the right one.", examples={@GamlAnnotations.example(value="{5,7} >= {4,6}", equals="true"), @GamlAnnotations.example(value="{5,7} >= {4,8}", equals="false")})})
    public static Boolean greaterOrEqual(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint.x >= gamaPoint2.x && gamaPoint.y >= gamaPoint2.y) {
            return true;
        }
        return false;
    }

    public static class EqualValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            if (iExpressionArray.length > 1) {
                IType<?> iType = iExpressionArray[0].getGamlType();
                IType<?> iType2 = iExpressionArray[1].getGamlType();
                if (iType.id() == 0 || iType2.id() == 0 || iType.isTranslatableInto(iType2) || iType2.isTranslatableInto(iType)) {
                    return true;
                }
                iDescription.warning("This equality will always return false because you are comparing a " + String.valueOf(iType) + " with a " + String.valueOf(iType2), "gaml.unmatched.operands.issue", eObject, new String[0]);
            }
            return true;
        }
    }
}

