/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.operators.Maths;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.locationtech.jts.algorithm.Centroid;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.operation.distance.DistanceOp;

public class SpatialPunctal {
    @GamlAnnotations.operator(value={"centroid"}, category={"Spatial operators", "Points-related operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="Centroid (weighted sum of the centroids of a decomposition of the area into triangles) of the operand-geometry. Can be different to the location of the geometry", examples={@GamlAnnotations.example(value="centroid(world)", equals="the centroid of the square, for example : {50.0,50.0}.", test=false)}, see={"any_location_in", "closest_points_with", "farthest_point_to", "points_at"})
    @GamlAnnotations.test(value=" centroid(world) = {50.0, 50.0, 0.0} ")
    public static GamaPoint centroidArea(IScope iScope, IShape iShape) {
        if (iShape == null || iShape.getInnerGeometry() == null) {
            return null;
        }
        Centroid centroid = new Centroid(iShape.getInnerGeometry());
        return new GamaPoint(centroid.getCentroid());
    }

    @GamlAnnotations.operator(value={"any_location_in", "any_point_in"}, category={"Spatial operators", "Points-related operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="A point inside (or touching) the operand-geometry.", examples={@GamlAnnotations.example(value="any_location_in(square(5))", equals="a point in the square, for example : {3,4.6}.", test=false)}, see={"closest_points_with", "farthest_point_to", "points_at"})
    public static GamaPoint any_location_in(IScope iScope, IShape iShape) {
        return GeometryUtils.pointInGeom(iScope, iShape);
    }

    @GamlAnnotations.operator(value={"points_on"}, type=5, content_type=7, category={"Spatial operators", "Points-related operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="A list of points of the operand-geometry distant from each other to the float right-operand .", examples={@GamlAnnotations.example(value=" square(5) points_on(2)", equals="a list of points belonging to the exterior ring of the square distant from each other of 2.", test=false)}, see={"closest_points_with", "farthest_point_to", "points_at"})
    @GamlAnnotations.test(value="line({0,0},{0,10}) points_on 5 = [{0.0,0.0,0.0},{0.0,5.0,0.0},{0.0,10.0,0.0}]")
    public static IList points_on(IShape iShape, Double d) {
        IList iList = GamaListFactory.create(Types.POINT);
        if (iShape.getInnerGeometry() instanceof GeometryCollection) {
            int n = 0;
            while (n < iShape.getInnerGeometry().getNumGeometries()) {
                iList.addAll(GeometryUtils.locsOnGeometry(iShape.getInnerGeometry().getGeometryN(n), d));
                ++n;
            }
        } else {
            iList.addAll(GeometryUtils.locsOnGeometry(iShape.getInnerGeometry(), d));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"points_along"}, type=5, content_type=7, category={"Spatial operators", "Points-related operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="A list of points along the operand-geometry given its location in terms of rate of distance from the starting points of the geometry.", examples={@GamlAnnotations.example(value=" line([{10,10},{80,80}]) points_along ([0.3, 0.5, 0.9])", equals="the list of following points: [{31.0,31.0,0.0},{45.0,45.0,0.0},{73.0,73.0,0.0}]", test=false)}, see={"closest_points_with", "farthest_point_to", "points_at", "points_on"})
    @GamlAnnotations.test(value="line({0,0},{0,10}) points_along [0.50, 0.75] = [{0.0,5.0,0.0},{0.0,7.5,0.0}]")
    public static IList points_along(IShape iShape, IList<Double> iList) {
        IList iList2 = GamaListFactory.create(Types.POINT);
        if (iShape.getInnerGeometry() instanceof GeometryCollection) {
            int n = 0;
            while (n < iShape.getInnerGeometry().getNumGeometries()) {
                iList2.addAll(GeometryUtils.locsAlongGeometry(iShape.getInnerGeometry().getGeometryN(n), iList));
                ++n;
            }
        } else {
            iList2.addAll(GeometryUtils.locsAlongGeometry(iShape.getInnerGeometry(), iList));
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"points_at"}, content_type=7, category={"Spatial operators", "Points-related operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="A list of left-operand number of points located at a the right-operand distance to the agent location.", examples={@GamlAnnotations.example(value="3 points_at(20.0)", equals="returns [pt1, pt2, pt3] with pt1, pt2 and pt3 located at a distance of 20.0 to the agent location", test=false)}, see={"any_location_in", "any_point_in", "closest_points_with", "farthest_point_to"})
    public static IList<GamaPoint> points_at(IScope iScope, Integer n, Double d) {
        if (d == null || n == null) {
            throw GamaRuntimeException.error("Impossible to compute points_at", iScope);
        }
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        GamaPoint gamaPoint = iScope.getAgent().getLocation();
        double d2 = iScope.getRandom().between(0.0, Math.PI * 2);
        int n2 = 0;
        while (n2 < n) {
            GamaPoint gamaPoint2 = new GamaPoint(gamaPoint.getX() + d * Math.cos(d2 + (double)n2 / (double)n.intValue() * 2.0 * Math.PI), gamaPoint.getY() + d * Math.sin(d2 + (double)n2 / (double)n.intValue() * 2.0 * Math.PI));
            iList.add(gamaPoint2);
            ++n2;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"closest_points_with"}, type=5, content_type=7, category={"Spatial operators", "Points-related operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="A list of two closest points between the two geometries.", examples={@GamlAnnotations.example(value="geom1 closest_points_with(geom2)", equals="[pt1, pt2] with pt1 the closest point of geom1 to geom2 and pt1 the closest point of geom2 to geom1", isExecutable=false)}, see={"any_location_in", "any_point_in", "farthest_point_to", "points_at"})
    public static IList<GamaPoint> closest_points_with(IShape iShape, IShape iShape2) {
        Coordinate[] coordinateArray = DistanceOp.nearestPoints((Geometry)iShape.getInnerGeometry(), (Geometry)iShape2.getInnerGeometry());
        return GamaListFactory.wrap((IType)Types.POINT, new GamaPoint(coordinateArray[0]), new GamaPoint(coordinateArray[1]));
    }

    @GamlAnnotations.operator(value={"farthest_point_to"}, category={"Spatial operators", "Points-related operators"}, concept={"geometry", "spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="the farthest point of the left-operand to the left-point.", examples={@GamlAnnotations.example(value="geom farthest_point_to(pt)", equals="the farthest point of geom to pt", isExecutable=false)}, see={"any_location_in", "any_point_in", "closest_points_with", "points_at"})
    public static GamaPoint farthest_point_to(IShape iShape, GamaPoint gamaPoint) {
        if (iShape == null) {
            return gamaPoint.getLocation();
        }
        if (gamaPoint == null) {
            return iShape.getLocation();
        }
        Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
        if (coordinateArray.length == 0) {
            return gamaPoint;
        }
        Coordinate coordinate = coordinateArray[0];
        double d = gamaPoint.distance(coordinate);
        int n = 1;
        while (n < coordinateArray.length) {
            double d2 = gamaPoint.distance(coordinateArray[n]);
            if (d2 > d) {
                coordinate = coordinateArray[n];
                d = d2;
            }
            ++n;
        }
        return new GamaPoint(coordinate);
    }

    public static GamaPoint _closest_point_to(IShape iShape, IShape iShape2) {
        if (iShape == null) {
            return null;
        }
        if (iShape2 == null) {
            return iShape.getLocation();
        }
        Coordinate[] coordinateArray = new DistanceOp(iShape2.getInnerGeometry(), iShape.getInnerGeometry()).nearestPoints();
        return new GamaPoint(coordinateArray[0]);
    }

    public static GamaPoint _closest_point_to(GamaPoint gamaPoint, IShape iShape) {
        if (gamaPoint == null) {
            return null;
        }
        if (iShape == null) {
            return gamaPoint;
        }
        PointPairDistance pointPairDistance = new PointPairDistance();
        DistanceToPoint.computeDistance((Geometry)iShape.getInnerGeometry(), (Coordinate)gamaPoint, (PointPairDistance)pointPairDistance);
        return new GamaPoint(pointPairDistance.getCoordinate(0));
    }

    @GamlAnnotations.operator(value={"angle_between"}, category={"Spatial operators", "Points-related operators"}, concept={"spatial_computation", "spatial_relation", "point"})
    @GamlAnnotations.doc(value="the angle between vectors P0P1 and P0P2 (P0, P1, P2 being the three point operands)", examples={@GamlAnnotations.example(value="angle_between({5,5},{10,5},{5,10})", equals="90")})
    public static Double angleInDegreesBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3) {
        double d = gamaPoint2.x - gamaPoint.x;
        double d2 = gamaPoint2.y - gamaPoint.y;
        double d3 = gamaPoint3.x - gamaPoint.x;
        double d4 = gamaPoint3.y - gamaPoint.y;
        double d5 = Maths.sqrt(iScope, d * d + d2 * d2);
        double d6 = Maths.sqrt(iScope, d3 * d3 + d4 * d4);
        double d7 = Maths.round((d * d3 + d2 * d4) / (d5 * d6), 10);
        double d8 = d * d4 - d2 * d3;
        double d9 = d8 > 0.0 ? Maths.acos(d7) : -1.0 * Maths.acos(d7);
        return Maths.checkHeading(d9);
    }
}

