/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.BaseElementProcessor;
import gama.dependencies.osmosis.Bound;
import gama.dependencies.osmosis.BoundContainer;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.SourceElementProcessor;
import org.xml.sax.Attributes;

public class BoundsElementProcessor
extends SourceElementProcessor {
    private Bound bound;
    private final String defaultOrigin;

    public BoundsElementProcessor(BaseElementProcessor baseElementProcessor, Sink sink, boolean bl, String string) {
        super(baseElementProcessor, sink, bl);
        this.defaultOrigin = string;
    }

    @Override
    public void begin(Attributes attributes) {
        double d = this.getRequiredDoubleValue(attributes, "minlat");
        double d2 = this.getRequiredDoubleValue(attributes, "minlon");
        double d3 = this.getRequiredDoubleValue(attributes, "maxlat");
        double d4 = this.getRequiredDoubleValue(attributes, "maxlon");
        String string = attributes.getValue("origin");
        if (string == null) {
            string = this.defaultOrigin;
        }
        this.bound = new Bound(d4, d2, d3, d, string);
    }

    private double getRequiredDoubleValue(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new OsmosisRuntimeException(String.format("Required attribute %s of the bounds element is missing", string));
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmosisRuntimeException(String.format("Cannot parse the %s attribute of the bounds element", string), numberFormatException);
        }
    }

    @Override
    public void end() {
        this.getSink().process(new BoundContainer(this.bound));
        this.bound = null;
    }
}

