/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.dxf.helpers;

import gama.dependencies.kabeja.dxf.helpers.StyledTextParagraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextDocument {
    protected List<StyledTextParagraph> paragraphs = new ArrayList<StyledTextParagraph>();

    public String getText() {
        Iterator<StyledTextParagraph> iterator = this.paragraphs.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            StyledTextParagraph styledTextParagraph = iterator.next();
            stringBuilder.append(styledTextParagraph.getText());
            if (!styledTextParagraph.isNewline()) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void addStyledParagraph(StyledTextParagraph styledTextParagraph) {
        this.paragraphs.add(styledTextParagraph);
    }

    public Iterator getStyledParagraphIterator() {
        return this.paragraphs.iterator();
    }

    public int getParagraphCount() {
        return this.paragraphs.size();
    }

    public StyledTextParagraph getStyleTextParagraph(int n) {
        return this.paragraphs.get(n);
    }

    public int getLineCount() {
        int n = 1;
        for (StyledTextParagraph styledTextParagraph : this.paragraphs) {
            if (!styledTextParagraph.isNewline()) continue;
            ++n;
        }
        return n;
    }

    public int getMaximumLineLength() {
        int n = 0;
        int n2 = 0;
        for (StyledTextParagraph styledTextParagraph : this.paragraphs) {
            if (!styledTextParagraph.isNewline()) {
                n += styledTextParagraph.getLength();
                continue;
            }
            if (n > n2) {
                n2 = n;
            }
            n = styledTextParagraph.getLength();
        }
        return n2;
    }
}

