/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.parser.entities;

import gama.dependencies.kabeja.dxf.DXFArc;
import gama.dependencies.kabeja.dxf.DXFEntity;
import gama.dependencies.kabeja.parser.DXFValue;
import gama.dependencies.kabeja.parser.entities.AbstractEntityHandler;

public class DXFArcHandler
extends AbstractEntityHandler {
    public static final String ENTITY_NAME = "ARC";
    public static final int RADIUS = 40;
    public static final int START_ANGLE = 50;
    public static final int END_ANGLE = 51;
    public static final int COUNTERCLOCKWISE = 73;
    private DXFArc arc;

    @Override
    public void endDXFEntity() {
    }

    @Override
    public DXFEntity getDXFEntity() {
        return this.arc;
    }

    @Override
    public String getDXFEntityName() {
        return ENTITY_NAME;
    }

    @Override
    public boolean isFollowSequence() {
        return false;
    }

    @Override
    public void parseGroup(int n, DXFValue dXFValue) {
        switch (n) {
            case 10: {
                this.arc.getCenterPoint().setX(dXFValue.getDoubleValue());
                break;
            }
            case 20: {
                this.arc.getCenterPoint().setY(dXFValue.getDoubleValue());
                break;
            }
            case 40: {
                this.arc.setRadius(dXFValue.getDoubleValue());
                break;
            }
            case 50: {
                this.arc.setStartAngle(dXFValue.getDoubleValue());
                break;
            }
            case 51: {
                this.arc.setEndAngle(dXFValue.getDoubleValue());
                break;
            }
            case 73: {
                this.arc.setCounterClockwise(dXFValue.getBooleanValue());
                break;
            }
            default: {
                super.parseCommonProperty(n, dXFValue, this.arc);
            }
        }
    }

    @Override
    public void startDXFEntity() {
        this.arc = new DXFArc();
    }
}

