/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.osmosis;

import gama.dependencies.osmosis.LazyHashMap;
import gama.dependencies.osmosis.LongAsInt;
import gama.dependencies.osmosis.OsmUser;
import gama.dependencies.osmosis.OsmosisRuntimeException;
import gama.dependencies.osmosis.SimpleTimestampContainer;
import gama.dependencies.osmosis.StoreClassRegister;
import gama.dependencies.osmosis.StoreReader;
import gama.dependencies.osmosis.StoreWriter;
import gama.dependencies.osmosis.Storeable;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.TagCollection;
import gama.dependencies.osmosis.TagCollectionImpl;
import gama.dependencies.osmosis.TimestampContainer;
import gama.dependencies.osmosis.TimestampFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class CommonEntityData
implements Storeable {
    private long id;
    private int version;
    private int changesetId;
    private TimestampContainer timestampContainer;
    private OsmUser user;
    private TagCollection tags;
    private Map<String, Object> metaTags;
    private boolean readOnly;

    public CommonEntityData(long l, int n, Date date, OsmUser osmUser, long l2) {
        this(l, n, new SimpleTimestampContainer(date), osmUser, l2);
    }

    public CommonEntityData(long l, int n, TimestampContainer timestampContainer, OsmUser osmUser, long l2) {
        this.init(l, timestampContainer, osmUser, n, l2);
        this.tags = new TagCollectionImpl();
        this.metaTags = new LazyHashMap<String, Object>();
    }

    public CommonEntityData(long l, int n, Date date, OsmUser osmUser, long l2, Collection<Tag> collection) {
        this(l, n, new SimpleTimestampContainer(date), osmUser, l2, collection);
    }

    public CommonEntityData(long l, int n, TimestampContainer timestampContainer, OsmUser osmUser, long l2, Collection<Tag> collection) {
        this.init(l, timestampContainer, osmUser, n, l2);
        this.tags = new TagCollectionImpl((Collection<? extends Tag>)collection);
        this.metaTags = new LazyHashMap<String, Object>();
    }

    private void init(long l, TimestampContainer timestampContainer, OsmUser osmUser, int n, long l2) {
        this.id = l;
        this.timestampContainer = timestampContainer;
        this.user = osmUser;
        this.version = n;
        this.changesetId = LongAsInt.longToInt(l2);
    }

    private static TimestampContainer readTimestampContainer(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        if (storeReader.readBoolean()) {
            return new SimpleTimestampContainer(new Date(storeReader.readLong()));
        }
        return null;
    }

    private static OsmUser readOsmUser(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        OsmUser osmUser = new OsmUser(storeReader, storeClassRegister);
        if (osmUser.equals(OsmUser.NONE)) {
            return OsmUser.NONE;
        }
        return osmUser;
    }

    public CommonEntityData(StoreReader storeReader, StoreClassRegister storeClassRegister) {
        this(storeReader.readLong(), storeReader.readInteger(), CommonEntityData.readTimestampContainer(storeReader, storeClassRegister), CommonEntityData.readOsmUser(storeReader, storeClassRegister), (long)storeReader.readInteger(), (Collection<Tag>)new TagCollectionImpl(storeReader, storeClassRegister));
        int n = storeReader.readInteger();
        this.metaTags = new LazyHashMap<String, Object>();
        int n2 = 0;
        while (n2 < n) {
            this.metaTags.put(storeReader.readString(), storeReader.readString());
            ++n2;
        }
    }

    @Override
    public void store(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        storeWriter.writeLong(this.id);
        storeWriter.writeInteger(this.version);
        if (this.getTimestamp() != null) {
            storeWriter.writeBoolean(true);
            storeWriter.writeLong(this.timestampContainer.getTimestamp().getTime());
        } else {
            storeWriter.writeBoolean(false);
        }
        this.user.store(storeWriter, storeClassRegister);
        storeWriter.writeInteger(this.changesetId);
        this.tags.store(storeWriter, storeClassRegister);
        storeWriter.writeInteger(this.metaTags.size());
        for (Map.Entry<String, Object> entry : this.metaTags.entrySet()) {
            storeWriter.writeString(entry.getKey());
            storeWriter.writeString(entry.getValue().toString());
        }
    }

    protected int compareTags(Collection<Tag> collection) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>(this.tags);
        ArrayList<Tag> arrayList2 = new ArrayList<Tag>(collection);
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        if (arrayList.size() != arrayList2.size()) {
            return arrayList.size() - arrayList2.size();
        }
        int n = 0;
        while (n < arrayList.size()) {
            int n2 = ((Tag)arrayList.get(n)).compareTo((Tag)arrayList2.get(n));
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.assertWriteable();
        this.id = l;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.assertWriteable();
        this.version = n;
    }

    public Date getTimestamp() {
        return this.timestampContainer.getTimestamp();
    }

    public void setTimestamp(Date date) {
        this.assertWriteable();
        this.timestampContainer = new SimpleTimestampContainer(date);
    }

    public TimestampContainer getTimestampContainer() {
        return this.timestampContainer;
    }

    public void setTimestampContainer(TimestampContainer timestampContainer) {
        this.assertWriteable();
        this.timestampContainer = timestampContainer;
    }

    public String getFormattedTimestamp(TimestampFormat timestampFormat) {
        return this.timestampContainer.getFormattedTimestamp(timestampFormat);
    }

    public OsmUser getUser() {
        return this.user;
    }

    public void setUser(OsmUser osmUser) {
        this.assertWriteable();
        this.user = osmUser;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public void setChangesetId(long l) {
        this.assertWriteable();
        this.changesetId = LongAsInt.longToInt(l);
    }

    public Collection<Tag> getTags() {
        return this.tags;
    }

    public Map<String, Object> getMetaTags() {
        return this.metaTags;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void assertWriteable() {
        if (this.readOnly) {
            throw new OsmosisRuntimeException("The object has been marked as read-only.  It must be cloned to make changes.");
        }
    }

    public void makeReadOnly() {
        if (!this.readOnly) {
            this.tags = this.tags.toReadOnly();
            this.metaTags = Collections.unmodifiableMap(this.metaTags);
            this.readOnly = true;
        }
    }

    public CommonEntityData getWriteableInstance() {
        if (this.isReadOnly()) {
            return new CommonEntityData(this.id, this.version, this.timestampContainer, this.user, (long)this.changesetId, (Collection<Tag>)this.tags);
        }
        return this;
    }
}

